/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.serializer.spi.iobuffer;

import de.gsi.dataset.serializer.IoBuffer;
import de.gsi.dataset.serializer.spi.AbstractSerialiser;
import de.gsi.dataset.serializer.spi.BinarySerialiser;
import de.gsi.dataset.serializer.spi.GenericsHelper;
import de.gsi.dataset.serializer.spi.iobuffer.IoBufferFieldSerialiser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FieldBoxedValueArrayHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(FieldBoxedValueArrayHelper.class);

    private FieldBoxedValueArrayHelper() {
    }

    public static void register(AbstractSerialiser serialiser, IoBuffer ioBuffer) {
        serialiser.addClassDefinition(new IoBufferFieldSerialiser(ioBuffer, (obj, field) -> field.getField().set(obj, GenericsHelper.toObject(ioBuffer.getBooleanArray())), (obj, field) -> BinarySerialiser.put(ioBuffer, field.getFieldName(), GenericsHelper.toBoolPrimitive((Boolean[])field.getField().get(obj))), Boolean[].class, new Class[0]));
        serialiser.addClassDefinition(new IoBufferFieldSerialiser(ioBuffer, (obj, field) -> field.getField().set(obj, GenericsHelper.toObject(ioBuffer.getByteArray())), (obj, field) -> BinarySerialiser.put(ioBuffer, field.getFieldName(), GenericsHelper.toBytePrimitive((Byte[])field.getField().get(obj))), Byte[].class, new Class[0]));
        serialiser.addClassDefinition(new IoBufferFieldSerialiser(ioBuffer, (obj, field) -> field.getField().set(obj, GenericsHelper.toObject(ioBuffer.getShortArray())), (obj, field) -> BinarySerialiser.put(ioBuffer, field.getFieldName(), GenericsHelper.toShortPrimitive((Short[])field.getField().get(obj))), Short[].class, new Class[0]));
        serialiser.addClassDefinition(new IoBufferFieldSerialiser(ioBuffer, (obj, field) -> field.getField().set(obj, GenericsHelper.toObject(ioBuffer.getIntArray())), (obj, field) -> BinarySerialiser.put(ioBuffer, field.getFieldName(), GenericsHelper.toIntegerPrimitive((Integer[])field.getField().get(obj))), Integer[].class, new Class[0]));
        serialiser.addClassDefinition(new IoBufferFieldSerialiser(ioBuffer, (obj, field) -> field.getField().set(obj, GenericsHelper.toObject(ioBuffer.getLongArray())), (obj, field) -> BinarySerialiser.put(ioBuffer, field.getFieldName(), GenericsHelper.toLongPrimitive((Long[])field.getField().get(obj))), Long[].class, new Class[0]));
        serialiser.addClassDefinition(new IoBufferFieldSerialiser(ioBuffer, (obj, field) -> field.getField().set(obj, GenericsHelper.toObject(ioBuffer.getFloatArray())), (obj, field) -> BinarySerialiser.put(ioBuffer, field.getFieldName(), GenericsHelper.toFloatPrimitive((Float[])field.getField().get(obj))), Float[].class, new Class[0]));
        serialiser.addClassDefinition(new IoBufferFieldSerialiser(ioBuffer, (obj, field) -> field.getField().set(obj, GenericsHelper.toObject(ioBuffer.getDoubleArray())), (obj, field) -> BinarySerialiser.put(ioBuffer, field.getFieldName(), GenericsHelper.toDoublePrimitive((Double[])field.getField().get(obj))), Double[].class, new Class[0]));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.atDebug().addArgument((Object)serialiser).addArgument((Object)ioBuffer).log("initialised({}, {}");
        }
    }
}

