/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi;

import de.gsi.dataset.DataSet;
import de.gsi.dataset.DataSet3D;
import de.gsi.dataset.event.AddedDataEvent;
import de.gsi.dataset.event.EventListener;
import de.gsi.dataset.event.UpdateEvent;
import de.gsi.dataset.spi.DoubleDataSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DimReductionDataSet
extends DoubleDataSet
implements EventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(DimReductionDataSet.class);
    private static final long serialVersionUID = 1L;
    private final Option reductionOption;
    private final DataSet3D source;
    private final int dimIndex;
    private int minIndex;
    private int maxIndex;
    private double minValue;
    private double maxValue;

    public DimReductionDataSet(DataSet3D source, int dimIndex, Option reductionOption) {
        super(source.getName() + "-" + (Object)((Object)reductionOption) + "-dim" + dimIndex);
        this.source = source;
        this.dimIndex = dimIndex;
        this.reductionOption = reductionOption;
        this.source.addListener(this);
    }

    public int getMaxIndex() {
        return this.maxIndex;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public int getMinIndex() {
        return this.minIndex;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public Option getReductionOption() {
        return this.reductionOption;
    }

    public DataSet getSourceDataSet() {
        return this.source;
    }

    @Override
    public void handle(UpdateEvent event) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.atDebug().addArgument((Object)event).log("handle({})");
        }
        this.lock().writeLockGuard(() -> this.source.lock().readLockGuard(() -> {
            boolean oldValue = this.source.autoNotification().getAndSet(false);
            this.minIndex = this.source.getIndex(this.dimIndex == 0 ? 1 : 0, this.minValue);
            this.maxIndex = this.source.getIndex(this.dimIndex == 0 ? 1 : 0, this.maxValue);
            this.source.autoNotification().set(oldValue);
            switch (this.reductionOption) {
                case MIN: {
                    this.updateMinMax(true);
                    break;
                }
                case MAX: {
                    this.updateMinMax(false);
                    break;
                }
                case MEAN: {
                    this.updateMeanIntegral(true);
                    break;
                }
                case INTEGRAL: {
                    this.updateMeanIntegral(false);
                    break;
                }
                default: {
                    this.updateSlice();
                }
            }
        }));
        this.fireInvalidated(new AddedDataEvent(this, "updated " + DimReductionDataSet.class.getSimpleName() + " name = " + this.getName()));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.atDebug().addArgument((Object)event).log("handle({}) - done");
        }
    }

    public void setMaxValue(double val) {
        this.lock().writeLockGuard(() -> {
            this.maxValue = val;
        });
        this.handle(new UpdateEvent(this, "changed indexMax"));
    }

    public void setMinValue(double val) {
        this.lock().writeLockGuard(() -> {
            this.minValue = val;
            return this.minValue;
        });
        this.handle(new UpdateEvent(this, "changed indexMin"));
    }

    public void setRange(double min, double max) {
        this.lock().writeLockGuard(() -> {
            this.minValue = min;
            this.maxValue = max;
        });
        this.handle(new UpdateEvent(this, "changed indexMin indexMax"));
    }

    protected void updateMeanIntegral(boolean isMean) {
        int min = Math.min(this.minIndex, this.maxIndex);
        int max = Math.max(Math.max(this.minIndex, this.maxIndex), min + 1);
        this.clearData();
        int nDataCount = this.source.getDataCount(this.dimIndex);
        if (this.dimIndex == 1) {
            for (int index = 0; index < nDataCount; ++index) {
                double x = this.source.get(this.dimIndex, index);
                double integral = 0.0;
                double nSlices = 0.0;
                for (int i = min; i <= Math.min(max, nDataCount - 1); ++i) {
                    integral += this.source.getZ(i, index);
                    nSlices += 1.0;
                }
                this.add(x, isMean ? (nSlices == 0.0 ? Double.NaN : integral / nSlices) : integral);
            }
        } else {
            for (int index = 0; index < nDataCount; ++index) {
                double x = this.source.get(this.dimIndex, index);
                double integral = 0.0;
                double nSlices = 0.0;
                for (int i = min; i <= Math.min(max, nDataCount - 1); ++i) {
                    integral += this.source.getZ(index, i);
                    nSlices += 1.0;
                }
                this.add(x, isMean ? (nSlices == 0.0 ? Double.NaN : integral / nSlices) : integral);
            }
        }
    }

    protected void updateMinMax(boolean isMin) {
        int min = Math.min(this.minIndex, this.maxIndex);
        int max = Math.max(Math.max(this.minIndex, this.maxIndex), min + 1);
        this.clearData();
        int nDataCount = this.source.getDataCount(this.dimIndex);
        if (this.dimIndex == 1) {
            for (int index = 0; index < nDataCount; ++index) {
                double x = this.source.get(this.dimIndex, index);
                double ret = this.source.getZ(min, index);
                for (int i = min + 1; i <= Math.min(max, nDataCount - 1); ++i) {
                    double val = this.source.getZ(i, index);
                    ret = isMin ? Math.min(val, ret) : Math.max(val, ret);
                }
                this.add(x, ret);
            }
        } else {
            for (int index = 0; index < nDataCount; ++index) {
                double x = this.source.get(this.dimIndex, index);
                double ret = this.source.getZ(index, min);
                for (int i = min + 1; i <= Math.min(max, nDataCount - 1); ++i) {
                    double val = this.source.getZ(index, i);
                    ret = isMin ? Math.min(val, ret) : Math.max(val, ret);
                }
                this.add(x, ret);
            }
        }
    }

    protected void updateSlice() {
        this.clearData();
        int nDataCount = this.source.getDataCount(this.dimIndex);
        if (this.dimIndex == 1) {
            for (int index = 0; index < nDataCount; ++index) {
                double x = this.source.get(this.dimIndex, index);
                double y = this.source.getZ(this.minIndex, index);
                this.add(x, y);
            }
        } else {
            for (int index = 0; index < nDataCount; ++index) {
                double x = this.source.get(this.dimIndex, index);
                double y = this.source.getZ(index, this.minIndex);
                this.add(x, y);
            }
        }
    }

    public static enum Option {
        MIN,
        MEAN,
        MAX,
        INTEGRAL,
        SLICE;

    }
}

