/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi;

import de.gsi.dataset.event.RemovedDataEvent;
import de.gsi.dataset.spi.AbstractDataSet3D;
import de.gsi.dataset.utils.AssertUtils;
import java.util.Arrays;

public class DoubleDataSet3D
extends AbstractDataSet3D<DoubleDataSet3D> {
    private static final long serialVersionUID = 1289344630607938420L;
    private double[] xValues;
    private double[] yValues;
    private double[][] zValues;

    public DoubleDataSet3D(String name) {
        super(name);
        this.xValues = new double[0];
        this.yValues = new double[0];
        this.zValues = new double[0][0];
    }

    public DoubleDataSet3D(String name, double[] xValues, double[] yValues, double[][] zValues) {
        super(name);
        DoubleDataSet3D.checkDimensionConsistency(xValues, yValues, zValues);
        this.xValues = xValues;
        this.yValues = yValues;
        this.zValues = zValues;
    }

    public DoubleDataSet3D(String name, double[][] zValues) {
        super(name);
        this.yValues = new double[zValues.length];
        for (int y = 0; y < this.yValues.length; ++y) {
            this.yValues[y] = y;
        }
        if (this.yValues.length > 0) {
            this.xValues = new double[zValues[0].length];
            for (int x = 0; x < this.xValues.length; ++x) {
                this.xValues[x] = x;
            }
        } else {
            this.xValues = new double[0];
        }
        this.zValues = zValues;
    }

    public DoubleDataSet3D(String name, int dimX, int dimY) {
        super(name);
        this.zValues = new double[dimY][dimX];
        this.yValues = new double[this.zValues.length];
        for (int y = 0; y < this.yValues.length; ++y) {
            this.yValues[y] = y;
        }
        if (this.yValues.length > 0) {
            this.xValues = new double[this.zValues[0].length];
            for (int x = 0; x < this.xValues.length; ++x) {
                this.xValues[x] = x;
            }
        } else {
            this.xValues = new double[0];
        }
    }

    public DoubleDataSet3D clearData() {
        this.lock().writeLockGuard(() -> {
            for (int i = 0; i < this.zValues.length; ++i) {
                DoubleDataSet3D.fillArray(this.zValues[i], 0, this.zValues[i].length, 0.0);
            }
        });
        this.fireInvalidated(new RemovedDataEvent(this, "clearData()"));
        return this;
    }

    @Override
    public int getDataCount(int dimIndex) {
        if (dimIndex == 0) {
            return this.xValues.length;
        }
        if (dimIndex == 1) {
            return this.yValues.length;
        }
        return this.xValues.length * this.yValues.length;
    }

    @Override
    public String getStyle(int index) {
        return null;
    }

    @Override
    public final double get(int dimIndex, int index) {
        switch (dimIndex) {
            case 0: {
                return this.xValues[index];
            }
            case 1: {
                return this.yValues[index];
            }
            case 2: {
                return this.zValues[index / this.xValues.length][index % this.xValues.length];
            }
        }
        throw new IndexOutOfBoundsException("dimIndex cannot be < 2");
    }

    @Override
    public double getX(int i) {
        return this.xValues[i];
    }

    @Override
    public double[] getValues(int dimIndex) {
        switch (dimIndex) {
            case 0: {
                return Arrays.copyOf(this.xValues, this.xValues.length);
            }
            case 1: {
                return Arrays.copyOf(this.yValues, this.yValues.length);
            }
            case 2: {
                return super.getValues(dimIndex);
            }
        }
        throw new IndexOutOfBoundsException("dimIndex cannot be < 2");
    }

    @Override
    public double getZ(int xIndex, int yIndex) {
        return this.zValues[yIndex][xIndex];
    }

    public double[][] getZValues() {
        return this.zValues;
    }

    public void set(double[] xValues, double[] yValues, double[][] zValues) {
        DoubleDataSet3D.checkDimensionConsistency(xValues, yValues, zValues);
        this.xValues = xValues;
        this.yValues = yValues;
        this.zValues = zValues;
    }

    public void set(int xIndex, int yIndex, double z) {
        this.zValues[yIndex][xIndex] = z;
    }

    public void set(int xIndex, int yIndex, double x, double y, double z) {
        this.xValues[xIndex] = x;
        this.yValues[yIndex] = y;
        this.zValues[yIndex][xIndex] = z;
    }

    public void setX(int xIndex, double x) {
        this.xValues[xIndex] = x;
    }

    public void setY(int yIndex, double y) {
        this.yValues[yIndex] = y;
    }

    private static void checkDimensionConsistency(double[] xValues, double[] yValues, double[][] zValues) {
        if (xValues == null) {
            throw new IllegalArgumentException("xValues array is null");
        }
        if (yValues == null) {
            throw new IllegalArgumentException("yValues array is null");
        }
        if (zValues == null) {
            throw new IllegalArgumentException("zValues array is null");
        }
        if (zValues.length == 0) {
            if (0 != xValues.length || 0 != yValues.length) {
                String msg = String.format("array zValues is empty but: xValues.length = %d and yValues.length = %d", xValues.length, yValues.length);
                throw new IllegalArgumentException(msg);
            }
        } else {
            if (zValues.length != yValues.length) {
                String msg = String.format("array dimension mismatch: zValues.length = %d != yValues.length = %d", zValues.length, yValues.length);
                throw new IllegalArgumentException(msg);
            }
            if (zValues[0].length != xValues.length) {
                String msg = String.format("array dimension mismatch: zValues[0].length = %d != xValues.length = %d", zValues[0].length, xValues.length);
                throw new IllegalArgumentException(msg);
            }
        }
    }

    protected static void fillArray(double[] array, int indexStart, int indexStop, double value) {
        AssertUtils.notNull("array", array);
        int len = indexStop - indexStart;
        if (len > 0) {
            array[indexStart] = value;
        }
        for (int i = 1; i < len; i += i) {
            System.arraycopy(array, indexStart, array, indexStart + i, len - i < i ? len - i : i);
        }
    }
}

