/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi;

import de.gsi.dataset.AxisDescription;
import de.gsi.dataset.DataSet2D;
import de.gsi.dataset.event.AddedDataEvent;
import de.gsi.dataset.event.RemovedDataEvent;
import de.gsi.dataset.event.UpdatedDataEvent;
import de.gsi.dataset.spi.AbstractDataSet;
import de.gsi.dataset.spi.LabelledMarker;
import de.gsi.dataset.spi.utils.DoublePoint;
import de.gsi.dataset.utils.AssertUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class LabelledMarkerDataSet
extends AbstractDataSet<LabelledMarkerDataSet>
implements DataSet2D {
    private static final long serialVersionUID = -3267447868117053651L;
    protected ArrayList<String> dataLabels = new ArrayList();
    protected ArrayList<String> dataStyles = new ArrayList();
    protected ArrayList<DoublePoint> data = new ArrayList();

    public LabelledMarkerDataSet(String name) {
        super(name, 2);
    }

    public LabelledMarkerDataSet add(LabelledMarker marker) {
        AssertUtils.notNull("marker", marker);
        this.lock().writeLockGuard(() -> {
            this.data.add(new DoublePoint(marker.getX(), marker.getY()));
            this.getAxisDescription(0).add(marker.getX());
            this.dataLabels.add(marker.getLabel());
            this.dataStyles.add(marker.getStyle());
        });
        this.fireInvalidated(new AddedDataEvent(this));
        return this;
    }

    public LabelledMarkerDataSet clearData() {
        this.lock().writeLockGuard(() -> {
            this.data.clear();
            this.dataLabels.clear();
            this.dataStyles.clear();
            this.getAxisDescriptions().forEach(AxisDescription::clear);
        });
        return (LabelledMarkerDataSet)this.fireInvalidated(new RemovedDataEvent(this, "clear"));
    }

    @Override
    public double get(int dimIndex, int index) {
        return dimIndex == 0 ? this.data.get(index).getX() : this.data.get(index).getY();
    }

    public List<DoublePoint> getData() {
        return this.data;
    }

    @Override
    public int getDataCount() {
        return this.data.size();
    }

    @Override
    public int getDataCount(int dimIndex) {
        return this.dataLabels.size();
    }

    @Override
    public String getDataLabel(int index) {
        String dataLabel = this.dataLabels.get(index);
        if (dataLabel != null) {
            return dataLabel;
        }
        return super.getDataLabel(index);
    }

    public List<String> getDataLabels() {
        return this.dataLabels;
    }

    public List<String> getDataStyles() {
        return this.dataStyles;
    }

    @Override
    public String getStyle(int index) {
        return this.dataStyles.get(index);
    }

    public LabelledMarkerDataSet remove(int fromIndex, int toIndex) {
        this.lock().writeLockGuard(() -> {
            AssertUtils.indexInBounds(fromIndex, this.getDataCount(), "fromIndex");
            AssertUtils.indexInBounds(toIndex, this.getDataCount(), "toIndex");
            AssertUtils.indexOrder(fromIndex, "fromIndex", toIndex, "toIndex");
            this.data.subList(fromIndex, toIndex).clear();
            this.dataLabels.subList(fromIndex, toIndex).clear();
            this.dataStyles.subList(fromIndex, toIndex).clear();
            this.getAxisDescriptions().forEach(AxisDescription::clear);
        });
        return (LabelledMarkerDataSet)this.fireInvalidated(new RemovedDataEvent(this));
    }

    public LabelledMarkerDataSet set(int index, LabelledMarker marker) {
        AssertUtils.indexInBounds(index, this.getDataCount());
        this.lock().writeLockGuard(() -> {
            this.data.get(index).set(marker.getX(), marker.getY());
            this.getAxisDescription(0).add(marker.getX());
            this.dataLabels.set(index, marker.getLabel());
            this.dataStyles.set(index, marker.getStyle());
        });
        this.fireInvalidated(new UpdatedDataEvent(this));
        return this;
    }

    public LabelledMarkerDataSet set(LabelledMarker[] markers) {
        AssertUtils.notNull("markers", markers);
        return this.set(Arrays.asList(markers));
    }

    public LabelledMarkerDataSet set(List<LabelledMarker> markers) {
        AssertUtils.notNull("markers", markers);
        this.lock().writeLockGuard(() -> {
            this.data.clear();
            this.dataLabels.clear();
            this.dataStyles.clear();
            this.getAxisDescriptions().forEach(AxisDescription::clear);
            for (LabelledMarker marker : markers) {
                double x = marker.getX();
                double y = marker.getY();
                this.data.add(new DoublePoint(x, y));
                this.getAxisDescription(0).add(x);
                this.dataLabels.add(marker.getLabel());
                this.dataStyles.add(marker.getStyle());
            }
        });
        this.fireInvalidated(new UpdatedDataEvent(this, "fill"));
        return this;
    }
}

