/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.utils;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class Cache<K, V>
implements Map<K, V> {
    private ConcurrentHashMap<K, V> cache;
    private ChronoUnit chronoUnit;
    private ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(r -> {
        Thread t = Executors.defaultThreadFactory().newThread(r);
        t.setName(Cache.class.getCanonicalName() + "-Thread");
        t.setDaemon(true);
        return t;
    });
    private ConcurrentHashMap<K, Instant> timeOutMap;
    private int limit;
    private long timeOut;
    private TimeUnit timeUnit;

    private Cache() {
        this.cache = new ConcurrentHashMap();
        this.timeOutMap = new ConcurrentHashMap();
    }

    public Cache(int limit) {
        this(0L, TimeUnit.MILLISECONDS, limit);
    }

    public Cache(long timeOut, TimeUnit timeUnit) {
        this(timeOut, timeUnit, Integer.MAX_VALUE);
    }

    public Cache(long timeOut, TimeUnit timeUnit, int limit) {
        this();
        if (timeOut < 0L) {
            throw new IllegalArgumentException("Timeout cannot be negative");
        }
        if (timeOut > 0L && null == timeUnit) {
            throw new IllegalArgumentException("TimeUnit cannot be null if timeOut is > 0");
        }
        if (limit < 1) {
            throw new IllegalArgumentException("Limit cannot be smaller than 1");
        }
        this.timeOut = timeOut;
        this.timeUnit = timeUnit;
        this.chronoUnit = Cache.convertToChronoUnit(timeUnit);
        this.limit = limit;
        if (timeOut != 0L) {
            this.executor.scheduleAtFixedRate(this::checkTime, 0L, timeOut, timeUnit);
        }
    }

    protected void checkSize() {
        this.checkSize(1);
    }

    protected void checkSize(int nNewElements) {
        if (this.cache.size() < this.limit) {
            return;
        }
        int surplusEntries = Math.max(this.cache.size() - this.limit + nNewElements, 0);
        List toBeRemoved = this.timeOutMap.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).limit(surplusEntries).map(Map.Entry::getKey).collect(Collectors.toList());
        this.removeEntries(toBeRemoved);
    }

    protected void checkTime() {
        Instant cutoffTime = Instant.now().minus(this.timeOut, this.chronoUnit);
        List toBeRemoved = this.timeOutMap.entrySet().stream().filter(entry -> ((Instant)entry.getValue()).isBefore(cutoffTime)).map(Map.Entry::getKey).collect(Collectors.toList());
        this.removeEntries(toBeRemoved);
    }

    @Override
    public void clear() {
        this.cache.clear();
        this.timeOutMap.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.cache.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.cache.containsValue(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.cache.entrySet();
    }

    @Override
    public V get(Object key) {
        return this.getIfPresent(key);
    }

    public V getIfPresent(Object key) {
        return this.cache.getOrDefault(key, null);
    }

    public long getLimit() {
        return this.limit;
    }

    public Optional<V> getOptional(K key) {
        return Optional.ofNullable(this.getIfPresent(key));
    }

    public int getSize() {
        return this.cache.size();
    }

    public long getTimeout() {
        return this.timeOut;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    @Override
    public boolean isEmpty() {
        return this.cache.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.cache.keySet();
    }

    @Override
    public V put(K key, V VALUE) {
        this.checkSize();
        V val = this.cache.putIfAbsent(key, VALUE);
        this.timeOutMap.putIfAbsent(key, Instant.now());
        return val;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.checkSize(m.size());
        this.cache.putAll(m);
        Instant now = Instant.now();
        for (K key : m.keySet()) {
            this.timeOutMap.putIfAbsent(key, now);
        }
    }

    @Override
    public V remove(Object key) {
        V val = this.cache.remove(key);
        this.timeOutMap.remove(key);
        return val;
    }

    private void removeEntries(List<K> toBeRemoved) {
        toBeRemoved.forEach((? super T key) -> {
            this.timeOutMap.remove(key);
            this.cache.remove(key);
        });
    }

    @Override
    public int size() {
        return this.cache.size();
    }

    @Override
    public Collection<V> values() {
        return this.cache.values();
    }

    public static CacheBuilder builder() {
        return new CacheBuilder();
    }

    protected static int clamp(int min, int max, int value) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    protected static long clamp(long min, long max, long value) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    protected static ChronoUnit convertToChronoUnit(TimeUnit timeUnit) {
        switch (timeUnit) {
            case NANOSECONDS: {
                return ChronoUnit.NANOS;
            }
            case MICROSECONDS: {
                return ChronoUnit.MICROS;
            }
            case SECONDS: {
                return ChronoUnit.SECONDS;
            }
            case MINUTES: {
                return ChronoUnit.MINUTES;
            }
            case HOURS: {
                return ChronoUnit.HOURS;
            }
            case DAYS: {
                return ChronoUnit.DAYS;
            }
        }
        return ChronoUnit.MILLIS;
    }

    public static class CacheBuilder {
        private int limit = Integer.MAX_VALUE;
        private long timeOut = 0L;
        private TimeUnit timeUnit = TimeUnit.MILLISECONDS;

        private CacheBuilder() {
        }

        public <K, V> Cache<K, V> build() {
            return new Cache(this.timeOut, this.timeUnit, this.limit);
        }

        public CacheBuilder withLimit(int limit) {
            if (limit < 1) {
                throw new IllegalArgumentException("Limit cannot be smaller than 1");
            }
            this.limit = limit;
            return this;
        }

        public CacheBuilder withTimeout(long timeOut, TimeUnit timeUnit) {
            if (timeOut < 0L) {
                throw new IllegalArgumentException("Timeout cannot be negative");
            }
            if (null == timeUnit) {
                throw new IllegalArgumentException("TimeUnit cannot be null");
            }
            this.timeOut = Cache.clamp(0L, Integer.MAX_VALUE, timeOut);
            this.timeUnit = timeUnit;
            return this;
        }
    }
}

