/*
 * Decompiled with CFR 0.152.
 */
package de.halcony.appanalyzer.analysis;

import de.halcony.appanalyzer.Config;
import de.halcony.appanalyzer.Experiment$;
import de.halcony.appanalyzer.analysis.Analysis$;
import de.halcony.appanalyzer.analysis.exceptions.AnalysisFatal;
import de.halcony.appanalyzer.analysis.exceptions.InterfaceAnalysisCondition;
import de.halcony.appanalyzer.analysis.exceptions.MissingInterfaceElement;
import de.halcony.appanalyzer.analysis.exceptions.UncaughtCondition;
import de.halcony.appanalyzer.analysis.interaction.Interface;
import de.halcony.appanalyzer.analysis.interaction.Interface$;
import de.halcony.appanalyzer.analysis.interaction.InterfaceElementInteraction;
import de.halcony.appanalyzer.analysis.plugin.ActorPlugin;
import de.halcony.appanalyzer.analysis.trafficcollection.TrafficCollection;
import de.halcony.appanalyzer.analysis.trafficcollection.TrafficCollection$;
import de.halcony.appanalyzer.appbinary.MobileApp;
import de.halcony.appanalyzer.database.Postgres$;
import de.halcony.appanalyzer.platform.PlatformOS$;
import de.halcony.appanalyzer.platform.appium.Appium;
import de.halcony.appanalyzer.platform.appium.Appium$;
import de.halcony.appanalyzer.platform.appium.iOSAppium;
import de.halcony.appanalyzer.platform.device.Device;
import de.halcony.appanalyzer.platform.exceptions.AppClosedItself;
import de.halcony.appanalyzer.platform.exceptions.FatalError;
import de.halcony.appanalyzer.platform.exceptions.FridaDied;
import java.io.Serializable;
import java.time.ZonedDateTime;
import scala.;
import scala.$less$colon$less$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.UninitializedFieldError;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scalikejdbc.ConnectionPoolContext;
import scalikejdbc.DBSession;
import scalikejdbc.GeneralizedTypeConstraintsForWithExtractor;
import scalikejdbc.SQLInterpolationString$;
import scalikejdbc.SQLToOption;
import scalikejdbc.package$;
import spray.json.JsObject$;
import spray.json.JsString;
import wvlet.log.LazyLogger;
import wvlet.log.LogLevel;
import wvlet.log.LogSource;
import wvlet.log.LogSupport;
import wvlet.log.Logger;
import wvlet.log.LoggingMethods;

@ScalaSignature(bytes="\u0006\u0005\t5d\u0001B\u001c9\u0011\u0005C\u0001\u0002\u0015\u0001\u0003\u0002\u0003\u0006I!\u0015\u0005\t9\u0002\u0011\t\u0011)A\u0005;\"A1\r\u0001B\u0001B\u0003%A\r\u0003\u0005k\u0001\t\u0005\t\u0015!\u0003l\u0011!\u0011\bA!A!\u0002\u0013\u0019\b\"B<\u0001\t\u0003A\b\"CA\u0001\u0001\u0001\u0007I\u0011BA\u0002\u0011%\t\t\u0002\u0001a\u0001\n\u0013\t\u0019\u0002\u0003\u0005\u0002 \u0001\u0001\u000b\u0015BA\u0003\u0011%\t\t\u0003\u0001a\u0001\n\u0013\t\u0019\u0003C\u0005\u00024\u0001\u0001\r\u0011\"\u0003\u00026!A\u0011\u0011\b\u0001!B\u0013\t)\u0003C\u0005\u0002<\u0001\u0001\r\u0011\"\u0003\u0002>!I\u0011\u0011\u000b\u0001A\u0002\u0013%\u00111\u000b\u0005\t\u0003/\u0002\u0001\u0015)\u0003\u0002@!I\u0011\u0011\f\u0001A\u0002\u0013%\u00111\f\u0005\n\u0003G\u0002\u0001\u0019!C\u0005\u0003KB\u0001\"!\u001b\u0001A\u0003&\u0011Q\f\u0005\n\u0003W\u0002\u0001\u0019!C\u0005\u00037B\u0011\"!\u001c\u0001\u0001\u0004%I!a\u001c\t\u0011\u0005M\u0004\u0001)Q\u0005\u0003;Bq!!\u001e\u0001\t\u0013\t9\bC\u0004\u0002~\u0001!\t!a\u0017\t\u000f\u0005}\u0004\u0001\"\u0003\u0002\u0002\"9\u00111\u0011\u0001\u0005\u0002\u0005\u0005\u0005bBAC\u0001\u0011\u0005\u0011q\u0011\u0005\b\u0003\u0013\u0003A\u0011AAA\u0011\u001d\tY\t\u0001C\u0001\u0003\u001bCq!!*\u0001\t\u0003\t9\u000bC\u0004\u0002*\u0002!\t!!!\t\u000f\u0005-\u0006\u0001\"\u0001\u0002.\"I\u0011Q\u0017\u0001\u0012\u0002\u0013\u0005\u0011q\u0017\u0005\b\u0003\u001b\u0004A\u0011AAh\u0011\u001d\t)\u000e\u0001C\u0005\u0003/Dq!!<\u0001\t#\t\t\tC\u0004\u0002p\u0002!\t\"!!\t\u000f\u0005E\b\u0001\"\u0005\u0002t\"9\u0011\u0011 \u0001\u0005\u0002\u0005m\b\"\u0003B\u000e\u0001E\u0005I\u0011AA\\\u0011%\u0011i\u0002AI\u0001\n\u0003\u0011ybB\u0004\u0003$aB\tA!\n\u0007\r]B\u0004\u0012\u0001B\u0014\u0011\u00199(\u0006\"\u0001\u0003*\u00191!1\u0006\u0016\u0001\u0005[Aaa\u001e\u0017\u0005\u0002\t=\u0002b\u0002B\u001bY\u0011\u0005#q\u0007\u0005\n\u0005sQ\u0003\u0019!C\u0005\u0005wA\u0011Ba\u0010+\u0001\u0004%IA!\u0011\t\u0011\t\u0015#\u0006)Q\u0005\u0005{AqAa\u0012+\t\u0013\u0011I\u0005C\u0004\u0003N)\"I!!!\t\u000f\t=#\u0006\"\u0003\u0002\u0002\"9!\u0011\u000b\u0016\u0005\u0002\tM\u0003\"\u0003B/U\u0005\u0005I\u0011\u0002B0\u0005!\te.\u00197zg&\u001c(BA\u001d;\u0003!\tg.\u00197zg&\u001c(BA\u001e=\u0003-\t\u0007\u000f]1oC2L(0\u001a:\u000b\u0005ur\u0014a\u00025bY\u000e|g.\u001f\u0006\u0002\u007f\u0005\u0011A-Z\u0002\u0001'\r\u0001!\t\u0013\t\u0003\u0007\u001ak\u0011\u0001\u0012\u0006\u0002\u000b\u0006)1oY1mC&\u0011q\t\u0012\u0002\u0007\u0003:L(+\u001a4\u0011\u0005%sU\"\u0001&\u000b\u0005-c\u0015a\u00017pO*\tQ*A\u0003xm2,G/\u0003\u0002P\u0015\nQAj\\4TkB\u0004xN\u001d;\u0002\u0017\u0011,7o\u0019:jaRLwN\u001c\t\u0003%fs!aU,\u0011\u0005Q#U\"A+\u000b\u0005Y\u0003\u0015A\u0002\u001fs_>$h(\u0003\u0002Y\t\u00061\u0001K]3eK\u001aL!AW.\u0003\rM#(/\u001b8h\u0015\tAF)A\u0002baB\u0004\"AX1\u000e\u0003}S!\u0001\u0019\u001e\u0002\u0013\u0005\u0004\bOY5oCJL\u0018B\u00012`\u0005%iuNY5mK\u0006\u0003\b/A\u0003bGR|'\u000f\u0005\u0002fQ6\taM\u0003\u0002hq\u00051\u0001\u000f\\;hS:L!!\u001b4\u0003\u0017\u0005\u001bGo\u001c:QYV<\u0017N\\\u0001\u0007I\u00164\u0018nY3\u0011\u00051\u0004X\"A7\u000b\u0005)t'BA8;\u0003!\u0001H.\u0019;g_Jl\u0017BA9n\u0005\u0019!UM^5dK\u0006!1m\u001c8g!\t!X/D\u0001;\u0013\t1(H\u0001\u0004D_:4\u0017nZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\re\\H0 @\u0000!\tQ\b!D\u00019\u0011\u0015\u0001f\u00011\u0001R\u0011\u0015af\u00011\u0001^\u0011\u0015\u0019g\u00011\u0001e\u0011\u0015Qg\u00011\u0001l\u0011\u0015\u0011h\u00011\u0001t\u0003\tIG-\u0006\u0002\u0002\u0006A)1)a\u0002\u0002\f%\u0019\u0011\u0011\u0002#\u0003\r=\u0003H/[8o!\r\u0019\u0015QB\u0005\u0004\u0003\u001f!%aA%oi\u00061\u0011\u000eZ0%KF$B!!\u0006\u0002\u001cA\u00191)a\u0006\n\u0007\u0005eAI\u0001\u0003V]&$\b\"CA\u000f\u0011\u0005\u0005\t\u0019AA\u0003\u0003\rAH%M\u0001\u0004S\u0012\u0004\u0013aF1di&4X\r\u0016:bM\u001aL7mQ8mY\u0016\u001cG/[8o+\t\t)\u0003E\u0003D\u0003\u000f\t9\u0003\u0005\u0003\u0002*\u0005=RBAA\u0016\u0015\r\ti\u0003O\u0001\u0012iJ\fgMZ5dG>dG.Z2uS>t\u0017\u0002BA\u0019\u0003W\u0011\u0011\u0003\u0016:bM\u001aL7mQ8mY\u0016\u001cG/[8o\u0003m\t7\r^5wKR\u0013\u0018M\u001a4jG\u000e{G\u000e\\3di&|gn\u0018\u0013fcR!\u0011QCA\u001c\u0011%\tibCA\u0001\u0002\u0004\t)#\u0001\rbGRLg/\u001a+sC\u001a4\u0017nY\"pY2,7\r^5p]\u0002\na\u0003\u001e:bM\u001aL7mQ8mY\u0016\u001cG/[8o'R\f'\u000f^\u000b\u0003\u0003\u007f\u0001RaQA\u0004\u0003\u0003\u0002B!a\u0011\u0002N5\u0011\u0011Q\t\u0006\u0005\u0003\u000f\nI%\u0001\u0003uS6,'BAA&\u0003\u0011Q\u0017M^1\n\t\u0005=\u0013Q\t\u0002\u000e5>tW\r\u001a#bi\u0016$\u0016.\\3\u00025Q\u0014\u0018M\u001a4jG\u000e{G\u000e\\3di&|gn\u0015;beR|F%Z9\u0015\t\u0005U\u0011Q\u000b\u0005\n\u0003;q\u0011\u0011!a\u0001\u0003\u007f\tq\u0003\u001e:bM\u001aL7mQ8mY\u0016\u001cG/[8o'R\f'\u000f\u001e\u0011\u0002\tM$x\u000e]\u000b\u0003\u0003;\u00022aQA0\u0013\r\t\t\u0007\u0012\u0002\b\u0005>|G.Z1o\u0003!\u0019Ho\u001c9`I\u0015\fH\u0003BA\u000b\u0003OB\u0011\"!\b\u0012\u0003\u0003\u0005\r!!\u0018\u0002\u000bM$x\u000e\u001d\u0011\u0002\u000fI,hN\\5oO\u0006Y!/\u001e8oS:<w\fJ3r)\u0011\t)\"!\u001d\t\u0013\u0005uA#!AA\u0002\u0005u\u0013\u0001\u0003:v]:Lgn\u001a\u0011\u0002\u0015M,GOU;o]&tw\r\u0006\u0003\u0002\u0016\u0005e\u0004bBA>-\u0001\u0007\u0011QL\u0001\u0006m\u0006dW/Z\u0001\u000bO\u0016$(+\u001e8oS:<\u0017aB:fiN#x\u000e\u001d\u000b\u0003\u0003+\t\u0011b\u00195fG.\u001cFo\u001c9\u0002\u000b\u001d,G/\u00133\u0016\u0005\u0005-\u0011aG:uCJ$H)^7nsR\u0013\u0018M\u001a4jG\u000e{G\u000e\\3di&|g.\u0001\fti\u0006\u0014H\u000f\u0016:bM\u001aL7mQ8mY\u0016\u001cG/[8o)\u0019\t)\"a$\u0002\"\"9\u0011\u0011\u0013\u000fA\u0002\u0005M\u0015a\u0002:fY\u0006$X\r\u001a\t\u0006\u0007\u0006\u001d\u0011Q\u0013\t\u0005\u0003/\u000bi*\u0004\u0002\u0002\u001a*\u0019\u00111\u0014\u001d\u0002\u0017%tG/\u001a:bGRLwN\\\u0005\u0005\u0003?\u000bIJA\u0005J]R,'OZ1dK\"1\u00111\u0015\u000fA\u0002E\u000bqaY8n[\u0016tG/A\rhKR$&/\u00194gS\u000e\u001cu\u000e\u001c7fGRLwN\\*uCJ$XCAA!\u0003U\u0019Ho\u001c9Ue\u00064g-[2D_2dWm\u0019;j_:\fAdY8mY\u0016\u001cGoQ;se\u0016tG/\u00119q!J,g-\u001a:f]\u000e,7\u000f\u0006\u0004\u0002\u0016\u0005=\u0016\u0011\u0017\u0005\u0007\u0003G{\u0002\u0019A)\t\u0013\u0005Mv\u0004%AA\u0002\u0005\u0015\u0011aB2p]R,\u0007\u0010^\u0001'G>dG.Z2u\u0007V\u0014(/\u001a8u\u0003B\u0004\bK]3gKJ,gnY3tI\u0011,g-Y;mi\u0012\u0012TCAA]U\u0011\t)!a/,\u0005\u0005u\u0006\u0003BA`\u0003\u0013l!!!1\u000b\t\u0005\r\u0017QY\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a2E\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u0017\f\tMA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f\u0001d\u00195fG.Le-\u00119q\u0013N\u001cF/\u001b7m%Vtg.\u001b8h)\u0011\ti&!5\t\u000f\u0005M\u0017\u00051\u0001\u0002^\u0005!a-Y5m\u0003QA\u0017M\u001c3mKB{7\u000f^!qaN#\u0018M\u001d;vaRA\u0011QSAm\u0003;\fY\u000f\u0003\u0004\u0002\\\n\u0002\r!U\u0001\u0011S:$XM\u001d4bG\u0016\u001cu.\\7f]RDq!a8#\u0001\u0004\t\t/\u0001\u0004baBLW/\u001c\t\u0005\u0003G\f9/\u0004\u0002\u0002f*\u0019\u0011q\u001c8\n\t\u0005%\u0018Q\u001d\u0002\u0007\u0003B\u0004\u0018.^7\t\u000b)\u0014\u0003\u0019A6\u0002\u001fA,'OZ8s[\u0006s\u0017\r\\=tSN\fa!\u001b8tKJ$\u0018A\u00024j]&\u001c\b\u000e\u0006\u0003\u0002\u0016\u0005U\bbBA|K\u0001\u0007\u0011QL\u0001\bgV\u001c7-Z:t\u0003M\tG\rZ#oG>,h\u000e^3sK\u0012,%O]8s)!\t)\"!@\u0003\u0014\t]\u0001bBA\u0000M\u0001\u0007!\u0011A\u0001\u0004KJ\u0014\b\u0003\u0002B\u0002\u0005\u001bqAA!\u0002\u0003\n9\u0019AKa\u0002\n\u0003\u0015K1Aa\u0003E\u0003\u001d\u0001\u0018mY6bO\u0016LAAa\u0004\u0003\u0012\tIA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u0004\u0005\u0017!\u0005\"\u0003B\u000bMA\u0005\t\u0019AA\u0003\u0003-Ig\u000e^3sM\u0006\u001cW-\u001b3\t\u0013\tea\u0005%AA\u0002\u0005u\u0013AB:jY\u0016tG/A\u000fbI\u0012,enY8v]R,'/\u001a3FeJ|'\u000f\n3fM\u0006,H\u000e\u001e\u00133\u0003u\tG\rZ#oG>,h\u000e^3sK\u0012,%O]8sI\u0011,g-Y;mi\u0012\u001aTC\u0001B\u0011U\u0011\ti&a/\u0002\u0011\u0005s\u0017\r\\=tSN\u0004\"A\u001f\u0016\u0014\u0007)\u0012\u0005\n\u0006\u0002\u0003&\t\u0019\u0012I\\1msNL7\u000fV8pWR{w\u000eT8oON\u0019AF!\u0001\u0015\u0005\tE\u0002c\u0001B\u001aY5\t!&\u0001\u0006hKRlUm]:bO\u0016$\u0012!U\u0001\u0010GV\u0014(/\u001a8u\u0003:\fG._:jgV\u0011!Q\b\t\u0005\u0007\u0006\u001d\u00110A\ndkJ\u0014XM\u001c;B]\u0006d\u0017p]5t?\u0012*\u0017\u000f\u0006\u0003\u0002\u0016\t\r\u0003\"CA\u000fa\u0005\u0005\t\u0019\u0001B\u001f\u0003A\u0019WO\u001d:f]R\fe.\u00197zg&\u001c\b%\u0001\ntKR\u001cUO\u001d:f]R\fe.\u00197zg&\u001cH\u0003BA\u000b\u0005\u0017BQ!\u000f\u001aA\u0002e\f1c\u001d;pa\u000e+(O]3oi\u0006s\u0017\r\\=tSN\fA#\u001e8tKR\u001cUO\u001d:f]R\fe.\u00197zg&\u001c\u0018a\u0003:v]\u0006s\u0017\r\\=tSN$\"\"!\u0006\u0003V\t]#\u0011\fB.\u0011\u0015\u0019W\u00071\u0001e\u0011\u0015aV\u00071\u0001^\u0011\u0015QW\u00071\u0001l\u0011\u0015\u0011X\u00071\u0001t\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0011\t\u0007\u0005\u0003\u0003d\t%TB\u0001B3\u0015\u0011\u00119'!\u0013\u0002\t1\fgnZ\u0005\u0005\u0005W\u0012)G\u0001\u0004PE*,7\r\u001e")
public class Analysis
implements LogSupport {
    private final String description;
    private final MobileApp app;
    private final ActorPlugin actor;
    private final Device device;
    private final Config conf;
    private Option<Object> id;
    private Option<TrafficCollection> activeTrafficCollection;
    private Option<ZonedDateTime> trafficCollectionStart;
    private boolean stop;
    private boolean running;
    private Logger logger;
    private volatile boolean bitmap$0;
    private volatile byte bitmap$init$0;

    public static void runAnalysis(ActorPlugin actor, MobileApp app, Device device, Config conf) {
        Analysis$.MODULE$.runAnalysis(actor, app, device, conf);
    }

    private Logger logger$lzycompute() {
        Analysis analysis = this;
        synchronized (analysis) {
            if (!this.bitmap$0) {
                this.logger = LazyLogger.logger$((LazyLogger)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    private Option<Object> id() {
        if ((byte)(this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/simon/tools/mobile-analysis/scala-appanalyzer/src/main/scala/de/halcony/appanalyzer/analysis/Analysis.scala: 46");
        }
        return this.id;
    }

    private void id_$eq(Option<Object> x$1) {
        this.id = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
    }

    private Option<TrafficCollection> activeTrafficCollection() {
        if ((byte)(this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/simon/tools/mobile-analysis/scala-appanalyzer/src/main/scala/de/halcony/appanalyzer/analysis/Analysis.scala: 47");
        }
        return this.activeTrafficCollection;
    }

    private void activeTrafficCollection_$eq(Option<TrafficCollection> x$1) {
        this.activeTrafficCollection = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
    }

    private Option<ZonedDateTime> trafficCollectionStart() {
        if ((byte)(this.bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/simon/tools/mobile-analysis/scala-appanalyzer/src/main/scala/de/halcony/appanalyzer/analysis/Analysis.scala: 48");
        }
        return this.trafficCollectionStart;
    }

    private void trafficCollectionStart_$eq(Option<ZonedDateTime> x$1) {
        this.trafficCollectionStart = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
    }

    private boolean stop() {
        if ((byte)(this.bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/simon/tools/mobile-analysis/scala-appanalyzer/src/main/scala/de/halcony/appanalyzer/analysis/Analysis.scala: 49");
        }
        return this.stop;
    }

    private void stop_$eq(boolean x$1) {
        this.stop = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 8);
    }

    private boolean running() {
        if ((byte)(this.bitmap$init$0 & 0x10) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/simon/tools/mobile-analysis/scala-appanalyzer/src/main/scala/de/halcony/appanalyzer/analysis/Analysis.scala: 50");
        }
        return this.running;
    }

    private void running_$eq(boolean x$1) {
        this.running = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x10);
    }

    private synchronized void setRunning(boolean value) {
        this.running_$eq(value);
    }

    public synchronized boolean getRunning() {
        return this.running();
    }

    public synchronized void de$halcony$appanalyzer$analysis$Analysis$$setStop() {
        this.stop_$eq(true);
    }

    public synchronized void checkStop() {
        if (this.stop()) {
            throw new AnalysisTookTooLong();
        }
    }

    public int getId() {
        return BoxesRunTime.unboxToInt((Object)this.id().get());
    }

    public void startDummyTrafficCollection() {
        BoxedUnit boxedUnit;
        if (this.logger().isEnabled((LogLevel)LogLevel.INFO$.MODULE$)) {
            this.logger().log((LogLevel)LogLevel.INFO$.MODULE$, new LogSource("/home/simon/tools/mobile-analysis/scala-appanalyzer/src/main/scala/de/halcony/appanalyzer/analysis/Analysis.scala", "Analysis.scala", 77, 9), (Object)"starting dummy traffic collection");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Option<TrafficCollection> option = this.activeTrafficCollection();
        if (option instanceof Some) {
            BoxedUnit boxedUnit2;
            if (this.logger().isEnabled((LogLevel)LogLevel.WARN$.MODULE$)) {
                this.logger().log((LogLevel)LogLevel.WARN$.MODULE$, new LogSource("/home/simon/tools/mobile-analysis/scala-appanalyzer/src/main/scala/de/halcony/appanalyzer/analysis/Analysis.scala", "Analysis.scala", 80, 13), (Object)"there is already an active traffic collection");
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit3 = boxedUnit2;
        } else if (None$.MODULE$.equals(option)) {
            this.activeTrafficCollection_$eq((Option<TrafficCollection>)new Some((Object)TrafficCollection$.MODULE$.startDumbTrafficCollection(this.conf)));
            this.trafficCollectionStart_$eq((Option<ZonedDateTime>)new Some((Object)ZonedDateTime.now()));
            BoxedUnit boxedUnit4 = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
    }

    public void startTrafficCollection(Option<Interface> related, String comment) {
        None$ none$;
        BoxedUnit boxedUnit;
        if (this.logger().isEnabled((LogLevel)LogLevel.INFO$.MODULE$)) {
            this.logger().log((LogLevel)LogLevel.INFO$.MODULE$, new LogSource("/home/simon/tools/mobile-analysis/scala-appanalyzer/src/main/scala/de/halcony/appanalyzer/analysis/Analysis.scala", "Analysis.scala", 90, 9), (Object)"starting traffic collection");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Option<Interface> option = related;
        if (option instanceof Some) {
            Some some = (Some)option;
            Interface value = (Interface)some.value();
            none$ = new Some((Object)BoxesRunTime.boxToInteger((int)value.getId()));
        } else if (None$.MODULE$.equals(option)) {
            none$ = None$.MODULE$;
        } else {
            throw new MatchError(option);
        }
        None$ interfaceId = none$;
        Option<TrafficCollection> option2 = this.activeTrafficCollection();
        if (option2 instanceof Some) {
            BoxedUnit boxedUnit2;
            if (this.logger().isEnabled((LogLevel)LogLevel.WARN$.MODULE$)) {
                this.logger().log((LogLevel)LogLevel.WARN$.MODULE$, new LogSource("/home/simon/tools/mobile-analysis/scala-appanalyzer/src/main/scala/de/halcony/appanalyzer/analysis/Analysis.scala", "Analysis.scala", 97, 13), (Object)"there is an already active traffic collection");
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit3 = boxedUnit2;
        } else if (None$.MODULE$.equals(option2)) {
            this.activeTrafficCollection_$eq((Option<TrafficCollection>)new Some((Object)TrafficCollection$.MODULE$.startNewTrafficCollection(this.getId(), (Option<Object>)interfaceId, comment, this.conf)));
            this.trafficCollectionStart_$eq((Option<ZonedDateTime>)new Some((Object)ZonedDateTime.now()));
            BoxedUnit boxedUnit4 = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option2);
        }
    }

    public ZonedDateTime getTrafficCollectionStart() {
        return (ZonedDateTime)this.trafficCollectionStart().getOrElse((Function0 & Serializable)() -> {
            throw new FatalError("requesting traffic collection start time without ever starting traffic collection");
        });
    }

    public void stopTrafficCollection() {
        BoxedUnit boxedUnit;
        if (this.logger().isEnabled((LogLevel)LogLevel.INFO$.MODULE$)) {
            this.logger().log((LogLevel)LogLevel.INFO$.MODULE$, new LogSource("/home/simon/tools/mobile-analysis/scala-appanalyzer/src/main/scala/de/halcony/appanalyzer/analysis/Analysis.scala", "Analysis.scala", 111, 9), (Object)"stopping traffic collection");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Option<TrafficCollection> option = this.activeTrafficCollection();
        if (option instanceof Some) {
            TrafficCollection$.MODULE$.stopCurrentTrafficCollection();
            this.activeTrafficCollection_$eq((Option<TrafficCollection>)None$.MODULE$);
            this.trafficCollectionStart_$eq((Option<ZonedDateTime>)None$.MODULE$);
            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
    }

    public void collectCurrentAppPreferences(String comment, Option<Object> context) {
        BoxedUnit boxedUnit;
        if (this.logger().isEnabled((LogLevel)LogLevel.INFO$.MODULE$)) {
            this.logger().log((LogLevel)LogLevel.INFO$.MODULE$, new LogSource("/home/simon/tools/mobile-analysis/scala-appanalyzer/src/main/scala/de/halcony/appanalyzer/analysis/Analysis.scala", "Analysis.scala", 123, 9), (Object)"collecting app preferences");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        String preferences = JsObject$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"preferences"), (Object)new JsString((String)this.device.getPrefs(this.app.id()).getOrElse((Function0 & Serializable)() -> ""))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"platformSpecifics"), (Object)new JsString((String)this.device.getPlatformSpecificData(this.app.id()).getOrElse((Function0 & Serializable)() -> "")))})).prettyPrint();
        Postgres$.MODULE$.withDatabaseSession((Function1 & Serializable)session -> BoxesRunTime.boxToInteger((int)Analysis.$anonfun$collectCurrentAppPreferences$3(this, context, comment, preferences, session)));
    }

    public Option<Object> collectCurrentAppPreferences$default$2() {
        return None$.MODULE$;
    }

    public boolean checkIfAppIsStillRunning(boolean fail) {
        boolean bl;
        String string = this.app.id();
        String string2 = "EMPTY";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            bl = true;
        } else {
            boolean bl2;
            Option<String> option = this.device.getForegroundAppId();
            if (option instanceof Some) {
                String value;
                Some some = (Some)option;
                String string3 = value = (String)some.value();
                String string4 = this.app.id();
                bl2 = !(string3 != null ? !string3.equals(string4) : string4 != null);
            } else if (None$.MODULE$.equals(option)) {
                bl2 = false;
            } else {
                throw new MatchError(option);
            }
            boolean running = bl2;
            if (!running && fail) {
                throw new AppClosedItself(this.app.id());
            }
            bl = running;
        }
        return bl;
    }

    private Interface handlePostAppStartup(String interfaceComment, Appium appium, Device device) {
        Interface interface_;
        Enumeration.Value value = device.PLATFORM_OS();
        Enumeration.Value value2 = PlatformOS$.MODULE$.Android();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            interface_ = Interface$.MODULE$.apply(this, appium, false, interfaceComment);
        } else {
            Enumeration.Value value4 = PlatformOS$.MODULE$.iOS();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                interface_ = ((iOSAppium)appium).getRidOfAlerts(this.conf) ? Interface$.MODULE$.apply(this, appium, false, interfaceComment) : Interface$.MODULE$.apply(this, appium, false, interfaceComment);
            } else {
                throw new MatchError((Object)value);
            }
        }
        return interface_;
    }

    public void performAnalysis() {
        try {
            try {
                BoxedUnit boxedUnit;
                this.setRunning(true);
                if (this.logger().isEnabled((LogLevel)LogLevel.INFO$.MODULE$)) {
                    this.logger().log((LogLevel)LogLevel.INFO$.MODULE$, new LogSource("/home/simon/tools/mobile-analysis/scala-appanalyzer/src/main/scala/de/halcony/appanalyzer/analysis/Analysis.scala", "Analysis.scala", 181, 11), (Object)"inserting analysis run into database");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                this.device.withRunningFrida((JFunction0.mcV.sp & Serializable)() -> Appium$.MODULE$.withRunningAppium($this.app.id(), $this.conf, $this.device, (Function1 & Serializable)appium -> {
                    Analysis.$anonfun$performAnalysis$2(this, appium);
                    return BoxedUnit.UNIT;
                }));
            }
            catch (FridaDied x) {
                this.addEncounteredError(x, this.addEncounteredError$default$2(), this.addEncounteredError$default$3());
                this.running_$eq(false);
            }
            catch (AnalysisTookTooLong x) {
                BoxedUnit boxedUnit;
                if (this.logger().isEnabled((LogLevel)LogLevel.ERROR$.MODULE$)) {
                    this.logger().log((LogLevel)LogLevel.ERROR$.MODULE$, new LogSource("/home/simon/tools/mobile-analysis/scala-appanalyzer/src/main/scala/de/halcony/appanalyzer/analysis/Analysis.scala", "Analysis.scala", 234, 14), (Object)"I took too long, killing myself now");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                this.addEncounteredError(x, (Option<Object>)None$.MODULE$, this.addEncounteredError$default$3());
                throw new AnalysisFatal(x.getMessage());
            }
            catch (AppClosedItself x) {
                this.addEncounteredError(x, (Option<Object>)None$.MODULE$, this.addEncounteredError$default$3());
                throw new AnalysisFatal(x.getMessage());
            }
        }
        catch (Throwable throwable) {
            if (this.activeTrafficCollection().nonEmpty()) {
                BoxedUnit boxedUnit;
                if (this.logger().isEnabled((LogLevel)LogLevel.WARN$.MODULE$)) {
                    this.logger().log((LogLevel)LogLevel.WARN$.MODULE$, new LogSource("/home/simon/tools/mobile-analysis/scala-appanalyzer/src/main/scala/de/halcony/appanalyzer/analysis/Analysis.scala", "Analysis.scala", 245, 13), (Object)"after the analysis is done there is still an active traffic collection. Closing...");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                this.stopTrafficCollection();
            }
            this.setRunning(false);
            throw throwable;
        }
        if (this.activeTrafficCollection().nonEmpty()) {
            BoxedUnit boxedUnit;
            if (this.logger().isEnabled((LogLevel)LogLevel.WARN$.MODULE$)) {
                this.logger().log((LogLevel)LogLevel.WARN$.MODULE$, new LogSource("/home/simon/tools/mobile-analysis/scala-appanalyzer/src/main/scala/de/halcony/appanalyzer/analysis/Analysis.scala", "Analysis.scala", 245, 13), (Object)"after the analysis is done there is still an active traffic collection. Closing...");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this.stopTrafficCollection();
        }
        this.setRunning(false);
    }

    public void insert() {
        if (this.id().nonEmpty()) {
            throw new RuntimeException("This analysis already has been inserted - this is a severe logic bug");
        }
        int experiment = Experiment$.MODULE$.getCurrentExperiment().id();
        Postgres$.MODULE$.withDatabaseSession((Function1 & Serializable)session -> {
            Analysis.$anonfun$insert$1(this, experiment, session);
            return BoxedUnit.UNIT;
        });
    }

    public void finish(boolean success) {
        Postgres$.MODULE$.withDatabaseSession((Function1 & Serializable)session -> BoxesRunTime.boxToInteger((int)Analysis.$anonfun$finish$1(this, success, session)));
    }

    public void addEncounteredError(Throwable err, Option<Object> interfaceid, boolean silent) {
        Throwable throwable = err;
        if (throwable instanceof InterfaceAnalysisCondition) {
            BoxedUnit boxedUnit;
            InterfaceAnalysisCondition interfaceAnalysisCondition = (InterfaceAnalysisCondition)((Object)throwable);
            if (!silent) {
                if (this.logger().isEnabled((LogLevel)LogLevel.ERROR$.MODULE$)) {
                    this.logger().log((LogLevel)LogLevel.ERROR$.MODULE$, new LogSource("/home/simon/tools/mobile-analysis/scala-appanalyzer/src/main/scala/de/halcony/appanalyzer/analysis/Analysis.scala", "Analysis.scala", 301, 27), (Object)new StringBuilder(27).append("analysis encountered error ").append(err.getMessage()).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            Postgres$.MODULE$.withDatabaseSession((Function1 & Serializable)session -> BoxesRunTime.boxToInteger((int)Analysis.$anonfun$addEncounteredError$1(this, interfaceid, interfaceAnalysisCondition, session)));
            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit;
            this.addEncounteredError(new UncaughtCondition(throwable), interfaceid, this.addEncounteredError$default$3());
            if (!(throwable instanceof AnalysisTookTooLong)) {
                if (this.logger().isEnabled((LogLevel)LogLevel.ERROR$.MODULE$)) {
                    this.logger().log((LogLevel)LogLevel.ERROR$.MODULE$, new LogSource("/home/simon/tools/mobile-analysis/scala-appanalyzer/src/main/scala/de/halcony/appanalyzer/analysis/Analysis.scala", "Analysis.scala", 320, 16), (Object)new StringBuilder(22).append("error was unexpected:\n").append(Predef$.MODULE$.wrapRefArray((Object[])throwable.getStackTrace()).mkString("\n")).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit3 = boxedUnit;
        }
    }

    public Option<Object> addEncounteredError$default$2() {
        return None$.MODULE$;
    }

    public boolean addEncounteredError$default$3() {
        return false;
    }

    public static final /* synthetic */ int $anonfun$collectCurrentAppPreferences$3(Analysis $this, Option context$1, String comment$1, String preferences$1, DBSession session) {
        return SQLInterpolationString$.MODULE$.sql$extension(package$.MODULE$.scalikejdbcSQLInterpolationImplicitDef(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"INSERT INTO AppPreferences (\n                            analysis,\n                            interface,\n                            appid,\n                            version,\n                            os,\n                            comment,\n                            prefs\n                            )\n               VALUES (\n                    ", ",\n                    ", ",\n                    ", ",\n                    ", ",\n                    ", ",\n                    ", ",\n                    ", "\n               )"}))), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)$this.getId()), context$1.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), $this.app.id(), $this.app.version(), $this.app.getOsString(), comment$1, preferences$1})).update().apply(session);
    }

    public static final /* synthetic */ void $anonfun$performAnalysis$2(Analysis $this, Appium appium) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        $this.checkStop();
        if ($this.logger().isEnabled((LogLevel)LogLevel.INFO$.MODULE$)) {
            $this.logger().log((LogLevel)LogLevel.INFO$.MODULE$, new LogSource("/home/simon/tools/mobile-analysis/scala-appanalyzer/src/main/scala/de/halcony/appanalyzer/analysis/Analysis.scala", "Analysis.scala", 185, 15), (Object)"starting app for interface analysis");
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        $this.actor.onAppStartup($this);
        String string = $this.app.id();
        String string2 = "EMPTY";
        if (string == null ? string2 != null : !string.equals(string2)) {
            $this.device.startApp($this.app.id(), $this.device.startApp$default$2());
        }
        $this.checkIfAppIsStillRunning(true);
        $this.checkStop();
        if ($this.logger().isEnabled((LogLevel)LogLevel.INFO$.MODULE$)) {
            $this.logger().log((LogLevel)LogLevel.INFO$.MODULE$, new LogSource("/home/simon/tools/mobile-analysis/scala-appanalyzer/src/main/scala/de/halcony/appanalyzer/analysis/Analysis.scala", "Analysis.scala", 191, 15), (Object)"extracting start interface");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Interface currentInterface = $this.handlePostAppStartup("initial interface", appium, $this.device);
        currentInterface.insert();
        boolean running = true;
        while (running) {
            try {
                BoxedUnit boxedUnit3;
                BoxedUnit boxedUnit4;
                if ($this.logger().isEnabled((LogLevel)LogLevel.INFO$.MODULE$)) {
                    $this.logger().log((LogLevel)LogLevel.INFO$.MODULE$, new LogSource("/home/simon/tools/mobile-analysis/scala-appanalyzer/src/main/scala/de/halcony/appanalyzer/analysis/Analysis.scala", "Analysis.scala", 198, 19), (Object)"calling on actor to perform his magic");
                    boxedUnit4 = BoxedUnit.UNIT;
                } else {
                    boxedUnit4 = BoxedUnit.UNIT;
                }
                $this.checkStop();
                Option<InterfaceElementInteraction> option = $this.actor.action(currentInterface, $this, appium);
                if (option instanceof Some) {
                    BoxedUnit boxedUnit5;
                    BoxedUnit boxedUnit6;
                    Some some = (Some)option;
                    InterfaceElementInteraction action = (InterfaceElementInteraction)some.value();
                    if ($this.logger().isEnabled((LogLevel)LogLevel.INFO$.MODULE$)) {
                        $this.logger().log((LogLevel)LogLevel.INFO$.MODULE$, new LogSource("/home/simon/tools/mobile-analysis/scala-appanalyzer/src/main/scala/de/halcony/appanalyzer/analysis/Analysis.scala", "Analysis.scala", 202, 23), (Object)"actor indicates that he has further actions to perform");
                        boxedUnit6 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit6 = BoxedUnit.UNIT;
                    }
                    Option<Interface> option2 = action.getLeadingTo();
                    if (option2 instanceof Some) {
                        Some some2 = (Some)option2;
                        Interface value = (Interface)some2.value();
                        running = true;
                        currentInterface = value;
                        value.insert();
                        boxedUnit5 = BoxedUnit.UNIT;
                    } else if (None$.MODULE$.equals(option2)) {
                        running = false;
                        boxedUnit5 = BoxedUnit.UNIT;
                    } else {
                        throw new MatchError(option2);
                    }
                    action.insert();
                    boxedUnit3 = BoxedUnit.UNIT;
                    continue;
                }
                if (None$.MODULE$.equals(option)) {
                    BoxedUnit boxedUnit7;
                    if ($this.logger().isEnabled((LogLevel)LogLevel.INFO$.MODULE$)) {
                        $this.logger().log((LogLevel)LogLevel.INFO$.MODULE$, new LogSource("/home/simon/tools/mobile-analysis/scala-appanalyzer/src/main/scala/de/halcony/appanalyzer/analysis/Analysis.scala", "Analysis.scala", 213, 23), (Object)"actor indicates that he done");
                        boxedUnit7 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit7 = BoxedUnit.UNIT;
                    }
                    running = false;
                    boxedUnit3 = BoxedUnit.UNIT;
                    continue;
                }
                throw new MatchError(option);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof MissingInterfaceElement) {
                    MissingInterfaceElement missingInterfaceElement = (MissingInterfaceElement)throwable2;
                    $this.addEncounteredError(missingInterfaceElement, currentInterface.getOptionalId(), $this.addEncounteredError$default$3());
                    running = false;
                    throw new AnalysisFatal(missingInterfaceElement.getMessage());
                }
                if (throwable2 instanceof InterfaceAnalysisCondition) {
                    InterfaceAnalysisCondition interfaceAnalysisCondition = (InterfaceAnalysisCondition)((Object)throwable2);
                    $this.addEncounteredError((Throwable)((Object)interfaceAnalysisCondition), currentInterface.getOptionalId(), $this.addEncounteredError$default$3());
                    running = false;
                    BoxedUnit boxedUnit8 = BoxedUnit.UNIT;
                    continue;
                }
                throw throwable;
            }
        }
    }

    public static final /* synthetic */ void $anonfun$insert$1(Analysis $this, int experiment$1, DBSession session) {
        SQLToOption sQLToOption = SQLInterpolationString$.MODULE$.sql$extension(package$.MODULE$.scalikejdbcSQLInterpolationImplicitDef(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"INSERT INTO interfaceanalysis (\n                              experiment,\n                              app_id,\n                              app_version,\n                              app_os,\n                              description\n                              )\n                    VALUES (\n                            ", ",\n                            ", ",\n                            ", ",\n                            ", ",\n                            ", "\n                            )\n                    RETURNING id\n                 "}))), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)experiment$1), $this.app.id(), $this.app.version(), $this.app.getOsString(), $this.description})).map((Function1 & Serializable)entity -> BoxesRunTime.boxToInteger((int)entity.int("id"))).first();
        DBSession x$1 = session;
        GeneralizedTypeConstraintsForWithExtractor.$eq$colon$eq x$2 = GeneralizedTypeConstraintsForWithExtractor.$eq$colon$eq$.MODULE$.tpEquals();
        ConnectionPoolContext x$3 = sQLToOption.apply$default$2();
        $this.id_$eq((Option<Object>)((Option)sQLToOption.apply(x$1, x$3, x$2)));
    }

    public static final /* synthetic */ int $anonfun$finish$1(Analysis $this, boolean success$1, DBSession session) {
        return SQLInterpolationString$.MODULE$.sql$extension(package$.MODULE$.scalikejdbcSQLInterpolationImplicitDef(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"UPDATE interfaceanalysis\n                  SET\n                      end_time = NOW(),\n                      success = ", "\n                  WHERE\n                       id = ", ""}))), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)success$1), BoxesRunTime.boxToInteger((int)$this.getId())})).update().apply(session);
    }

    public static final /* synthetic */ int $anonfun$addEncounteredError$1(Analysis $this, Option interfaceid$1, InterfaceAnalysisCondition x2$1, DBSession session) {
        return SQLInterpolationString$.MODULE$.sql$extension(package$.MODULE$.scalikejdbcSQLInterpolationImplicitDef(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"INSERT INTO InterfaceAnalysisError (\n                                        analysis,\n                                        interface,\n                                        message,\n                                        stacktrace\n                                        )\n                  VALUES (\n                          ", ",\n                          ", ",\n                          ", ",\n                          ", "\n                          )"}))), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)$this.getId()), interfaceid$1.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), x2$1.getMessage(), x2$1.getStacktraceString()})).update().apply(session);
    }

    public Analysis(String description, MobileApp app, ActorPlugin actor, Device device, Config conf) {
        this.description = description;
        this.app = app;
        this.actor = actor;
        this.device = device;
        this.conf = conf;
        LoggingMethods.$init$((LoggingMethods)this);
        LazyLogger.$init$((LazyLogger)this);
        this.id = None$.MODULE$;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.activeTrafficCollection = None$.MODULE$;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        this.trafficCollectionStart = None$.MODULE$;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
        this.stop = false;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 8);
        this.running = false;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x10);
    }

    public static class AnalysisTookTooLong
    extends Throwable {
        @Override
        public String getMessage() {
            return "analysis took too long, kill yeself!";
        }
    }
}

