/*
 * Decompiled with CFR 0.152.
 */
package de.halcony.appanalyzer.analysis.plugin;

import de.halcony.appanalyzer.analysis.plugin.NoSuchPlugin;
import de.halcony.appanalyzer.analysis.plugin.PluginManager;
import de.halcony.appanalyzer.analysis.plugin.RemoteGithubRelease;
import de.halcony.appanalyzer.analysis.plugin.RemotePluginConfig;
import de.halcony.argparse.Parser;
import de.halcony.argparse.ParsingResult;
import de.halcony.argparse.ParsingResultValue;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.UninitializedFieldError;
import scala.collection.ArrayOps$;
import scala.collection.IndexedSeqOps;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.StrictOptimizedSeqOps;
import scala.collection.immutable.Vector;
import scala.math.Ordering$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.util.matching.Regex;
import scala.util.matching.UnanchoredRegex;
import spray.json.JsArray;
import spray.json.JsonParser$;
import spray.json.ParserInput;
import spray.json.ParserInput$;
import wvlet.log.LazyLogger;
import wvlet.log.LogLevel;
import wvlet.log.LogSource;
import wvlet.log.LogSupport;
import wvlet.log.Logger;
import wvlet.log.LoggingMethods;

public final class PluginManager$
implements LogSupport {
    public static final PluginManager$ MODULE$ = new PluginManager$();
    private static Option<PluginManager> manager;
    private static final Parser parser;
    private static Logger logger;
    private static volatile boolean bitmap$0;
    private static volatile byte bitmap$init$0;

    static {
        LoggingMethods.$init$((LoggingMethods)MODULE$);
        LazyLogger.$init$((LazyLogger)MODULE$);
        manager = None$.MODULE$;
        bitmap$init$0 = (byte)(bitmap$init$0 | 1);
        parser = new Parser("plugin", "manage the installed plugins").addSubparser(new Parser("list", "list all installed plugins").addSubparser(new Parser("installed", "list all installed plugins").addDefault("func", (Function2 & Serializable)(pargs, conf) -> {
            PluginManager$.MODULE$.listPlugins(pargs, conf);
            return BoxedUnit.UNIT;
        }, "list all installed plugins")).addSubparser(new Parser("available", "list all available plugins").addFlag("all", "a", "all", "if set list all available versions").addOptional("filter", "f", "filter", (Option)None$.MODULE$, "a regexp to filter plugins").addDefault("func", (Function2 & Serializable)(pargs, conf) -> {
            PluginManager$.MODULE$.availablePlugins(pargs, conf);
            return BoxedUnit.UNIT;
        }, "list all online available plugins"))).addSubparser(new Parser("install", "install a plugin").addFlag("update", "u", "update", "if set updates the plugin to the most current version").addFlag("force", "f", "force", "if set removes an already installed version of the plugin").addOptional("version", "r", "revision", (Option)None$.MODULE$, "if set will isntall (if available) the specified version of the plugin").addPositional("plugin", "the name of the plugin").addDefault("func", (Function2 & Serializable)(pargs, conf) -> {
            PluginManager$.MODULE$.installPlugin(pargs, conf);
            return BoxedUnit.UNIT;
        }, "install/update a named plugin"));
        bitmap$init$0 = (byte)(bitmap$init$0 | 2);
    }

    private Logger logger$lzycompute() {
        PluginManager$ pluginManager$ = this;
        synchronized (pluginManager$) {
            if (!bitmap$0) {
                logger = LazyLogger.logger$((LazyLogger)this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        return !bitmap$0 ? this.logger$lzycompute() : logger;
    }

    private Option<PluginManager> manager() {
        if ((byte)(bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/simon/tools/mobile-analysis/scala-appanalyzer/src/main/scala/de/halcony/appanalyzer/analysis/plugin/PluginManager.scala: 126");
        }
        return manager;
    }

    private void manager_$eq(Option<PluginManager> x$1) {
        manager = x$1;
        bitmap$init$0 = (byte)(bitmap$init$0 | 1);
    }

    public PluginManager getPluginManager(PluginManager.HasPluginManagerConfiguration configuration) {
        PluginManager pluginManager;
        Option<PluginManager> option = this.manager();
        if (option instanceof Some) {
            PluginManager manager;
            Some some = (Some)option;
            pluginManager = manager = (PluginManager)some.value();
        } else if (None$.MODULE$.equals(option)) {
            this.manager_$eq((Option<PluginManager>)new Some((Object)new PluginManager(configuration.getPluginManagerConfiguration())));
            pluginManager = (PluginManager)this.manager().get();
        } else {
            throw new MatchError(option);
        }
        return pluginManager;
    }

    public Parser parser() {
        if ((byte)(bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/simon/tools/mobile-analysis/scala-appanalyzer/src/main/scala/de/halcony/appanalyzer/analysis/plugin/PluginManager.scala: 147");
        }
        return parser;
    }

    public void listPlugins(ParsingResult pargs, PluginManager.HasPluginManagerConfiguration conf) {
        PluginManager manager = this.getPluginManager(conf);
        Predef$.MODULE$.println((Object)"Installed Plugins:");
        manager.getInstalledPlugins().foreach((Function1 & Serializable)x0$1 -> {
            PluginManager$.$anonfun$listPlugins$1(x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private List<RemoteGithubRelease> getReleases(HttpClient client, RemotePluginConfig remote) {
        HttpRequest.Builder request = HttpRequest.newBuilder(URI.create(new StringBuilder(39).append("https://api.github.com/repos/").append(remote.owner()).append("/").append(remote.repo()).append("/releases").toString()));
        String json = client.send(request.build(), HttpResponse.BodyHandlers.ofString()).body();
        Vector plugins = (Vector)((IndexedSeqOps)((StrictOptimizedSeqOps)((JsArray)JsonParser$.MODULE$.apply((ParserInput)ParserInput$.MODULE$.apply(json))).elements().map((Function1 & Serializable)elem -> new RemoteGithubRelease(elem.asJsObject()))).sorted(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))).reverse();
        return plugins.toList();
    }

    public void availablePlugins(ParsingResult pargs, PluginManager.HasPluginManagerConfiguration conf) {
        UnanchoredRegex unanchoredRegex;
        HttpClient client = HttpClient.newHttpClient();
        Predef$.MODULE$.println((Object)"Available Plugins:");
        Option option = (Option)((ParsingResultValue)pargs.get("filter")).value();
        if (option instanceof Some) {
            Some some = (Some)option;
            String value = (String)some.value();
            unanchoredRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(value)).unanchored();
        } else if (None$.MODULE$.equals(option)) {
            unanchoredRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".*")).unanchored();
        } else {
            throw new MatchError((Object)option);
        }
        UnanchoredRegex filter = unanchoredRegex;
        ((IterableOnceOps)conf.getPluginManagerConfiguration().available().filter((Function1 & Serializable)plugin -> BoxesRunTime.boxToBoolean((boolean)PluginManager$.$anonfun$availablePlugins$1(filter, plugin)))).foreach((Function1 & Serializable)x0$1 -> {
            PluginManager$.$anonfun$availablePlugins$2(client, pargs, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public void installPlugin(ParsingResult pargs, PluginManager.HasPluginManagerConfiguration conf) {
        BoxedUnit boxedUnit;
        HttpClient client = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.ALWAYS).build();
        boolean forced = BoxesRunTime.unboxToBoolean((Object)pargs.getValue("force"));
        boolean update = BoxesRunTime.unboxToBoolean((Object)pargs.getValue("update"));
        Option version = (Option)((ParsingResultValue)pargs.get("version")).value();
        if (update) {
            Predef$.MODULE$.assert(version.isEmpty(), (Function0 & Serializable)() -> "you cannot provide a version for update use `install --force --release <version>`");
        }
        String plugin = (String)pargs.getValue("plugin");
        Option option = conf.getPluginManagerConfiguration().available().find((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)PluginManager$.$anonfun$installPlugin$2(plugin, x0$1)));
        if (None$.MODULE$.equals(option)) {
            throw new NoSuchPlugin(plugin, (Option<String>)version);
        }
        if (option instanceof Some) {
            BoxedUnit boxedUnit2;
            Some some;
            Tuple2 tuple2;
            BoxedUnit boxedUnit3;
            RemoteGithubRelease remoteGithubRelease;
            Some some2 = (Some)option;
            Tuple2 remoteTarget = (Tuple2)some2.value();
            List<RemoteGithubRelease> releases = this.getReleases(client, (RemotePluginConfig)remoteTarget._2());
            Option option2 = version;
            if (option2 instanceof Some) {
                Some some3 = (Some)option2;
                String version2 = (String)some3.value();
                remoteGithubRelease = (RemoteGithubRelease)releases.find((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)PluginManager$.$anonfun$installPlugin$3(version2, x$4))).getOrElse((Function0 & Serializable)() -> {
                    throw new NoSuchPlugin(plugin, (Option<String>)new Some((Object)version2));
                });
            } else if (None$.MODULE$.equals(option2)) {
                remoteGithubRelease = (RemoteGithubRelease)releases.head();
            } else {
                throw new MatchError((Object)option2);
            }
            RemoteGithubRelease target = remoteGithubRelease;
            if (this.logger().isEnabled((LogLevel)LogLevel.INFO$.MODULE$)) {
                this.logger().log((LogLevel)LogLevel.INFO$.MODULE$, new LogSource("/home/simon/tools/mobile-analysis/scala-appanalyzer/src/main/scala/de/halcony/appanalyzer/analysis/plugin/PluginManager.scala", "PluginManager.scala", 280, 13), (Object)new StringBuilder(19).append("installing plugin ").append(remoteTarget._1()).append(" ").append(target.getVersion()).toString());
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            PluginManager manager = this.getPluginManager(conf);
            Option option3 = manager.getInstalledPlugins().find((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)PluginManager$.$anonfun$installPlugin$5(remoteTarget, x0$2)));
            if (option3 instanceof Some && (tuple2 = (Tuple2)(some = (Some)option3).value()) != null) {
                BoxedUnit boxedUnit4;
                String version3 = (String)tuple2._2();
                if (this.logger().isEnabled((LogLevel)LogLevel.WARN$.MODULE$)) {
                    this.logger().log((LogLevel)LogLevel.WARN$.MODULE$, new LogSource("/home/simon/tools/mobile-analysis/scala-appanalyzer/src/main/scala/de/halcony/appanalyzer/analysis/plugin/PluginManager.scala", "PluginManager.scala", 286, 17), (Object)new StringBuilder(42).append("a previous version (").append(version3).append(") is already installed").toString());
                    boxedUnit4 = BoxedUnit.UNIT;
                } else {
                    boxedUnit4 = BoxedUnit.UNIT;
                }
                if (forced || update) {
                    BoxedUnit boxedUnit5;
                    if (this.logger().isEnabled((LogLevel)LogLevel.WARN$.MODULE$)) {
                        this.logger().log((LogLevel)LogLevel.WARN$.MODULE$, new LogSource("/home/simon/tools/mobile-analysis/scala-appanalyzer/src/main/scala/de/halcony/appanalyzer/analysis/plugin/PluginManager.scala", "PluginManager.scala", 288, 19), (Object)"removing old version");
                        boxedUnit5 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit5 = BoxedUnit.UNIT;
                    }
                } else {
                    return;
                }
                manager.removePlugin((String)remoteTarget._1());
                BoxedUnit boxedUnit6 = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option3)) {
                BoxedUnit boxedUnit7 = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)option3);
            }
            if (this.logger().isEnabled((LogLevel)LogLevel.INFO$.MODULE$)) {
                this.logger().log((LogLevel)LogLevel.INFO$.MODULE$, new LogSource("/home/simon/tools/mobile-analysis/scala-appanalyzer/src/main/scala/de/halcony/appanalyzer/analysis/plugin/PluginManager.scala", "PluginManager.scala", 295, 13), (Object)new StringBuilder(20).append("downloading plugin ").append(remoteTarget._1()).append(" ").append(target.getVersion()).toString());
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            HttpRequest.Builder request = HttpRequest.newBuilder().uri(URI.create(target.jarDownloadLink()));
            HttpResponse<byte[]> ret = client.send(request.build(), HttpResponse.BodyHandlers.ofByteArray());
            if (ret.statusCode() != 200) {
                throw new RuntimeException(new StringBuilder(27).append("download jar returned ").append(ret.statusCode()).append(" for ").append(target.jarDownloadLink()).toString());
            }
            String jarName = (String)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])target.jarDownloadLink().split("/")));
            FileOutputStream fileWriter = new FileOutputStream(new File(new StringBuilder(1).append(conf.getPluginManagerConfiguration().folder()).append("/").append(jarName).toString()));
            try {
                fileWriter.write(ret.body());
                boxedUnit = BoxedUnit.UNIT;
            }
            finally {
                fileWriter.flush();
                fileWriter.close();
            }
        } else {
            throw new MatchError((Object)option);
        }
        BoxedUnit boxedUnit8 = boxedUnit;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(PluginManager$.class);
    }

    public static final /* synthetic */ void $anonfun$listPlugins$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String name = (String)tuple2._1();
        String version = (String)tuple2._2();
        Predef$.MODULE$.println((Object)new StringBuilder(3).append("* ").append(name).append(" ").append(version).toString());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$availablePlugins$1(UnanchoredRegex filter$1, Tuple2 plugin) {
        return ((Regex)filter$1).matches((CharSequence)plugin._1());
    }

    public static final /* synthetic */ void $anonfun$availablePlugins$2(HttpClient client$1, ParsingResult pargs$1, Tuple2 x0$1) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String name = (String)tuple2._1();
            RemotePluginConfig remote = (RemotePluginConfig)tuple2._2();
            List<RemoteGithubRelease> versions = MODULE$.getReleases(client$1, remote);
            if (BoxesRunTime.unboxToBoolean((Object)pargs$1.getValue("all"))) {
                versions.foreach((Function1 & Serializable)version -> {
                    Predef$.MODULE$.println((Object)new StringBuilder(4).append("+ ").append(name).append("  ").append(version.getVersion()).toString());
                    return BoxedUnit.UNIT;
                });
                boxedUnit = BoxedUnit.UNIT;
            } else {
                Predef$.MODULE$.println((Object)new StringBuilder(3).append("+ ").append(name).append(" ").append(((RemoteGithubRelease)versions.head()).getVersion()).toString());
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ boolean $anonfun$installPlugin$2(String plugin$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String key = (String)tuple2._1();
        boolean bl = ((Regex)StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(plugin$1)).unanchored()).matches((CharSequence)key);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$installPlugin$3(String version$1, RemoteGithubRelease x$4) {
        String string = x$4.getVersion();
        String string2 = version$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$installPlugin$5(Tuple2 remoteTarget$1, Tuple2 x0$2) {
        String name;
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String string = name = (String)tuple2._1();
        Object object = remoteTarget$1._1();
        boolean bl = !(string != null ? !string.equals(object) : object != null);
        return bl;
    }

    private PluginManager$() {
    }
}

