/*
 * Decompiled with CFR 0.152.
 */
package de.halcony.appanalyzer.platform.device;

import de.halcony.appanalyzer.Config;
import de.halcony.appanalyzer.appbinary.Analysis;
import de.halcony.appanalyzer.appbinary.MobileApp;
import de.halcony.appanalyzer.appbinary.apk.APK;
import de.halcony.appanalyzer.platform.PlatformOS$;
import de.halcony.appanalyzer.platform.device.AndroidDevice$;
import de.halcony.appanalyzer.platform.device.Device;
import de.halcony.appanalyzer.platform.exceptions.AppClosedItself;
import de.halcony.appanalyzer.platform.exceptions.FatalError;
import de.halcony.appanalyzer.platform.exceptions.FridaDied;
import de.halcony.appanalyzer.platform.exceptions.UnableToInstallApp;
import de.halcony.appanalyzer.platform.exceptions.UnableToStartApp;
import de.halcony.appanalyzer.platform.exceptions.UnableToUninstallApp;
import de.halcony.appanalyzer.platform.frida.FridaScripts$;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.NotImplementedError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple3;
import scala.UninitializedFieldError;
import scala.collection.ArrayOps$;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.sys.process.Process;
import scala.sys.process.Process$;
import scala.sys.process.ProcessBuilder;
import scala.sys.process.ProcessLogger$;
import wvlet.log.LazyLogger;
import wvlet.log.LogLevel;
import wvlet.log.LogSource;
import wvlet.log.Logger;
import wvlet.log.LoggingMethods;

@ScalaSignature(bytes="\u0006\u0005\t\u0005h\u0001B\u001e=\u0001\u001eC\u0001\"\u001b\u0001\u0003\u0016\u0004%\tA\u001b\u0005\t_\u0002\u0011\t\u0012)A\u0005W\")\u0001\u000f\u0001C\u0001c\"9A\u000f\u0001b\u0001\n\u0003*\bbBA\u0006\u0001\u0001\u0006IA\u001e\u0005\n\u0003\u001b\u0001\u0001\u0019!C\u0001\u0003\u001fA\u0011\"a\n\u0001\u0001\u0004%\t!!\u000b\t\u0011\u0005U\u0002\u0001)Q\u0005\u0003#A\u0011\"a\u000e\u0001\u0001\u0004%I!!\u000f\t\u0013\u0005%\u0003\u00011A\u0005\n\u0005-\u0003\u0002CA(\u0001\u0001\u0006K!a\u000f\t\u0013\u0005E\u0003\u00011A\u0005\n\u0005M\u0003\"CA?\u0001\u0001\u0007I\u0011BA@\u0011!\t\u0019\t\u0001Q!\n\u0005U\u0003bBAC\u0001\u0011%\u0011q\u0011\u0005\b\u0003\u0017\u0003A\u0011BAG\u0011\u001d\t)\n\u0001C\u0005\u0003/Cq!!(\u0001\t\u0003\ny\nC\u0004\u0002\"\u0002!\t%a(\t\u000f\u0005\r\u0006\u0001\"\u0011\u0002&\"9\u0011\u0011\u001a\u0001\u0005\n\u0005}\u0005bBAf\u0001\u0011\u0005\u0013Q\u001a\u0005\b\u0003#\u0004A\u0011IAP\u0011\u001d\t\u0019\u000e\u0001C\u0005\u0003?Cq!!6\u0001\t\u0003\ny\nC\u0004\u0002X\u0002!\t%!7\t\u000f\u0005%\b\u0001\"\u0011\u0002l\"9\u00111\u001f\u0001\u0005B\u0005-\bbBA{\u0001\u0011\u0005\u0013q\u0014\u0005\b\u0003o\u0004A\u0011IA}\u0011\u001d\u0011)\u0001\u0001C!\u0005\u000fAqA!\u0004\u0001\t\u0003\u0012y\u0001C\u0005\u0003\u0018\u0001\t\n\u0011\"\u0001\u0003\u001a!9!q\u0006\u0001\u0005B\tE\u0002b\u0002B\u001b\u0001\u0011\u0005#q\u0007\u0005\b\u0005w\u0001A\u0011\tB\u001f\u0011\u001d\u0011y\u0004\u0001C!\u0005\u0003BqAa\u0012\u0001\t\u0003\u0012I\u0005C\u0004\u0003N\u0001!\tEa\u0014\t\u000f\tM\u0003\u0001\"\u0011\u0003V!I!1\f\u0001\u0002\u0002\u0013\u0005!Q\f\u0005\n\u0005C\u0002\u0011\u0013!C\u0001\u0005GB\u0011Ba\u001a\u0001\u0003\u0003%\tE!\u001b\t\u0013\te\u0004!!A\u0005\u0002\tm\u0004\"\u0003B?\u0001\u0005\u0005I\u0011\u0001B@\u0011%\u0011\u0019\tAA\u0001\n\u0003\u0012)\tC\u0005\u0003\u0010\u0002\t\t\u0011\"\u0001\u0003\u0012\"I!Q\u0013\u0001\u0002\u0002\u0013\u0005#q\u0013\u0005\n\u00057\u0003\u0011\u0011!C!\u0005;C\u0011Ba(\u0001\u0003\u0003%\tE!)\t\u0013\t\r\u0006!!A\u0005B\t\u0015v!\u0003BUy\u0005\u0005\t\u0012\u0001BV\r!YD(!A\t\u0002\t5\u0006B\u000296\t\u0003\u0011)\rC\u0005\u0003 V\n\t\u0011\"\u0012\u0003\"\"I!qY\u001b\u0002\u0002\u0013\u0005%\u0011\u001a\u0005\n\u0005\u001b,\u0014\u0011!CA\u0005\u001fD\u0011Ba66\u0003\u0003%IA!7\u0003\u001b\u0005sGM]8jI\u0012+g/[2f\u0015\tid(\u0001\u0004eKZL7-\u001a\u0006\u0003\u007f\u0001\u000b\u0001\u0002\u001d7bi\u001a|'/\u001c\u0006\u0003\u0003\n\u000b1\"\u00199qC:\fG.\u001f>fe*\u00111\tR\u0001\bQ\u0006d7m\u001c8z\u0015\u0005)\u0015A\u00013f\u0007\u0001\u0019b\u0001\u0001%O%jk\u0006CA%M\u001b\u0005Q%\"A&\u0002\u000bM\u001c\u0017\r\\1\n\u00055S%AB!osJ+g\r\u0005\u0002P!6\tA(\u0003\u0002Ry\t1A)\u001a<jG\u0016\u0004\"a\u0015-\u000e\u0003QS!!\u0016,\u0002\u00071|wMC\u0001X\u0003\u00159h\u000f\\3u\u0013\tIFK\u0001\u0006M_\u001e\u001cV\u000f\u001d9peR\u0004\"!S.\n\u0005qS%a\u0002)s_\u0012,8\r\u001e\t\u0003=\u001at!a\u00183\u000f\u0005\u0001\u001cW\"A1\u000b\u0005\t4\u0015A\u0002\u001fs_>$h(C\u0001L\u0013\t)'*A\u0004qC\u000e\\\u0017mZ3\n\u0005\u001dD'\u0001D*fe&\fG.\u001b>bE2,'BA3K\u0003\u0011\u0019wN\u001c4\u0016\u0003-\u0004\"\u0001\\7\u000e\u0003\u0001K!A\u001c!\u0003\r\r{gNZ5h\u0003\u0015\u0019wN\u001c4!\u0003\u0019a\u0014N\\5u}Q\u0011!o\u001d\t\u0003\u001f\u0002AQ![\u0002A\u0002-\f1\u0002\u0015'B)\u001a{%+T0P'V\ta\u000fE\u0002x\u0003\u000bq1\u0001_A\u0001\u001d\tIxP\u0004\u0002{}:\u001110 \b\u0003ArL\u0011!R\u0005\u0003\u0007\u0012K!!\u0011\"\n\u0005}\u0002\u0015bAA\u0002}\u0005Q\u0001\u000b\\1uM>\u0014XnT*\n\t\u0005\u001d\u0011\u0011\u0002\u0002\u000b!2\fGOZ8s[>\u001b&bAA\u0002}\u0005a\u0001\u000bT!U\r>\u0013VjX(TA\u0005IqN\u00196fGRLwN\\\u000b\u0003\u0003#\u0001R!SA\n\u0003/I1!!\u0006K\u0005\u0019y\u0005\u000f^5p]B!\u0011\u0011DA\u0012\u001b\t\tYB\u0003\u0003\u0002\u001e\u0005}\u0011a\u00029s_\u000e,7o\u001d\u0006\u0004\u0003CQ\u0015aA:zg&!\u0011QEA\u000e\u0005\u001d\u0001&o\\2fgN\fQb\u001c2kK\u000e$\u0018n\u001c8`I\u0015\fH\u0003BA\u0016\u0003c\u00012!SA\u0017\u0013\r\tyC\u0013\u0002\u0005+:LG\u000fC\u0005\u00024\u001d\t\t\u00111\u0001\u0002\u0012\u0005\u0019\u0001\u0010J\u0019\u0002\u0015=\u0014'.Z2uS>t\u0007%A\bqC\u000e\\\u0017mZ3B]\u0006d\u0017p]5t+\t\tY\u0004E\u0003J\u0003'\ti\u0004\u0005\u0003\u0002@\u0005\u0015SBAA!\u0015\r\t\u0019\u0005Q\u0001\nCB\u0004(-\u001b8befLA!a\u0012\u0002B\tA\u0011I\\1msNL7/A\nqC\u000e\\\u0017mZ3B]\u0006d\u0017p]5t?\u0012*\u0017\u000f\u0006\u0003\u0002,\u00055\u0003\"CA\u001a\u0015\u0005\u0005\t\u0019AA\u001e\u0003A\u0001\u0018mY6bO\u0016\fe.\u00197zg&\u001c\b%\u0001\u0007sk:t\u0017N\\4Ge&$\u0017-\u0006\u0002\u0002VA)\u0011*a\u0005\u0002XAI\u0011*!\u0017\u0002\u0018\u0005u\u0013QL\u0005\u0004\u00037R%A\u0002+va2,7\u0007\u0005\u0004\u0002`\u0005%\u0014QN\u0007\u0003\u0003CRA!a\u0019\u0002f\u00059Q.\u001e;bE2,'bAA4\u0015\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005-\u0014\u0011\r\u0002\u000b\u0019&\u001cHOQ;gM\u0016\u0014\b\u0003BA8\u0003orA!!\u001d\u0002tA\u0011\u0001MS\u0005\u0004\u0003kR\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0002z\u0005m$AB*ue&twMC\u0002\u0002v)\u000b\u0001C];o]&twM\u0012:jI\u0006|F%Z9\u0015\t\u0005-\u0012\u0011\u0011\u0005\n\u0003gi\u0011\u0011!a\u0001\u0003+\nQB];o]&twM\u0012:jI\u0006\u0004\u0013A\u00053fi\u0016\u001cGOU;o]&twM\u0012:jI\u0006$\"!!#\u0011\u000b%\u000b\u0019\"!\u001c\u0002!\u001d,G/\u00138ti\u0006dG.\u001a3BaB\u001cXCAAH!\u0019\ty'!%\u0002n%!\u00111SA>\u0005\r\u0019V\r^\u0001\fW&dG\u000e\u0015:pG\u0016\u001c8\u000f\u0006\u0003\u0002,\u0005e\u0005bBAN#\u0001\u0007\u0011QN\u0001\u0004a&$\u0017AC:uCJ$hI]5eCR\u0011\u00111F\u0001\ngR|\u0007O\u0012:jI\u0006\f\u0001c^5uQJ+hN\\5oO\u001a\u0013\u0018\u000eZ1\u0016\t\u0005\u001d\u0016Q\u0016\u000b\u0005\u0003S\u000by\f\u0005\u0003\u0002,\u00065F\u0002\u0001\u0003\b\u0003_#\"\u0019AAY\u0005\u0005!\u0016\u0003BAZ\u0003s\u00032!SA[\u0013\r\t9L\u0013\u0002\b\u001d>$\b.\u001b8h!\rI\u00151X\u0005\u0004\u0003{S%aA!os\"A\u0011\u0011\u0019\u000b\u0005\u0002\u0004\t\u0019-\u0001\u0003gk:\u001c\u0007#B%\u0002F\u0006%\u0016bAAd\u0015\nAAHY=oC6,g(A\u000bdY\u0016\fgn\u00142kK\u000e$\u0018n\u001c8Qe>\u001cWm]:\u0002+\u001d,G/\u00119q!\u0006\u001c7.Y4f\u0003:\fG._:jgR!\u0011QHAh\u0011\u0015Ig\u00031\u0001l\u00031)gn];sK\u0012+g/[2f\u0003)\u0011Xm\u001d;beR\fEMY\u0001\fe\u0016\u001cX\r\u001e#fm&\u001cW-\u0001\u0007qKJ4wN]7U_V\u001c\u0007\u000e\u0006\u0004\u0002,\u0005m\u0017Q\u001d\u0005\b\u0003;T\u0002\u0019AAp\u0003\u0005A\bcA%\u0002b&\u0019\u00111\u001d&\u0003\u0007%sG\u000fC\u0004\u0002hj\u0001\r!a8\u0002\u0003e\fab\u00195fG.\u0014un\u001c;Ti\u0006$X\r\u0006\u0002\u0002nB\u0019\u0011*a<\n\u0007\u0005E(JA\u0004C_>dW-\u00198\u0002\u0019I,7\u000f^1siBCwN\\3\u0002!\rdW-\u0019:TiV\u001c7.T8eC2\u001c\u0018AC5ogR\fG\u000e\\!qaR!\u00111FA~\u0011\u001d\tiP\ba\u0001\u0003\u007f\f1!\u00199q!\u0011\tyD!\u0001\n\t\t\r\u0011\u0011\t\u0002\n\u001b>\u0014\u0017\u000e\\3BaB\fA\"\u001e8j]N$\u0018\r\u001c7BaB$B!a\u000b\u0003\n!9!1B\u0010A\u0002\u00055\u0014!B1qa&#\u0017\u0001C:uCJ$\u0018\t\u001d9\u0015\r\u0005-\"\u0011\u0003B\n\u0011\u001d\u0011Y\u0001\ta\u0001\u0003[B\u0011B!\u0006!!\u0003\u0005\r!a8\u0002\u000fI,GO]5fg\u0006\u00112\u000f^1si\u0006\u0003\b\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011YB\u000b\u0003\u0002`\nu1F\u0001B\u0010!\u0011\u0011\tCa\u000b\u000e\u0005\t\r\"\u0002\u0002B\u0013\u0005O\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t%\"*\u0001\u0006b]:|G/\u0019;j_:LAA!\f\u0003$\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u0011\rdwn]3BaB$B!a\u000b\u00034!9!1\u0002\u0012A\u0002\u00055\u0014!E:fi\u0006\u0003\b\u000fU3s[&\u001c8/[8ogR!\u00111\u0006B\u001d\u0011\u001d\u0011Ya\ta\u0001\u0003[\n!cZ3u\r>\u0014Xm\u001a:pk:$\u0017\t\u001d9JIV\u0011\u0011\u0011R\u0001\u0007O\u0016$\b+\u001b3\u0015\t\u00055$1\t\u0005\b\u0005\u000b*\u0003\u0019AA7\u0003\u0015\t\u0007\u000f]5e\u0003!9W\r\u001e)sK\u001a\u001cH\u0003BAE\u0005\u0017BqAa\u0003'\u0001\u0004\ti'A\fhKR\u0004F.\u0019;g_Jl7\u000b]3dS\u001aL7\rR1uCR!\u0011\u0011\u0012B)\u0011\u001d\u0011Ya\na\u0001\u0003[\nQbZ3u\u0003B\u0004h+\u001a:tS>tG\u0003BAE\u0005/BqA!\u0017)\u0001\u0004\ti'\u0001\u0003qCRD\u0017\u0001B2paf$2A\u001dB0\u0011\u001dI\u0017\u0006%AA\u0002-\fabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003f)\u001a1N!\b\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\u0011Y\u0007\u0005\u0003\u0003n\t]TB\u0001B8\u0015\u0011\u0011\tHa\u001d\u0002\t1\fgn\u001a\u0006\u0003\u0005k\nAA[1wC&!\u0011\u0011\u0010B8\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\ty.\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005e&\u0011\u0011\u0005\n\u0003gi\u0013\u0011!a\u0001\u0003?\fq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0005\u000f\u0003bA!#\u0003\f\u0006eVBAA3\u0013\u0011\u0011i)!\u001a\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003[\u0014\u0019\nC\u0005\u00024=\n\t\u00111\u0001\u0002:\u0006\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\u0011YG!'\t\u0013\u0005M\u0002'!AA\u0002\u0005}\u0017\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005}\u0017\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\t-\u0014AB3rk\u0006d7\u000f\u0006\u0003\u0002n\n\u001d\u0006\"CA\u001ag\u0005\u0005\t\u0019AA]\u00035\te\u000e\u001a:pS\u0012$UM^5dKB\u0011q*N\n\u0006k\t=&1\u0018\t\u0007\u0005c\u00139l\u001b:\u000e\u0005\tM&b\u0001B[\u0015\u00069!/\u001e8uS6,\u0017\u0002\u0002B]\u0005g\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c82!\u0011\u0011iLa1\u000e\u0005\t}&\u0002\u0002Ba\u0005g\n!![8\n\u0007\u001d\u0014y\f\u0006\u0002\u0003,\u0006)\u0011\r\u001d9msR\u0019!Oa3\t\u000b%D\u0004\u0019A6\u0002\u000fUt\u0017\r\u001d9msR!!\u0011\u001bBj!\u0011I\u00151C6\t\u0011\tU\u0017(!AA\u0002I\f1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0011Y\u000e\u0005\u0003\u0003n\tu\u0017\u0002\u0002Bp\u0005_\u0012aa\u00142kK\u000e$\b")
public class AndroidDevice
implements Device,
Product {
    private final Config conf;
    private final Enumeration.Value PLATFORM_OS;
    private Option<Process> objection;
    private Option<Analysis> packageAnalysis;
    private Option<Tuple3<Process, ListBuffer<String>, ListBuffer<String>>> runningFrida;
    private int de$halcony$appanalyzer$platform$device$Device$$failedInteractions;
    private int de$halcony$appanalyzer$platform$device$Device$$REBOOT_THRESHOLD;
    private int de$halcony$appanalyzer$platform$device$Device$$FATAL_ERROR_THRESHOLD;
    private Logger logger;
    private volatile boolean bitmap$0;
    private volatile byte bitmap$init$0;

    public static Option<Config> unapply(AndroidDevice x$0) {
        return AndroidDevice$.MODULE$.unapply(x$0);
    }

    public static AndroidDevice apply(Config conf) {
        return AndroidDevice$.MODULE$.apply(conf);
    }

    public static <A> Function1<Config, A> andThen(Function1<AndroidDevice, A> g) {
        return AndroidDevice$.MODULE$.andThen(g);
    }

    public static <A> Function1<A, AndroidDevice> compose(Function1<A, Config> g) {
        return AndroidDevice$.MODULE$.compose(g);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    @Override
    public void increaseFailedInteractions() {
        Device.increaseFailedInteractions$(this);
    }

    @Override
    public void resetFailedInteractions() {
        Device.resetFailedInteractions$(this);
    }

    @Override
    public void restartApp(String appId) {
        Device.restartApp$(this, appId);
    }

    @Override
    public void resetAndRestartApp(MobileApp app) {
        Device.resetAndRestartApp$(this, app);
    }

    @Override
    public String runFridaScript(String pid, String script) {
        return Device.runFridaScript$(this, pid, script);
    }

    @Override
    public void assertForegroundApp(String appId, Throwable throwable) {
        Device.assertForegroundApp$(this, appId, throwable);
    }

    @Override
    public int de$halcony$appanalyzer$platform$device$Device$$failedInteractions() {
        if ((byte)(this.bitmap$init$0 & 0x10) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/simon/tools/mobile-analysis/scala-appanalyzer/src/main/scala/de/halcony/appanalyzer/platform/device/AndroidDevice.scala: 24");
        }
        return this.de$halcony$appanalyzer$platform$device$Device$$failedInteractions;
    }

    @Override
    public void de$halcony$appanalyzer$platform$device$Device$$failedInteractions_$eq(int x$1) {
        this.de$halcony$appanalyzer$platform$device$Device$$failedInteractions = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x10);
    }

    @Override
    public int de$halcony$appanalyzer$platform$device$Device$$REBOOT_THRESHOLD() {
        if ((byte)(this.bitmap$init$0 & 0x20) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/simon/tools/mobile-analysis/scala-appanalyzer/src/main/scala/de/halcony/appanalyzer/platform/device/AndroidDevice.scala: 24");
        }
        return this.de$halcony$appanalyzer$platform$device$Device$$REBOOT_THRESHOLD;
    }

    @Override
    public int de$halcony$appanalyzer$platform$device$Device$$FATAL_ERROR_THRESHOLD() {
        if ((byte)(this.bitmap$init$0 & 0x40) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/simon/tools/mobile-analysis/scala-appanalyzer/src/main/scala/de/halcony/appanalyzer/platform/device/AndroidDevice.scala: 24");
        }
        return this.de$halcony$appanalyzer$platform$device$Device$$FATAL_ERROR_THRESHOLD;
    }

    @Override
    public final void de$halcony$appanalyzer$platform$device$Device$_setter_$de$halcony$appanalyzer$platform$device$Device$$REBOOT_THRESHOLD_$eq(int x$1) {
        this.de$halcony$appanalyzer$platform$device$Device$$REBOOT_THRESHOLD = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x20);
    }

    @Override
    public final void de$halcony$appanalyzer$platform$device$Device$_setter_$de$halcony$appanalyzer$platform$device$Device$$FATAL_ERROR_THRESHOLD_$eq(int x$1) {
        this.de$halcony$appanalyzer$platform$device$Device$$FATAL_ERROR_THRESHOLD = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x40);
    }

    private Logger logger$lzycompute() {
        AndroidDevice androidDevice = this;
        synchronized (androidDevice) {
            if (!this.bitmap$0) {
                this.logger = LazyLogger.logger$((LazyLogger)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public Config conf() {
        return this.conf;
    }

    @Override
    public Enumeration.Value PLATFORM_OS() {
        if ((byte)(this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/simon/tools/mobile-analysis/scala-appanalyzer/src/main/scala/de/halcony/appanalyzer/platform/device/AndroidDevice.scala: 32");
        }
        return this.PLATFORM_OS;
    }

    public Option<Process> objection() {
        if ((byte)(this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/simon/tools/mobile-analysis/scala-appanalyzer/src/main/scala/de/halcony/appanalyzer/platform/device/AndroidDevice.scala: 33");
        }
        return this.objection;
    }

    public void objection_$eq(Option<Process> x$1) {
        this.objection = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
    }

    private Option<Analysis> packageAnalysis() {
        if ((byte)(this.bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/simon/tools/mobile-analysis/scala-appanalyzer/src/main/scala/de/halcony/appanalyzer/platform/device/AndroidDevice.scala: 34");
        }
        return this.packageAnalysis;
    }

    private void packageAnalysis_$eq(Option<Analysis> x$1) {
        this.packageAnalysis = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
    }

    private Option<Tuple3<Process, ListBuffer<String>, ListBuffer<String>>> runningFrida() {
        if ((byte)(this.bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/simon/tools/mobile-analysis/scala-appanalyzer/src/main/scala/de/halcony/appanalyzer/platform/device/AndroidDevice.scala: 36");
        }
        return this.runningFrida;
    }

    private void runningFrida_$eq(Option<Tuple3<Process, ListBuffer<String>, ListBuffer<String>>> x$1) {
        this.runningFrida = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 8);
    }

    private Option<String> detectRunningFrida() {
        None$ none$;
        String cmd = new StringBuilder(34).append(this.conf().android().adb()).append(" shell 'ps -e | grep frida-server'").toString();
        try {
            None$ none$2;
            List list = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])scala.sys.process.package$.MODULE$.stringToProcess(cmd).$bang$bang().replace("\t", " ").split(" ")), (Function1 & Serializable)x$1 -> x$1.trim(), ClassTag$.MODULE$.apply(String.class))), (Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)AndroidDevice.$anonfun$detectRunningFrida$2(x$2)))).toList();
            Nil$ nil$ = package$.MODULE$.Nil();
            List list2 = list;
            if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
                none$2 = None$.MODULE$;
            } else {
                Predef$.MODULE$.assert(list.length() == 9, (Function0 & Serializable)() -> new StringBuilder(42).append("the encountered ps -e line is out of spec ").append(list.mkString("#")).toString());
                none$2 = new Some(((IterableOps)list.tail()).head());
            }
            none$ = none$2;
        }
        catch (Throwable throwable) {
            RuntimeException runtimeException;
            Throwable throwable2 = throwable;
            if (!(throwable2 instanceof RuntimeException) || !(runtimeException = (RuntimeException)throwable2).getMessage().toLowerCase().contains("nonzero exit value")) {
                throw throwable;
            }
            None$ none$3 = None$.MODULE$;
            none$ = none$3;
        }
        return none$;
    }

    private Set<String> getInstalledApps() {
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])scala.sys.process.package$.MODULE$.stringToProcess(new StringBuilder(28).append(this.conf().android().adb()).append(" shell 'pm list packages -f'").toString()).$bang$bang().split("\n")), (Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.startsWith("package:")))), (Function1 & Serializable)line -> (String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.tail$extension(Predef$.MODULE$.refArrayOps((Object[])line.split("\\.apk="))))), ClassTag$.MODULE$.apply(String.class))).toSet();
    }

    private void killProcess(String pid) {
        scala.sys.process.package$.MODULE$.stringToProcess(new StringBuilder(23).append(this.conf().android().adb()).append(" shell 'su -c kill -9 ").append(pid).append("'").toString()).$bang$bang();
    }

    @Override
    public void startFrida() {
        BoxedUnit boxedUnit;
        if (this.logger().isEnabled((LogLevel)LogLevel.INFO$.MODULE$)) {
            this.logger().log((LogLevel)LogLevel.INFO$.MODULE$, new LogSource("/home/simon/tools/mobile-analysis/scala-appanalyzer/src/main/scala/de/halcony/appanalyzer/platform/device/AndroidDevice.scala", "AndroidDevice.scala", 80, 9), (Object)"starting frida");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (this.runningFrida().nonEmpty()) {
            BoxedUnit boxedUnit2;
            if (this.logger().isEnabled((LogLevel)LogLevel.WARN$.MODULE$)) {
                this.logger().log((LogLevel)LogLevel.WARN$.MODULE$, new LogSource("/home/simon/tools/mobile-analysis/scala-appanalyzer/src/main/scala/de/halcony/appanalyzer/platform/device/AndroidDevice.scala", "AndroidDevice.scala", 82, 11), (Object)"Frida already running, cannot be started twice");
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
        } else {
            Option<String> option = this.detectRunningFrida();
            if (option instanceof Some) {
                BoxedUnit boxedUnit3;
                Some some = (Some)option;
                String pid = (String)some.value();
                if (this.logger().isEnabled((LogLevel)LogLevel.WARN$.MODULE$)) {
                    this.logger().log((LogLevel)LogLevel.WARN$.MODULE$, new LogSource("/home/simon/tools/mobile-analysis/scala-appanalyzer/src/main/scala/de/halcony/appanalyzer/platform/device/AndroidDevice.scala", "AndroidDevice.scala", 86, 15), (Object)new StringBuilder(71).append("we encountered a still running frida instance as pid ").append(pid).append(", lets get killin'").toString());
                    boxedUnit3 = BoxedUnit.UNIT;
                } else {
                    boxedUnit3 = BoxedUnit.UNIT;
                }
                this.killProcess(pid);
                BoxedUnit boxedUnit4 = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option)) {
                BoxedUnit boxedUnit5 = BoxedUnit.UNIT;
            } else {
                throw new MatchError(option);
            }
            ListBuffer stdin = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            ListBuffer stderr = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            Process process = Process$.MODULE$.apply(new StringBuilder(43).append(this.conf().android().adb()).append(" shell 'su -c /data/local/tmp/frida-server'").toString()).run(ProcessLogger$.MODULE$.apply((Function1 & Serializable)in -> {
                stdin.append((Object)in);
                return BoxedUnit.UNIT;
            }, (Function1 & Serializable)err -> {
                stderr.append((Object)err);
                return BoxedUnit.UNIT;
            }));
            this.runningFrida_$eq((Option<Tuple3<Process, ListBuffer<String>, ListBuffer<String>>>)new Some((Object)new Tuple3((Object)process, (Object)stdin, (Object)stderr)));
            if (!process.isAlive()) {
                this.increaseFailedInteractions();
                this.runningFrida_$eq((Option<Tuple3<Process, ListBuffer<String>, ListBuffer<String>>>)None$.MODULE$);
                throw new FridaDied();
            }
        }
    }

    @Override
    public void stopFrida() {
        Some some;
        Tuple3 tuple3;
        BoxedUnit boxedUnit;
        if (this.logger().isEnabled((LogLevel)LogLevel.INFO$.MODULE$)) {
            this.logger().log((LogLevel)LogLevel.INFO$.MODULE$, new LogSource("/home/simon/tools/mobile-analysis/scala-appanalyzer/src/main/scala/de/halcony/appanalyzer/platform/device/AndroidDevice.scala", "AndroidDevice.scala", 107, 9), (Object)"stopping frida");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Option<Tuple3<Process, ListBuffer<String>, ListBuffer<String>>> option = this.runningFrida();
        if (option instanceof Some && (tuple3 = (Tuple3)(some = (Some)option).value()) != null) {
            BoxedUnit boxedUnit2;
            String err;
            Process process = (Process)tuple3._1();
            ListBuffer stdin = (ListBuffer)tuple3._2();
            ListBuffer stderr = (ListBuffer)tuple3._3();
            if (!process.isAlive()) {
                this.increaseFailedInteractions();
                throw new FridaDied();
            }
            process.destroy();
            String string = err = new StringBuilder(0).append(stderr.mkString("\n")).append(stdin.mkString("\n")).toString();
            String string2 = "";
            if (string == null ? string2 != null : !string.equals(string2)) {
                if (this.logger().isEnabled((LogLevel)LogLevel.ERROR$.MODULE$)) {
                    this.logger().log((LogLevel)LogLevel.ERROR$.MODULE$, new LogSource("/home/simon/tools/mobile-analysis/scala-appanalyzer/src/main/scala/de/halcony/appanalyzer/platform/device/AndroidDevice.scala", "AndroidDevice.scala", 117, 16), (Object)new StringBuilder(43).append("while running frida we encountered output:\n").append(err).toString());
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            stdin.clear();
            stderr.clear();
            this.runningFrida_$eq((Option<Tuple3<Process, ListBuffer<String>, ListBuffer<String>>>)None$.MODULE$);
            Option<String> option2 = this.detectRunningFrida();
            if (option2 instanceof Some) {
                Some some2 = (Some)option2;
                String pid = (String)some2.value();
                this.killProcess(pid);
                BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option2)) {
                BoxedUnit boxedUnit4 = BoxedUnit.UNIT;
            } else {
                throw new MatchError(option2);
            }
            BoxedUnit boxedUnit5 = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit6;
            if (this.logger().isEnabled((LogLevel)LogLevel.WARN$.MODULE$)) {
                this.logger().log((LogLevel)LogLevel.WARN$.MODULE$, new LogSource("/home/simon/tools/mobile-analysis/scala-appanalyzer/src/main/scala/de/halcony/appanalyzer/platform/device/AndroidDevice.scala", "AndroidDevice.scala", 128, 24), (Object)"trying to destroy a non existing frida instance");
                boxedUnit6 = BoxedUnit.UNIT;
            } else {
                boxedUnit6 = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit7 = boxedUnit6;
        } else {
            throw new MatchError(option);
        }
    }

    @Override
    public <T> T withRunningFrida(Function0<T> func) {
        Object object;
        this.startFrida();
        try {
            object = func.apply();
        }
        finally {
            this.stopFrida();
        }
        return (T)object;
    }

    private void cleanObjectionProcess() {
        Option<Process> option = this.objection();
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            Process value = (Process)some.value();
            if (value.isAlive()) {
                value.destroy();
                this.objection_$eq((Option<Process>)None$.MODULE$);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
    }

    @Override
    public Analysis getAppPackageAnalysis(Config conf) {
        Analysis analysis;
        Option<Analysis> option = this.packageAnalysis();
        if (option instanceof Some) {
            Analysis value;
            Some some = (Some)option;
            analysis = value = (Analysis)some.value();
        } else if (None$.MODULE$.equals(option)) {
            this.packageAnalysis_$eq((Option<Analysis>)new Some((Object)new APK(conf)));
            analysis = (Analysis)this.packageAnalysis().get();
        } else {
            throw new MatchError(option);
        }
        return analysis;
    }

    @Override
    public void ensureDevice() {
        int ret = scala.sys.process.package$.MODULE$.stringToProcess(new StringBuilder(10).append(this.conf().android().adb()).append(" get-state").toString()).$bang(ProcessLogger$.MODULE$.apply((Function1 & Serializable)x$4 -> {
            AndroidDevice.$anonfun$ensureDevice$1(x$4);
            return BoxedUnit.UNIT;
        }));
        if (ret != 0) {
            throw new FatalError("there is no device reachable via adb");
        }
    }

    private void restartAdb() {
        BoxedUnit boxedUnit;
        if (this.logger().isEnabled((LogLevel)LogLevel.WARN$.MODULE$)) {
            this.logger().log((LogLevel)LogLevel.WARN$.MODULE$, new LogSource("/home/simon/tools/mobile-analysis/scala-appanalyzer/src/main/scala/de/halcony/appanalyzer/platform/device/AndroidDevice.scala", "AndroidDevice.scala", 165, 9), (Object)"restarting host adb server");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        scala.sys.process.package$.MODULE$.stringToProcess(new StringBuilder(12).append(this.conf().android().adb()).append(" kill-server").toString()).$bang$bang();
        scala.sys.process.package$.MODULE$.stringToProcess(new StringBuilder(13).append(this.conf().android().adb()).append(" start-server").toString()).$bang$bang();
    }

    @Override
    public void resetDevice() {
        this.cleanObjectionProcess();
    }

    @Override
    public void performTouch(int x, int y) {
        scala.sys.process.package$.MODULE$.stringToProcess(new StringBuilder(18).append(this.conf().android().adb()).append(" shell input tap ").append(x).append(" ").append(y).toString()).$bang();
    }

    @Override
    public boolean checkBootState() {
        boolean bl;
        block3: {
            try {
                String string = scala.sys.process.package$.MODULE$.stringToProcess(new StringBuilder(35).append(this.conf().android().adb()).append(" shell 'getprop sys.boot_completed'").toString()).$bang$bang().trim();
                String string2 = "1";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    bl = true;
                    break block3;
                }
                bl = false;
            }
            catch (Throwable throwable) {
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public boolean restartPhone() {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        if (this.logger().isEnabled((LogLevel)LogLevel.INFO$.MODULE$)) {
            this.logger().log((LogLevel)LogLevel.INFO$.MODULE$, new LogSource("/home/simon/tools/mobile-analysis/scala-appanalyzer/src/main/scala/de/halcony/appanalyzer/platform/device/AndroidDevice.scala", "AndroidDevice.scala", 188, 9), (Object)"performing phone restart");
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        boolean fridaWasRunning = this.runningFrida().nonEmpty();
        if (this.runningFrida().nonEmpty()) {
            this.stopFrida();
        }
        scala.sys.process.package$.MODULE$.stringToProcess(new StringBuilder(7).append(this.conf().android().adb()).append(" reboot").toString()).$bang();
        int counter = 1;
        while (!this.checkBootState() && counter < 10) {
            Thread.sleep(30000L);
            if (++counter % 4 != 0) continue;
            this.restartAdb();
        }
        if (!this.checkBootState()) {
            throw new FatalError("we were unable to successfully restart the phone ... sucks mate");
        }
        scala.sys.process.package$.MODULE$.stringToProcess(new StringBuilder(24).append(this.conf().android().adb()).append(" shell input keyevent 82").toString()).$bang();
        Thread.sleep(1000L);
        this.performTouch(1000, 800);
        if (this.logger().isEnabled((LogLevel)LogLevel.INFO$.MODULE$)) {
            this.logger().log((LogLevel)LogLevel.INFO$.MODULE$, new LogSource("/home/simon/tools/mobile-analysis/scala-appanalyzer/src/main/scala/de/halcony/appanalyzer/platform/device/AndroidDevice.scala", "AndroidDevice.scala", 206, 9), (Object)"we unlocked the phone, now we wait for another 2 minutes for everything to boot up");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Thread.sleep(120000L);
        if (fridaWasRunning) {
            this.startFrida();
        }
        Thread.sleep(1000L);
        try {
            if (!this.checkBootState()) {
                throw new FatalError("getprop sys.boot_completed was not 1");
            }
        }
        catch (Throwable x) {
            this.increaseFailedInteractions();
            throw new FatalError(new StringBuilder(33).append("restarting the phone resulted in ").append(x.getMessage()).toString());
        }
        this.ensureDevice();
        return true;
    }

    @Override
    public void clearStuckModals() {
    }

    @Override
    public void installApp(MobileApp app) {
        int ret;
        BoxedUnit boxedUnit;
        if (this.logger().isEnabled((LogLevel)LogLevel.INFO$.MODULE$)) {
            this.logger().log((LogLevel)LogLevel.INFO$.MODULE$, new LogSource("/home/simon/tools/mobile-analysis/scala-appanalyzer/src/main/scala/de/halcony/appanalyzer/platform/device/AndroidDevice.scala", "AndroidDevice.scala", 229, 9), (Object)new StringBuilder(21).append("installing on device ").append(app.path()).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        ListBuffer stdio = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        ListBuffer stderr = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        String cmd = new StringBuilder(21).append(this.conf().android().adb()).append(" install-multiple -g ").append(app.path()).toString();
        int n = ret = this.conf().verbose() ? scala.sys.process.package$.MODULE$.stringToProcess(cmd).$bang() : scala.sys.process.package$.MODULE$.stringToProcess(cmd).$bang(ProcessLogger$.MODULE$.apply((Function1 & Serializable)io -> {
            stdio.append((Object)io);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable)err -> {
            stderr.append((Object)err);
            return BoxedUnit.UNIT;
        }));
        if (ret != 0) {
            this.increaseFailedInteractions();
            throw new UnableToInstallApp(app, new StringBuilder(40).append("ret value of install was ").append(ret).append("\nSTDIO\n").append(stdio.mkString("\n")).append("\nSTDERR\n").append(stderr.mkString("\n")).toString());
        }
    }

    @Override
    public void uninstallApp(String appId) {
        this.cleanObjectionProcess();
        long UNINSTALL_TIMEOUT_MS = 30000L;
        int MAX_TRIES = 3;
        this.closeApp(appId);
        boolean success = false;
        int tries = 0;
        int ret = -42;
        ObjectRef stdio = ObjectRef.create((Object)((ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$)));
        ObjectRef stderr = ObjectRef.create((Object)((ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$)));
        while (tries < MAX_TRIES && !success) {
            BoxedUnit boxedUnit;
            if (this.logger().isEnabled((LogLevel)LogLevel.INFO$.MODULE$)) {
                this.logger().log((LogLevel)LogLevel.INFO$.MODULE$, new LogSource("/home/simon/tools/mobile-analysis/scala-appanalyzer/src/main/scala/de/halcony/appanalyzer/platform/device/AndroidDevice.scala", "AndroidDevice.scala", 258, 11), (Object)new StringBuilder(17).append("uninstalling app ").append(appId).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            ++tries;
            String cmd = new StringBuilder(11).append(this.conf().android().adb()).append(" uninstall ").append(appId).toString();
            ObjectRef uninstallProcess = ObjectRef.create(null);
            stdio.elem = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            stderr.elem = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            Future uninstallFuture = Future$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> {
                ProcessBuilder proc = Process$.MODULE$.apply(cmd);
                uninstallProcess$1.elem = proc.run(ProcessLogger$.MODULE$.apply((Function1 & Serializable)x$5 -> {
                    AndroidDevice.$anonfun$uninstallApp$2(stdio, x$5);
                    return BoxedUnit.UNIT;
                }, (Function1 & Serializable)x$6 -> {
                    AndroidDevice.$anonfun$uninstallApp$3(stderr, x$6);
                    return BoxedUnit.UNIT;
                }));
                return ((Process)uninstallProcess$1.elem).exitValue();
            }, ExecutionContext.Implicits$.MODULE$.global());
            try {
                BoxedUnit boxedUnit2;
                Object object;
                ret = BoxesRunTime.unboxToInt((Object)Await$.MODULE$.result((Awaitable)uninstallFuture, (Duration)Duration$.MODULE$.apply(UNINSTALL_TIMEOUT_MS, TimeUnit.MILLISECONDS)));
                if (ret == 0) {
                    success = true;
                    object = BoxedUnit.UNIT;
                    continue;
                }
                if (ret == 20 || ret == 224) {
                    BoxedUnit boxedUnit3;
                    if (this.logger().isEnabled((LogLevel)LogLevel.WARN$.MODULE$)) {
                        this.logger().log((LogLevel)LogLevel.WARN$.MODULE$, new LogSource("/home/simon/tools/mobile-analysis/scala-appanalyzer/src/main/scala/de/halcony/appanalyzer/platform/device/AndroidDevice.scala", "AndroidDevice.scala", 276, 15), (Object)"we encountered ret code 20 or 224 which indicates that a phone restart is required");
                        boxedUnit3 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit3 = BoxedUnit.UNIT;
                    }
                    this.increaseFailedInteractions();
                    object = BoxesRunTime.boxToBoolean((boolean)this.restartPhone());
                    continue;
                }
                if (this.logger().isEnabled((LogLevel)LogLevel.WARN$.MODULE$)) {
                    this.logger().log((LogLevel)LogLevel.WARN$.MODULE$, new LogSource("/home/simon/tools/mobile-analysis/scala-appanalyzer/src/main/scala/de/halcony/appanalyzer/platform/device/AndroidDevice.scala", "AndroidDevice.scala", 281, 15), (Object)new StringBuilder(48).append("adb uninstall returned ").append(ret).append(" retrying \nSTDIO\n").append(((ListBuffer)stdio.elem).mkString("\n")).append("\nSTDERR\n").append(((ListBuffer)stderr.elem).mkString("\n")).toString());
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                this.increaseFailedInteractions();
                success = false;
                if (!this.getInstalledApps().contains((Object)appId)) {
                    BoxedUnit boxedUnit4;
                    if (this.logger().isEnabled((LogLevel)LogLevel.WARN$.MODULE$)) {
                        this.logger().log((LogLevel)LogLevel.WARN$.MODULE$, new LogSource("/home/simon/tools/mobile-analysis/scala-appanalyzer/src/main/scala/de/halcony/appanalyzer/platform/device/AndroidDevice.scala", "AndroidDevice.scala", 286, 17), (Object)new StringBuilder(38).append("the app ").append(appId).append(" does not seem to be installed").toString());
                        boxedUnit4 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit4 = BoxedUnit.UNIT;
                    }
                    success = true;
                    ret = 0;
                }
                object = BoxedUnit.UNIT;
            }
            catch (Throwable x) {
                if (((Process)uninstallProcess.elem).isAlive()) {
                    ((Process)uninstallProcess.elem).destroy();
                }
                throw new UnableToUninstallApp(new MobileApp(appId, "NA", PlatformOS$.MODULE$.Android(), "NA"), new StringBuilder(29).append("adb returned ").append(ret).append("\n").append(x.getMessage()).append("\nSTDIO\n").append(((ListBuffer)stdio.elem).mkString("\n")).append("\nSTDERR\n").append(((ListBuffer)stderr.elem).mkString("\n")).toString());
            }
        }
        int n = ret;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                BoxedUnit boxedUnit;
                if (this.logger().isEnabled((LogLevel)LogLevel.ERROR$.MODULE$)) {
                    this.logger().log((LogLevel)LogLevel.ERROR$.MODULE$, new LogSource("/home/simon/tools/mobile-analysis/scala-appanalyzer/src/main/scala/de/halcony/appanalyzer/platform/device/AndroidDevice.scala", "AndroidDevice.scala", 303, 14), (Object)new StringBuilder(45).append("final adb uninstall try resulted in ret code ").append(n).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                throw new UnableToUninstallApp(new MobileApp(appId, "NA", PlatformOS$.MODULE$.Android(), "NA"), new StringBuilder(28).append("adb returned ").append(ret).append("\nSTDIO\n").append(((ListBuffer)stdio.elem).mkString("\n")).append("\nSTDERR\n").append(((ListBuffer)stderr.elem).mkString("\n")).toString());
            }
        }
    }

    @Override
    public void startApp(String appId, int retries) {
        boolean done = false;
        ObjectRef stdio = ObjectRef.create((Object)((ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$)));
        ObjectRef stderr = ObjectRef.create((Object)((ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$)));
        for (int counter = 0; counter < retries && !done; ++counter) {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            stdio.elem = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            stderr.elem = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            if (this.logger().isEnabled((LogLevel)LogLevel.INFO$.MODULE$)) {
                this.logger().log((LogLevel)LogLevel.INFO$.MODULE$, new LogSource("/home/simon/tools/mobile-analysis/scala-appanalyzer/src/main/scala/de/halcony/appanalyzer/platform/device/AndroidDevice.scala", "AndroidDevice.scala", 318, 11), (Object)new StringBuilder(13).append("starting app ").append(appId).toString());
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            this.cleanObjectionProcess();
            String cmd = new StringBuilder(65).append(this.conf().android().objection()).append(" --gadget ").append(appId).append(" explore --startup-command 'android sslpinning disable'").toString();
            ProcessBuilder process = Process$.MODULE$.apply(cmd);
            this.objection_$eq((Option<Process>)new Some((Object)process.run(ProcessLogger$.MODULE$.apply((Function1 & Serializable)io -> {
                AndroidDevice.$anonfun$startApp$1(stdio, io);
                return BoxedUnit.UNIT;
            }, (Function1 & Serializable)err -> {
                AndroidDevice.$anonfun$startApp$2(stderr, err);
                return BoxedUnit.UNIT;
            }))));
            Thread.sleep(10000L);
            if (((Process)this.objection().get()).isAlive()) {
                String fgid;
                String string = fgid = (String)this.getForegroundAppId().getOrElse((Function0 & Serializable)() -> {
                    throw new AppClosedItself(appId);
                });
                String string2 = appId;
                if (string == null ? string2 != null : !string.equals(string2)) {
                    BoxedUnit boxedUnit3;
                    if (this.logger().isEnabled((LogLevel)LogLevel.WARN$.MODULE$)) {
                        this.logger().log((LogLevel)LogLevel.WARN$.MODULE$, new LogSource("/home/simon/tools/mobile-analysis/scala-appanalyzer/src/main/scala/de/halcony/appanalyzer/platform/device/AndroidDevice.scala", "AndroidDevice.scala", 330, 15), (Object)new StringBuilder(41).append("foreground id is wrong : '").append(fgid).append("' instead of '").append(appId).append("'").toString());
                        boxedUnit3 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit3 = BoxedUnit.UNIT;
                    }
                    this.closeApp(appId);
                    continue;
                }
                done = true;
                continue;
            }
            if (this.logger().isEnabled((LogLevel)LogLevel.WARN$.MODULE$)) {
                this.logger().log((LogLevel)LogLevel.WARN$.MODULE$, new LogSource("/home/simon/tools/mobile-analysis/scala-appanalyzer/src/main/scala/de/halcony/appanalyzer/platform/device/AndroidDevice.scala", "AndroidDevice.scala", 336, 13), (Object)"objection died after starting retrying...");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this.increaseFailedInteractions();
            this.closeApp(appId);
        }
        if (this.objection().nonEmpty() && !((Process)this.objection().get()).isAlive()) {
            BoxedUnit boxedUnit;
            this.objection_$eq((Option<Process>)None$.MODULE$);
            if (this.logger().isEnabled((LogLevel)LogLevel.INFO$.MODULE$)) {
                this.logger().log((LogLevel)LogLevel.INFO$.MODULE$, new LogSource("/home/simon/tools/mobile-analysis/scala-appanalyzer/src/main/scala/de/halcony/appanalyzer/platform/device/AndroidDevice.scala", "AndroidDevice.scala", 344, 11), (Object)"finally unable to start app, throwing corresponding error");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            throw new UnableToStartApp(appId, new StringBuilder(14).append("STDIO\n").append(((ListBuffer)stdio.elem).mkString("\n")).append("\nSTDERR\n").append(((ListBuffer)stderr.elem).mkString("\n")).toString());
        }
        this.resetFailedInteractions();
    }

    @Override
    public int startApp$default$2() {
        return 3;
    }

    @Override
    public void closeApp(String appId) {
        BoxedUnit boxedUnit;
        this.cleanObjectionProcess();
        if (this.logger().isEnabled((LogLevel)LogLevel.INFO$.MODULE$)) {
            this.logger().log((LogLevel)LogLevel.INFO$.MODULE$, new LogSource("/home/simon/tools/mobile-analysis/scala-appanalyzer/src/main/scala/de/halcony/appanalyzer/platform/device/AndroidDevice.scala", "AndroidDevice.scala", 357, 9), (Object)new StringBuilder(12).append("closing app ").append(appId).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        String cmd = new StringBuilder(21).append(this.conf().android().adb()).append(" shell am force-stop ").append(appId).toString();
        if (this.conf().verbose()) {
            scala.sys.process.package$.MODULE$.stringToProcess(cmd).$bang();
        } else {
            scala.sys.process.package$.MODULE$.stringToProcess(cmd).$bang(ProcessLogger$.MODULE$.apply((Function1 & Serializable)x$7 -> {
                AndroidDevice.$anonfun$closeApp$1(x$7);
                return BoxedUnit.UNIT;
            }));
        }
    }

    @Override
    public void setAppPermissions(String appId) {
        BoxedUnit boxedUnit;
        if (this.logger().isEnabled((LogLevel)LogLevel.INFO$.MODULE$)) {
            this.logger().log((LogLevel)LogLevel.INFO$.MODULE$, new LogSource("/home/simon/tools/mobile-analysis/scala-appanalyzer/src/main/scala/de/halcony/appanalyzer/platform/device/AndroidDevice.scala", "AndroidDevice.scala", 363, 9), (Object)new StringBuilder(24).append("setting permissions for ").append(appId).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        String cmd = new StringBuilder(35).append(this.conf().android().adb()).append(" shell pm list permissions -g -d -u").toString();
        String permissions = scala.sys.process.package$.MODULE$.stringToProcess(cmd).$bang$bang();
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])permissions.split("\n")), (Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.startsWith("  permission:")))), (Function1 & Serializable)x$9 -> x$9.replace("  permission:", ""), ClassTag$.MODULE$.apply(String.class))), (Function1 & Serializable)permission -> {
            Object object;
            try {
                object = BoxesRunTime.boxToInteger((int)scala.sys.process.package$.MODULE$.stringToProcess(new StringBuilder(17).append(this.conf().android().adb()).append(" shell pm grant ").append(appId).append(" ").append((String)permission).toString()).$bang(ProcessLogger$.MODULE$.apply((Function1 & Serializable)x$10 -> {
                    AndroidDevice.$anonfun$setAppPermissions$4(x$10);
                    return BoxedUnit.UNIT;
                })));
            }
            catch (Throwable throwable) {
                object = BoxedUnit.UNIT;
            }
            return object;
        });
    }

    @Override
    public Option<String> getForegroundAppId() {
        None$ none$;
        String cmd = new StringBuilder(31).append(this.conf().android().adb()).append(" shell dumpsys activity recents").toString();
        Option option = ArrayOps$.MODULE$.find$extension(Predef$.MODULE$.refArrayOps((Object[])scala.sys.process.package$.MODULE$.stringToProcess(cmd).$bang$bang().split("\n")), (Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)x$11.contains("Recent #0")));
        if (option instanceof Some) {
            None$ none$2;
            Some some = (Some)option;
            String value = (String)some.value();
            Option option2 = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("A=[0-9]+:(.+?) U=")).findFirstIn((CharSequence)value);
            if (option2 instanceof Some) {
                Some some2 = (Some)option2;
                String value2 = (String)some2.value();
                none$2 = new Some((Object)value2.substring(((String)StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("A=[0-9]+:")).findFirstIn((CharSequence)value2).get()).length(), value2.length() - " U=".length()));
            } else if (None$.MODULE$.equals(option2)) {
                none$2 = None$.MODULE$;
            } else {
                throw new MatchError((Object)option2);
            }
            none$ = none$2;
        } else if (None$.MODULE$.equals(option)) {
            none$ = None$.MODULE$;
        } else {
            throw new MatchError((Object)option);
        }
        return none$;
    }

    @Override
    public String getPid(String appid) {
        String string;
        try {
            String cmd = new StringBuilder(16).append(this.conf().android().adb()).append(" shell pidof -s ").append(appid).toString();
            string = scala.sys.process.package$.MODULE$.stringToProcess(cmd).$bang$bang().trim();
        }
        catch (RuntimeException runtimeException) {
            throw new AppClosedItself(appid);
        }
        return string;
    }

    @Override
    public Option<String> getPrefs(String appId) {
        String string;
        String script = FridaScripts$.MODULE$.platform(this.PLATFORM_OS()).getPrefs();
        String pid = this.getPid(appId);
        String prefs = this.runFridaScript(pid, script);
        Option<String> option = this.getPlatformSpecificData(appId);
        if (option instanceof Some) {
            Some some = (Some)option;
            String value = (String)some.value();
            string = new StringBuilder(11).append(prefs).append("\n#########\n").append(value).toString();
        } else if (None$.MODULE$.equals(option)) {
            string = prefs;
        } else {
            throw new MatchError(option);
        }
        String insertText = string;
        return new Some((Object)insertText);
    }

    @Override
    public Option<String> getPlatformSpecificData(String appId) {
        return None$.MODULE$;
    }

    @Override
    public Option<String> getAppVersion(String path) {
        throw new NotImplementedError();
    }

    public AndroidDevice copy(Config conf) {
        return new AndroidDevice(conf);
    }

    public Config copy$default$1() {
        return this.conf();
    }

    public String productPrefix() {
        return "AndroidDevice";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.conf();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof AndroidDevice;
    }

    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "conf";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof AndroidDevice)) return false;
        boolean bl = true;
        if (!bl) return false;
        AndroidDevice androidDevice = (AndroidDevice)x$1;
        Config config = this.conf();
        Config config2 = androidDevice.conf();
        if (config == null) {
            if (config2 != null) {
                return false;
            }
        } else if (!((Object)config).equals(config2)) return false;
        if (!androidDevice.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$detectRunningFrida$2(String x$2) {
        String string = x$2;
        String string2 = "";
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ void $anonfun$ensureDevice$1(String x$4) {
    }

    public static final /* synthetic */ void $anonfun$uninstallApp$2(ObjectRef stdio$2, String x$5) {
        ((ListBuffer)stdio$2.elem).append((Object)x$5);
    }

    public static final /* synthetic */ void $anonfun$uninstallApp$3(ObjectRef stderr$3, String x$6) {
        ((ListBuffer)stderr$3.elem).append((Object)x$6);
    }

    public static final /* synthetic */ void $anonfun$startApp$1(ObjectRef stdio$3, String io) {
        ((ListBuffer)stdio$3.elem).append((Object)io);
    }

    public static final /* synthetic */ void $anonfun$startApp$2(ObjectRef stderr$4, String err) {
        ((ListBuffer)stderr$4.elem).append((Object)err);
    }

    public static final /* synthetic */ void $anonfun$closeApp$1(String x$7) {
    }

    public static final /* synthetic */ void $anonfun$setAppPermissions$4(String x$10) {
    }

    public AndroidDevice(Config conf) {
        this.conf = conf;
        LoggingMethods.$init$((LoggingMethods)this);
        LazyLogger.$init$((LazyLogger)this);
        Device.$init$(this);
        Product.$init$((Product)this);
        this.PLATFORM_OS = PlatformOS$.MODULE$.Android();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.objection = None$.MODULE$;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        this.packageAnalysis = None$.MODULE$;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
        this.runningFrida = None$.MODULE$;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 8);
        Statics.releaseFence();
    }
}

