/*
 * Decompiled with CFR 0.152.
 */
package de.halcony.appanalyzer;

import com.mchange.v3.concurrent.BoundedExecutorService;
import de.halcony.appanalyzer.Config;
import de.halcony.appanalyzer.Config$;
import de.halcony.appanalyzer.Experiment;
import de.halcony.appanalyzer.Experiment$;
import de.halcony.appanalyzer.analysis.Analysis$;
import de.halcony.appanalyzer.analysis.plugin.ActorPlugin;
import de.halcony.appanalyzer.analysis.plugin.PluginManager;
import de.halcony.appanalyzer.analysis.plugin.PluginManager$;
import de.halcony.appanalyzer.appbinary.Analysis;
import de.halcony.appanalyzer.appbinary.MobileApp;
import de.halcony.appanalyzer.appbinary.apk.APK;
import de.halcony.appanalyzer.appbinary.ipa.IPA;
import de.halcony.appanalyzer.database.Postgres$;
import de.halcony.appanalyzer.platform.PlatformOS$;
import de.halcony.appanalyzer.platform.appium.Appium$;
import de.halcony.appanalyzer.platform.device.AndroidDevice;
import de.halcony.appanalyzer.platform.device.Device;
import de.halcony.appanalyzer.platform.device.iOSDevice;
import de.halcony.appanalyzer.platform.exceptions.FatalError;
import de.halcony.argparse.Parser;
import de.halcony.argparse.ParsingException;
import de.halcony.argparse.ParsingResult;
import de.halcony.argparse.ParsingResultValue;
import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import scala.;
import scala.$less$colon$less$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.UninitializedFieldError;
import scala.collection.ArrayOps$;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutorService;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.io.StdIn$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scalikejdbc.SQLInterpolationString$;
import scalikejdbc.package$;
import spray.json.JsObject;
import spray.json.JsObject$;
import spray.json.JsString;
import spray.json.JsValue;
import spray.json.JsonParser$;
import spray.json.ParserInput;
import spray.json.ParserInput$;
import wvlet.log.LazyLogger;
import wvlet.log.LogLevel;
import wvlet.log.LogSource;
import wvlet.log.LogSupport;
import wvlet.log.Logger;
import wvlet.log.LoggingMethods;

public final class AppAnalyzer$
implements LogSupport {
    public static final AppAnalyzer$ MODULE$ = new AppAnalyzer$();
    private static final BoundedExecutorService executorService;
    private static final ExecutionContextExecutorService executionContext;
    private static final Parser parser;
    private static Logger logger;
    private static volatile boolean bitmap$0;
    private static volatile byte bitmap$init$0;

    static {
        LoggingMethods.$init$((LoggingMethods)MODULE$);
        LazyLogger.$init$((LazyLogger)MODULE$);
        executorService = new BoundedExecutorService(Executors.newFixedThreadPool(10), 100, 50);
        bitmap$init$0 = (byte)(bitmap$init$0 | 1);
        executionContext = ExecutionContext$.MODULE$.fromExecutorService((ExecutorService)MODULE$.executorService());
        bitmap$init$0 = (byte)(bitmap$init$0 | 2);
        Parser qual$1 = new Parser("removedAnalysis", "delete listed analysis ids").addPositional("analysisIds", "csv list of ids or file containing list of ids");
        String x$1 = "func";
        Function2 & Serializable x$2 = (Function2 & Serializable)(pargs, conf) -> {
            AppAnalyzer$.MODULE$.deleteAnalysisMain(pargs, conf);
            return BoxedUnit.UNIT;
        };
        String x$3 = qual$1.addDefault$default$3();
        Parser qual$2 = new Parser("functionalityCheck", "run through all fundamental API actions to check if it works");
        String x$4 = "func";
        Function2 & Serializable x$5 = (Function2 & Serializable)(pargs, conf) -> {
            AppAnalyzer$.MODULE$.functionalityCheck(pargs, conf);
            return BoxedUnit.UNIT;
        };
        String x$6 = qual$2.addDefault$default$3();
        parser = new Parser("AppAnalyzer", "run apps and analyze their consent dialogs").addOptional("config", "c", "config", (Option)new Some((Object)"./config.json"), " the configuration file").addSubparser(qual$1.addDefault("func", (Object)x$2, x$3)).addSubparser(new Parser("run", "run an action/analysis").addPositional("platform", "the platform to be analyzed [android_device,android_emulator,ios]").addSubparser(qual$2.addDefault("func", (Object)x$5, x$6)).addSubparser(new Parser("plugin", "run an analysis using a plugin").addPositional("plugin", "the name of the actor plugin providing the analysis capabilities").addPositional("path", "path to the required data for the chosen action").addFlag("ephemeral", "e", "ephemeral", "if set the experiment will be deleted directly after execution").addFlag("empty", "w", "without-app", "if set then no app is installed and the analysis is run on the raw OS").addOptional("batchSize", "b", "batch", (Option)None$.MODULE$, "limit the amount of apps that are analyzed in bulk").addOptional("continue", "r", "resume", (Option)None$.MODULE$, "provides the experiment to be continued").addOptional("parameters", "p", "parameters", (Option)None$.MODULE$, "a csv list of <key>=<value> pairs").addDefault("func", (Function2 & Serializable)(pargs, conf) -> {
            AppAnalyzer$.MODULE$.runPluginExperiment(pargs, conf);
            return BoxedUnit.UNIT;
        }, "runs an experiment using the specified plugin")));
        bitmap$init$0 = (byte)(bitmap$init$0 | 4);
    }

    private Logger logger$lzycompute() {
        AppAnalyzer$ appAnalyzer$ = this;
        synchronized (appAnalyzer$) {
            if (!bitmap$0) {
                logger = LazyLogger.logger$((LazyLogger)this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        return !bitmap$0 ? this.logger$lzycompute() : logger;
    }

    private BoundedExecutorService executorService() {
        if ((byte)(bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/simon/tools/mobile-analysis/scala-appanalyzer/src/main/scala/de/halcony/appanalyzer/AppAnalyzer.scala: 29");
        }
        return executorService;
    }

    private ExecutionContextExecutorService executionContext() {
        if ((byte)(bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/simon/tools/mobile-analysis/scala-appanalyzer/src/main/scala/de/halcony/appanalyzer/AppAnalyzer.scala: 34");
        }
        return executionContext;
    }

    public Parser parser() {
        if ((byte)(bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/simon/tools/mobile-analysis/scala-appanalyzer/src/main/scala/de/halcony/appanalyzer/AppAnalyzer.scala: 36");
        }
        return parser;
    }

    public void main(String[] args) {
        try {
            ParsingResult pargs = this.parser().parse(args);
            Config conf = Config$.MODULE$.parse((String)pargs.getValue("config"));
            ((Function2)pargs.getValue("func")).apply((Object)pargs, (Object)conf);
        }
        catch (ParsingException parsingException) {
        }
        catch (Throwable x) {
            Predef$.MODULE$.println((Object)x);
        }
    }

    public Option<Object> getBatchSize(ParsingResult pargs) {
        Some some;
        try {
            some = new Some((Object)BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)pargs.getValue("batchSize")))));
        }
        catch (Throwable throwable) {
            some = None$.MODULE$;
        }
        return some;
    }

    public void deleteAnalysisMain(ParsingResult pargs, Config conf) {
        block12: {
            Postgres$.MODULE$.initializeConnectionPool(conf);
            try (BufferedSource delete = Source$.MODULE$.fromFile((String)pargs.getValue("path"), Codec$.MODULE$.fallbackSystemCodec());){
                List list;
                if (new File((String)pargs.getValue("analysisIds")).exists()) {
                    try (BufferedSource source = Source$.MODULE$.fromFile((String)pargs.getValue("analysisIds"), Codec$.MODULE$.fallbackSystemCodec());){
                        list = source.getLines().map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$1)))).toList();
                    }
                } else {
                    list = Predef$.MODULE$.wrapIntArray((int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])((String)pargs.getValue("analysisIds")).split(",")), (Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$2))), (ClassTag)ClassTag$.MODULE$.Int())).toList();
                }
                List json = list;
                Predef$.MODULE$.println((Object)new StringBuilder(42).append("shall we really delete those [").append(json.length()).append("] analysis: ").append(json.mkString(",")).toString());
                String userInput = StdIn$.MODULE$.readLine("[Yes/No]", (Seq)Nil$.MODULE$);
                String string = userInput.trim().toLowerCase();
                String string2 = "yes";
                if (string == null) {
                    if (string2 != null) {
                        break block12;
                    }
                } else if (!string.equals(string2)) break block12;
                Postgres$.MODULE$.withDatabaseSession((Function1 & Serializable)session -> {
                    json.foreach((Function1)(JFunction1.mcII.sp & Serializable)id -> {
                        BoxedUnit boxedUnit;
                        if (AppAnalyzer$.MODULE$.logger().isEnabled((LogLevel)LogLevel.INFO$.MODULE$)) {
                            AppAnalyzer$.MODULE$.logger().log((LogLevel)LogLevel.INFO$.MODULE$, new LogSource("/home/simon/tools/mobile-analysis/scala-appanalyzer/src/main/scala/de/halcony/appanalyzer/AppAnalyzer.scala", "AppAnalyzer.scala", 111, 21), (Object)new StringBuilder(9).append("deleting ").append(id).toString());
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        return SQLInterpolationString$.MODULE$.sql$extension(package$.MODULE$.scalikejdbcSQLInterpolationImplicitDef(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"DELETE FROM interfaceanalysis WHERE id = ", ""}))), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)id)})).update().apply(session);
                    });
                    return BoxedUnit.UNIT;
                });
            }
        }
    }

    private Device getDevice(ParsingResult pargs, Config conf) {
        Device device;
        block4: {
            String string = (String)pargs.getValue("platform");
            switch (string == null ? 0 : string.hashCode()) {
                case 104461: {
                    if (!"ios".equals(string)) break;
                    device = new iOSDevice(conf);
                    break block4;
                }
                case 38574630: {
                    if (!"android_device".equals(string)) break;
                    device = new AndroidDevice(conf);
                    break block4;
                }
            }
            throw new RuntimeException(new StringBuilder(33).append("device type ").append(string).append(" is not yet supported").toString());
        }
        return device;
    }

    private scala.collection.immutable.Map<String, MobileApp> readManifestFile(String path) {
        scala.collection.immutable.Map map;
        if (new File(path).exists()) {
            BoxedUnit boxedUnit;
            if (this.logger().isEnabled((LogLevel)LogLevel.INFO$.MODULE$)) {
                this.logger().log((LogLevel)LogLevel.INFO$.MODULE$, new LogSource("/home/simon/tools/mobile-analysis/scala-appanalyzer/src/main/scala/de/halcony/appanalyzer/AppAnalyzer.scala", "AppAnalyzer.scala", 135, 11), (Object)"detected app manifest");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            try (BufferedSource source = Source$.MODULE$.fromFile(path, Codec$.MODULE$.fallbackSystemCodec());){
                map = (scala.collection.immutable.Map)((JsObject)JsonParser$.MODULE$.apply((ParserInput)ParserInput$.MODULE$.apply(source.getLines().mkString("\n")))).fields().map((Function1 & Serializable)x0$1 -> {
                    Tuple2 tuple2;
                    block8: {
                        BoxedUnit boxedUnit;
                        block6: {
                            Enumeration.Value value;
                            String string;
                            String string2;
                            Object object;
                            JsObject jsObject;
                            block7: {
                                Tuple2 tuple22 = x0$1;
                                if (tuple22 == null) break block6;
                                String path = (String)tuple22._1();
                                JsValue app = (JsValue)tuple22._2();
                                if (path == null) break block6;
                                String string3 = path;
                                if (!(app instanceof JsObject)) break block6;
                                jsObject = (JsObject)app;
                                object = Predef$.MODULE$.ArrowAssoc((Object)string3);
                                string2 = ((JsString)jsObject.fields().apply((Object)"id")).value();
                                string = ((JsString)jsObject.fields().apply((Object)"version")).value();
                                String string4 = ((JsString)jsObject.fields().apply((Object)"os")).value().toLowerCase();
                                switch (string4 == null ? 0 : string4.hashCode()) {
                                    case -861391249: {
                                        if (!"android".equals(string4)) break;
                                        value = PlatformOS$.MODULE$.Android();
                                        break block7;
                                    }
                                    case 104461: {
                                        if (!"ios".equals(string4)) break;
                                        value = PlatformOS$.MODULE$.iOS();
                                        break block7;
                                    }
                                }
                                throw new MatchError((Object)string4);
                            }
                            tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, (Object)new MobileApp(string2, string, value, ((JsString)jsObject.fields().apply((Object)"path")).value()));
                            break block8;
                        }
                        if (MODULE$.logger().isEnabled((LogLevel)LogLevel.ERROR$.MODULE$)) {
                            MODULE$.logger().log((LogLevel)LogLevel.ERROR$.MODULE$, new LogSource("/home/simon/tools/mobile-analysis/scala-appanalyzer/src/main/scala/de/halcony/appanalyzer/AppAnalyzer.scala", "AppAnalyzer.scala", 150, 18), (Object)"manifest seems broken");
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"NO"), (Object)new MobileApp("NO", "NO", PlatformOS$.MODULE$.Android(), "NO"));
                    }
                    return tuple2;
                }).filter((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)AppAnalyzer$.$anonfun$readManifestFile$2(x0$2)));
            }
        } else {
            map = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        }
        return map;
    }

    private void writeManifestFile(String path, scala.collection.immutable.Map<String, MobileApp> apps) {
        FileWriter file = new FileWriter(new File(path));
        try {
            file.write(new JsObject((scala.collection.immutable.Map)apps.map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String path = (String)tuple2._1();
                MobileApp app = (MobileApp)tuple2._2();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)path), (Object)JsObject$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)new JsString(app.id())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)new JsString(app.version())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"os"), (Object)new JsString(app.getOsString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)new JsString(app.path()))})));
                return tuple22;
            })).prettyPrint());
        }
        finally {
            file.flush();
            file.close();
        }
    }

    private List<MobileApp> filterAppsInFolder(String folderPath, List<String> appPaths, Config conf, Enumeration.Value os, boolean filtering) {
        Product product;
        String manifestFilePath = new StringBuilder(14).append(folderPath).append("/manifest.json").toString();
        Map manifest = (Map)Map$.MODULE$.apply((Seq)this.readManifestFile(manifestFilePath).toList());
        Enumeration.Value value = os;
        Enumeration.Value value2 = PlatformOS$.MODULE$.Android();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            product = new APK(conf);
        } else {
            Enumeration.Value value4 = PlatformOS$.MODULE$.iOS();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                product = new IPA(conf);
            } else {
                throw new MatchError((Object)value);
            }
        }
        APK inspector = product;
        Set alreadyChecked = filtering ? Experiment$.MODULE$.getAnalyzedApps().map((Function1 & Serializable)x$3 -> x$3.id()).toSet() : (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
        Future appFuture = Future$.MODULE$.sequence((IterableOnce)appPaths.map((Function1 & Serializable)path -> Future$.MODULE$.apply((Function0 & Serializable)() -> {
            None$ none$;
            block15: {
                try {
                    MobileApp mobileApp;
                    Option option;
                    Map map = manifest;
                    synchronized (map) {
                        option = manifest.get(path);
                    }
                    Option option2 = option;
                    if (option2 instanceof Some) {
                        MobileApp app;
                        Some some = (Some)option2;
                        mobileApp = app = (MobileApp)some.value();
                    } else if (None$.MODULE$.equals(option2)) {
                        MobileApp app = new MobileApp(((Analysis)inspector).getAppId(new MobileApp("", "", os, (String)path)), "NA", os, (String)path);
                        Map map2 = manifest;
                        synchronized (map2) {
                            Map cfr_ignored_0 = (Map)manifest.addOne((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(path), (Object)app));
                        }
                        mobileApp = app;
                    } else {
                        throw new MatchError((Object)option2);
                    }
                    MobileApp app = mobileApp;
                    if (alreadyChecked.contains((Object)app.id())) {
                        none$ = None$.MODULE$;
                        break block15;
                    }
                    none$ = new Some((Object)app);
                }
                catch (Throwable x) {
                    BoxedUnit boxedUnit;
                    if (MODULE$.logger().isEnabled((LogLevel)LogLevel.ERROR$.MODULE$)) {
                        MODULE$.logger().log((LogLevel)LogLevel.ERROR$.MODULE$, new LogSource("/home/simon/tools/mobile-analysis/scala-appanalyzer/src/main/scala/de/halcony/appanalyzer/AppAnalyzer.scala", "AppAnalyzer.scala", 213, 22), (Object)x.getMessage());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    none$ = None$.MODULE$;
                }
            }
            return none$;
        }, (ExecutionContext)MODULE$.executionContext())), BuildFrom$.MODULE$.buildFromIterableOps(), (ExecutionContext)this.executionContext());
        List ret = ((List)Await$.MODULE$.result((Awaitable)appFuture, (Duration)Duration$.MODULE$.Inf())).filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.nonEmpty())).map((Function1 & Serializable)x$5 -> (MobileApp)x$5.get());
        this.writeManifestFile(manifestFilePath, (scala.collection.immutable.Map<String, MobileApp>)manifest.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        return ret;
    }

    private List<MobileApp> getRelevantApps(ParsingResult pargs, Device device, Config conf, boolean filtering) {
        List<MobileApp> list;
        String path = (String)pargs.getValue("path");
        Enumeration.Value value = device.PLATFORM_OS();
        Enumeration.Value value2 = PlatformOS$.MODULE$.Android();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            Tuple2 tuple2;
            Tuple2 tuple22;
            if (new File(path).isDirectory()) {
                tuple22 = new Tuple2((Object)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])new File(path).listFiles()), (Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.isFile()))), (Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)AppAnalyzer$.$anonfun$getRelevantApps$2(x$7)))), (Function1 & Serializable)x$8 -> x$8.getPath(), ClassTag$.MODULE$.apply(String.class))).toList(), (Object)path);
            } else {
                Predef$.MODULE$.assert(path.endsWith(".apk"), (Function0 & Serializable)() -> new StringBuilder(47).append("path has to end with apk if not a directory in ").append(path).toString());
                tuple22 = tuple2 = new Tuple2(scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{path})), (Object)new File(path).getParentFile().getPath());
            }
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            List apks = (List)tuple2._1();
            String folder = (String)tuple2._2();
            Tuple2 tuple23 = new Tuple2((Object)apks, (Object)folder);
            Tuple2 tuple24 = tuple23;
            List apks2 = (List)tuple24._1();
            String folder2 = (String)tuple24._2();
            list = this.filterAppsInFolder(folder2, (List<String>)apks2, conf, PlatformOS$.MODULE$.Android(), filtering);
        } else {
            Enumeration.Value value4 = PlatformOS$.MODULE$.iOS();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                Tuple2 tuple2;
                Tuple2 tuple25;
                if (new File(path).isDirectory()) {
                    tuple25 = new Tuple2((Object)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])new File(path).listFiles()), (Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)x$10.isFile()))), (Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)AppAnalyzer$.$anonfun$getRelevantApps$6(x$11)))), (Function1 & Serializable)x$12 -> x$12.getPath(), ClassTag$.MODULE$.apply(String.class))).toList(), (Object)path);
                } else {
                    Predef$.MODULE$.assert(path.endsWith(".ipa"), (Function0 & Serializable)() -> new StringBuilder(47).append("path has to end with ipa if not a directory in ").append(path).toString());
                    tuple25 = tuple2 = new Tuple2(scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{path})), (Object)new File(path).getParentFile().getPath());
                }
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                List ipas = (List)tuple2._1();
                String folder = (String)tuple2._2();
                Tuple2 tuple26 = new Tuple2((Object)ipas, (Object)folder);
                Tuple2 tuple27 = tuple26;
                List ipas2 = (List)tuple27._1();
                String folder3 = (String)tuple27._2();
                list = this.filterAppsInFolder(folder3, (List<String>)ipas2, conf, PlatformOS$.MODULE$.iOS(), filtering);
            } else {
                throw new MatchError((Object)value);
            }
        }
        List<MobileApp> apps = list;
        return apps.slice(0, BoxesRunTime.unboxToInt((Object)this.getBatchSize(pargs).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> apps.length())));
    }

    private boolean getRelevantApps$default$4() {
        return true;
    }

    private void runExperiment(Function0<ActorPlugin> getNextActor, ParsingResult pargs, Config conf, boolean empty) {
        BoxedUnit boxedUnit;
        Device device;
        block27: {
            Experiment experiment;
            BoxedUnit boxedUnit2;
            device = this.getDevice(pargs, conf);
            Postgres$.MODULE$.initializeConnectionPool(conf);
            String description = (String)pargs.getValue("description");
            if (this.logger().isEnabled((LogLevel)LogLevel.INFO$.MODULE$)) {
                this.logger().log((LogLevel)LogLevel.INFO$.MODULE$, new LogSource("/home/simon/tools/mobile-analysis/scala-appanalyzer/src/main/scala/de/halcony/appanalyzer/AppAnalyzer.scala", "AppAnalyzer.scala", 266, 9), (Object)new StringBuilder(8).append("running ").append(description).toString());
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            Option option = (Option)((ParsingResultValue)pargs.get("continue")).value();
            if (option instanceof Some) {
                Some some = (Some)option;
                String value = (String)some.value();
                experiment = Experiment$.MODULE$.loadExperiment(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(value)));
            } else if (None$.MODULE$.equals(option)) {
                experiment = Experiment$.MODULE$.createNewExperiment(description);
            } else {
                throw new MatchError((Object)option);
            }
            try {
                try {
                    if (!empty) {
                        List<MobileApp> apps = this.getRelevantApps(pargs, device, conf, this.getRelevantApps$default$4());
                        IntRef counter = IntRef.create((int)apps.length());
                        apps.foreach((Function1 & Serializable)app -> {
                            AppAnalyzer$.$anonfun$runExperiment$1(counter, getNextActor, device, conf, app);
                            return BoxedUnit.UNIT;
                        });
                        break block27;
                    }
                    Analysis$.MODULE$.runAnalysis((ActorPlugin)getNextActor.apply(), new MobileApp("EMPTY", "EMPTY", device.PLATFORM_OS(), "EMPTY"), device, conf);
                }
                catch (FatalError x) {
                    BoxedUnit boxedUnit3;
                    if (this.logger().isEnabled((LogLevel)LogLevel.ERROR$.MODULE$)) {
                        this.logger().log((LogLevel)LogLevel.ERROR$.MODULE$, new LogSource("/home/simon/tools/mobile-analysis/scala-appanalyzer/src/main/scala/de/halcony/appanalyzer/AppAnalyzer.scala", "AppAnalyzer.scala", 286, 14), (Object)x.getMessage());
                        boxedUnit3 = BoxedUnit.UNIT;
                        break block27;
                    }
                    boxedUnit3 = BoxedUnit.UNIT;
                }
                catch (Throwable x) {
                    BoxedUnit boxedUnit4;
                    if (this.logger().isEnabled((LogLevel)LogLevel.ERROR$.MODULE$)) {
                        this.logger().log((LogLevel)LogLevel.ERROR$.MODULE$, new LogSource("/home/simon/tools/mobile-analysis/scala-appanalyzer/src/main/scala/de/halcony/appanalyzer/AppAnalyzer.scala", "AppAnalyzer.scala", 288, 14), (Object)new StringBuilder(3).append(x.getMessage()).append(" \n ").append(Predef$.MODULE$.wrapRefArray((Object[])x.getStackTrace()).mkString("\n")).toString());
                        boxedUnit4 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit4 = BoxedUnit.UNIT;
                    }
                    Experiment$.MODULE$.addEncounteredError(x, Experiment$.MODULE$.addEncounteredError$default$2(), Experiment$.MODULE$.addEncounteredError$default$3());
                }
            }
            catch (Throwable throwable) {
                BoxedUnit boxedUnit5;
                device.resetDevice();
                if (BoxesRunTime.unboxToBoolean((Object)pargs.getValue("ephemeral"))) {
                    BoxedUnit boxedUnit6;
                    Experiment$.MODULE$.deleteCurrentExperiment();
                    if (this.logger().isEnabled((LogLevel)LogLevel.INFO$.MODULE$)) {
                        this.logger().log((LogLevel)LogLevel.INFO$.MODULE$, new LogSource("/home/simon/tools/mobile-analysis/scala-appanalyzer/src/main/scala/de/halcony/appanalyzer/AppAnalyzer.scala", "AppAnalyzer.scala", 294, 13), (Object)"ephemeral experiment is done");
                        boxedUnit6 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit6 = BoxedUnit.UNIT;
                    }
                } else if (this.logger().isEnabled((LogLevel)LogLevel.INFO$.MODULE$)) {
                    this.logger().log((LogLevel)LogLevel.INFO$.MODULE$, new LogSource("/home/simon/tools/mobile-analysis/scala-appanalyzer/src/main/scala/de/halcony/appanalyzer/AppAnalyzer.scala", "AppAnalyzer.scala", 296, 13), (Object)new StringBuilder(19).append("experiment ").append(Experiment$.MODULE$.getCurrentExperiment().id()).append(" is done").toString());
                    boxedUnit5 = BoxedUnit.UNIT;
                } else {
                    boxedUnit5 = BoxedUnit.UNIT;
                }
                throw throwable;
            }
        }
        device.resetDevice();
        if (BoxesRunTime.unboxToBoolean((Object)pargs.getValue("ephemeral"))) {
            BoxedUnit boxedUnit7;
            Experiment$.MODULE$.deleteCurrentExperiment();
            if (this.logger().isEnabled((LogLevel)LogLevel.INFO$.MODULE$)) {
                this.logger().log((LogLevel)LogLevel.INFO$.MODULE$, new LogSource("/home/simon/tools/mobile-analysis/scala-appanalyzer/src/main/scala/de/halcony/appanalyzer/AppAnalyzer.scala", "AppAnalyzer.scala", 294, 13), (Object)"ephemeral experiment is done");
                boxedUnit7 = BoxedUnit.UNIT;
            } else {
                boxedUnit7 = BoxedUnit.UNIT;
            }
        } else if (this.logger().isEnabled((LogLevel)LogLevel.INFO$.MODULE$)) {
            this.logger().log((LogLevel)LogLevel.INFO$.MODULE$, new LogSource("/home/simon/tools/mobile-analysis/scala-appanalyzer/src/main/scala/de/halcony/appanalyzer/AppAnalyzer.scala", "AppAnalyzer.scala", 296, 13), (Object)new StringBuilder(19).append("experiment ").append(Experiment$.MODULE$.getCurrentExperiment().id()).append(" is done").toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    private void runPluginExperiment(ParsingResult pargs, Config conf) {
        scala.collection.immutable.Map map;
        String pluginName = (String)pargs.getValue("plugin");
        boolean empty = BoxesRunTime.unboxToBoolean((Object)pargs.getValue("empty"));
        Option option = (Option)((ParsingResultValue)pargs.get("parameters")).value();
        if (option instanceof Some) {
            Some some = (Some)option;
            String keyvaluecsv = (String)some.value();
            map = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])keyvaluecsv.split(",")), (Function1 & Serializable)keyValue -> {
                String value;
                String key;
                block3: {
                    List list;
                    block2: {
                        list = Predef$.MODULE$.wrapRefArray((Object[])keyValue.split("=")).toList();
                        if (!(list instanceof .colon.colon)) break block2;
                        .colon.colon colon2 = (.colon.colon)list;
                        key = (String)colon2.head();
                        List list2 = colon2.next$access$1();
                        if (!(list2 instanceof .colon.colon)) break block2;
                        .colon.colon colon3 = (.colon.colon)list2;
                        value = (String)colon3.head();
                        List list3 = colon3.next$access$1();
                        Nil$ nil$ = scala.package$.MODULE$.Nil();
                        List list4 = list3;
                        if (!(nil$ != null ? !nil$.equals(list4) : list4 != null)) break block3;
                    }
                    throw new RuntimeException(new StringBuilder(34).append("element ").append((String)keyValue).append(" of ").append(keyvaluecsv).append(" has malformed split: ").append(list).toString());
                }
                Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value);
                return tuple2;
            }, ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        } else if (None$.MODULE$.equals(option)) {
            map = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        } else {
            throw new MatchError((Object)option);
        }
        scala.collection.immutable.Map parameters = map;
        PluginManager manager = PluginManager$.MODULE$.getPluginManager(conf);
        this.runExperiment((Function0<ActorPlugin>)(Function0 & Serializable)() -> manager.loadPlugin(pluginName, (scala.collection.immutable.Map<String, String>)parameters), pargs, conf, empty);
    }

    private void functionalityCheck(ParsingResult pargs, Config conf) {
        Predef$.MODULE$.println((Object)"Welcome to the functionality check!");
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"This is most likely the most important yet most frustrating feature of all.");
        Predef$.MODULE$.println((Object)"We will go through each element of the Device and Appium API to check if it works with the currently");
        Predef$.MODULE$.println((Object)"attached and configured device.");
        Predef$.MODULE$.println((Object)"As the path parameter I expect a single app");
        Predef$.MODULE$.println((Object)"If something fails I might give some useful hints or just crash \u00af\\_(oo)_/\u00af.");
        Predef$.MODULE$.println((Object)"Let's start...");
        Device device = this.getDevice(pargs, conf);
        String path = (String)pargs.getValue("path");
        Predef$.MODULE$.println((Object)new StringBuilder(27).append("We are supposed to work on ").append(device.PLATFORM_OS()).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(31).append("As our Canary App we are using ").append(path).toString());
        AppAnalyzer$.tryApiCommand$1("device.ensureDevice", AppAnalyzer$.tryApiCommand$default$2$1(), AppAnalyzer$.tryApiCommand$default$3$1(), (Function0 & Serializable)() -> {
            device.ensureDevice();
            return None$.MODULE$;
        });
        AppAnalyzer$.tryApiCommand$1("device.startFrida", AppAnalyzer$.tryApiCommand$default$2$1(), AppAnalyzer$.tryApiCommand$default$3$1(), (Function0 & Serializable)() -> {
            device.startFrida();
            return None$.MODULE$;
        });
        AppAnalyzer$.tryApiCommand$1("device.restartPhone", AppAnalyzer$.tryApiCommand$default$2$1(), AppAnalyzer$.tryApiCommand$default$3$1(), (Function0 & Serializable)() -> None$.MODULE$);
        AppAnalyzer$.tryApiCommand$1("device.getAppPackageAnalysis", AppAnalyzer$.tryApiCommand$default$2$1(), AppAnalyzer$.tryApiCommand$default$3$1(), (Function0 & Serializable)() -> {
            device.getAppPackageAnalysis(conf);
            return None$.MODULE$;
        });
        MobileApp app = new MobileApp("", "", PlatformOS$.MODULE$.iOS(), path);
        AppAnalyzer$.tryApiCommand$1("appPackageAnalysis.getAppId", AppAnalyzer$.tryApiCommand$default$2$1(), AppAnalyzer$.tryApiCommand$default$3$1(), (Function0 & Serializable)() -> new Some((Object)device.getAppPackageAnalysis(conf).getAppId(app)));
        AppAnalyzer$.tryApiCommand$1("installApp", AppAnalyzer$.tryApiCommand$default$2$1(), AppAnalyzer$.tryApiCommand$default$3$1(), (Function0 & Serializable)() -> {
            device.installApp(app);
            return None$.MODULE$;
        });
        String appId = device.getAppPackageAnalysis(conf).getAppId(app);
        AppAnalyzer$.tryApiCommand$1("grantPermissios", AppAnalyzer$.tryApiCommand$default$2$1(), AppAnalyzer$.tryApiCommand$default$3$1(), (Function0 & Serializable)() -> {
            device.setAppPermissions(appId);
            return None$.MODULE$;
        });
        AppAnalyzer$.tryApiCommand$1("startApp", AppAnalyzer$.tryApiCommand$default$2$1(), AppAnalyzer$.tryApiCommand$default$3$1(), (Function0 & Serializable)() -> {
            device.startApp(appId, device.startApp$default$2());
            Object object = device.getForegroundAppId().get();
            String string = appId;
            return new Some((Object)new StringBuilder(13).append("app running: ").append(!(object != null ? !object.equals(string) : string != null)).toString());
        });
        AppAnalyzer$.tryApiCommand$1("getPid", AppAnalyzer$.tryApiCommand$default$2$1(), AppAnalyzer$.tryApiCommand$default$3$1(), (Function0 & Serializable)() -> new Some((Object)device.getPid(appId)));
        AppAnalyzer$.tryApiCommand$1("getPrefs", AppAnalyzer$.tryApiCommand$default$2$1(), AppAnalyzer$.tryApiCommand$default$3$1(), (Function0 & Serializable)() -> device.getPrefs(appId));
        AppAnalyzer$.tryApiCommand$1("getPlatformSpecificData", AppAnalyzer$.tryApiCommand$default$2$1(), AppAnalyzer$.tryApiCommand$default$3$1(), (Function0 & Serializable)() -> device.getPlatformSpecificData(appId));
        Predef$.MODULE$.println((Object)"seems like everything is in working order");
        Predef$.MODULE$.println((Object)"now we are going into some more involved features corresponding to our promised functionalities");
        AppAnalyzer$.tryApiCommand$1("appium.getElements", AppAnalyzer$.tryApiCommand$default$2$1(), AppAnalyzer$.tryApiCommand$default$3$1(), (Function0 & Serializable)() -> (Some)Appium$.MODULE$.withRunningAppium(appId, conf, device, (Function1 & Serializable)appium -> new Some((Object)appium.findElementsByXPath("//*").map((Function1 & Serializable)x$14 -> x$14.getText().trim()).filter((Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)AppAnalyzer$.$anonfun$functionalityCheck$15(x$15))).mkString("\n"))));
        AppAnalyzer$.tryApiCommand$1("stopApp", AppAnalyzer$.tryApiCommand$default$2$1(), AppAnalyzer$.tryApiCommand$default$3$1(), (Function0 & Serializable)() -> {
            device.closeApp(appId);
            Object object = device.getForegroundAppId().getOrElse((Function0 & Serializable)() -> "nobody");
            String string = appId;
            return new Some((Object)new StringBuilder(13).append("app running: ").append(!(object != null ? !object.equals(string) : string != null)).toString());
        });
        AppAnalyzer$.tryApiCommand$1("device.stopFrida", AppAnalyzer$.tryApiCommand$default$2$1(), AppAnalyzer$.tryApiCommand$default$3$1(), (Function0 & Serializable)() -> {
            device.stopFrida();
            return None$.MODULE$;
        });
        AppAnalyzer$.tryApiCommand$1("uninstallApp", AppAnalyzer$.tryApiCommand$default$2$1(), AppAnalyzer$.tryApiCommand$default$3$1(), (Function0 & Serializable)() -> {
            device.uninstallApp(appId);
            return None$.MODULE$;
        });
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(AppAnalyzer$.class);
    }

    public static final /* synthetic */ boolean $anonfun$readManifestFile$2(Tuple2 x0$2) {
        String path;
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String string = path = (String)tuple2._1();
        String string2 = "NO";
        boolean bl = string == null ? string2 != null : !string.equals(string2);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$getRelevantApps$2(File x$7) {
        return x$7.getPath().endsWith(".apk");
    }

    public static final /* synthetic */ boolean $anonfun$getRelevantApps$6(File x$11) {
        return x$11.getPath().endsWith(".ipa");
    }

    public static final /* synthetic */ void $anonfun$runExperiment$1(IntRef counter$1, Function0 getNextActor$1, Device device$1, Config conf$1, MobileApp app) {
        BoxedUnit boxedUnit;
        if (MODULE$.logger().isEnabled((LogLevel)LogLevel.INFO$.MODULE$)) {
            MODULE$.logger().log((LogLevel)LogLevel.INFO$.MODULE$, new LogSource("/home/simon/tools/mobile-analysis/scala-appanalyzer/src/main/scala/de/halcony/appanalyzer/AppAnalyzer.scala", "AppAnalyzer.scala", 277, 17), (Object)new StringBuilder(23).append("we have ").append(counter$1.elem).append(" app").append((Object)(counter$1.elem > 1 ? "s" : "")).append(" to analyze").toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Analysis$.MODULE$.runAnalysis((ActorPlugin)getNextActor$1.apply(), app, device$1, conf$1);
        --counter$1.elem;
    }

    private static final void tryApiCommand$1(String description, Option failureHint, boolean optional, Function0 func) {
        block8: {
            try {
                Predef$.MODULE$.println((Object)new StringBuilder(8).append("action: ").append(description).toString());
                Option option = (Option)func.apply();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String value = (String)some.value();
                    Predef$.MODULE$.println((Object)new StringBuilder(8).append("return: ").append(value).toString());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block8;
                }
                if (None$.MODULE$.equals(option)) {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block8;
                }
                throw new MatchError((Object)option);
            }
            catch (Throwable x) {
                Predef$.MODULE$.println((Object)new StringBuilder(13).append("Failed with: ").append(x.getMessage()).toString());
                Predef$.MODULE$.println((Object)Predef$.MODULE$.wrapRefArray((Object[])x.getStackTrace()).mkString("\n"));
                Option option = failureHint;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String value = (String)some.value();
                    Predef$.MODULE$.println((Object)new StringBuilder(6).append("Hint: ").append(value).toString());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (None$.MODULE$.equals(option)) {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)option);
                }
                if (optional) break block8;
                throw new RuntimeException(new StringBuilder(31).append(description).append(" failed, no point in continuing").toString());
            }
        }
        Predef$.MODULE$.println();
    }

    private static final Option tryApiCommand$default$2$1() {
        return None$.MODULE$;
    }

    private static final boolean tryApiCommand$default$3$1() {
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$functionalityCheck$15(String x$15) {
        String string = x$15;
        String string2 = "";
        return string == null ? string2 != null : !string.equals(string2);
    }

    private AppAnalyzer$() {
    }
}

