/*
 * Decompiled with CFR 0.152.
 */
package de.haumacher.msgbuf.binary;

import de.haumacher.msgbuf.binary.BinaryUtil;
import de.haumacher.msgbuf.binary.DataReader;
import de.haumacher.msgbuf.binary.State;
import de.haumacher.msgbuf.binary.Tag;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class OctetDataReader
implements DataReader {
    private static final int MASK_3 = 7;
    private static final int MASK_7 = 127;
    private static final int BIT_8 = 128;
    static final int BIT_1 = 1;
    private static final int NO_NAME = -1;
    private static final int END_OF_OBJECT = -2;
    private final InputStream _in;
    private State _state = State.START;
    private Tag _content = Tag.OBJ;
    private int _length;
    private final List<SFrame> _stack = new ArrayList<SFrame>();
    private int _name;

    public OctetDataReader(InputStream in) {
        this._in = in;
    }

    @Override
    public void beginObject() throws IOException {
        State before = this._state;
        this.consumeValue(Tag.OBJ);
        this._stack.add(new SFrame(before, this._length, this._content));
        this._state = State.FIELD;
        this._name = -1;
    }

    @Override
    public void endObject() throws IOException {
        this.require(State.FIELD);
        this.fetchName();
        assert (this._name == -2) : "There are more fields to read.";
        SFrame sFrame = this._stack.remove(this._stack.size() - 1);
        this._state = sFrame.getState();
        this._length = sFrame.getLength();
        this._content = sFrame.getContent();
        this._name = -1;
    }

    @Override
    public boolean hasNext() throws IOException {
        switch (this._state) {
            case FIELD: {
                this.fetchName();
                return this._name >= 0;
            }
            case ARRAY_VALUE: {
                return this._length > 0;
            }
        }
        return false;
    }

    @Override
    public int nextName() throws IOException {
        this.require(State.FIELD);
        this.fetchName();
        assert (this._name >= 0) : "No more fields left";
        this._state = State.FIELD_VALUE;
        int result = this._name;
        this._name = -1;
        return result;
    }

    private void fetchName() throws IOException {
        if (this._name == -1) {
            int nameAndTag = this.readVarInt();
            this._content = OctetDataReader.tag(nameAndTag);
            this._name = this._content == Tag.STOP ? -2 : OctetDataReader.name(nameAndTag);
        }
    }

    @Override
    public int nextInt() throws IOException {
        this.consumeValue(Tag.VAR);
        return this.readVarInt();
    }

    @Override
    public int nextIntSigned() throws IOException {
        this.consumeValue(Tag.VAR);
        return BinaryUtil.zigzagDecode(this.readVarInt());
    }

    @Override
    public int nextIntFixed() throws IOException {
        this.consumeValue(Tag.F32);
        return this.readFixedInt();
    }

    @Override
    public long nextLong() throws IOException {
        this.consumeValue(Tag.VAR);
        return this.readVarLong();
    }

    @Override
    public long nextLongSigned() throws IOException {
        this.consumeValue(Tag.VAR);
        return BinaryUtil.zigzagDecode(this.readVarLong());
    }

    @Override
    public long nextLongFixed() throws IOException {
        this.consumeValue(Tag.F64);
        return this.readFixedLong();
    }

    @Override
    public float nextFloat() throws IOException {
        this.consumeValue(Tag.F32);
        return Float.intBitsToFloat(this.readFixedInt());
    }

    @Override
    public double nextDouble() throws IOException {
        this.consumeValue(Tag.F64);
        return Double.longBitsToDouble(this.readFixedLong());
    }

    @Override
    public String nextString() throws IOException {
        this.consumeValue(Tag.REPEATED);
        long sizeAndTag = this.readVarLong();
        Tag tag = OctetDataReader.tag(sizeAndTag);
        assert (tag == Tag.CHAR) : "Received character string but '" + (Object)((Object)tag) + "' was requested.";
        int size = OctetDataReader.size(sizeAndTag);
        return new String(this.readBinary(size), "utf-8");
    }

    @Override
    public byte[] nextBinary() throws IOException {
        this.consumeValue(Tag.REPEATED);
        long sizeAndTag = this.readVarLong();
        Tag tag = OctetDataReader.tag(sizeAndTag);
        assert (tag == Tag.F8) : "Received '" + (Object)((Object)tag) + "' array but binary string was requested.";
        int size = OctetDataReader.size(sizeAndTag);
        return this.readBinary(size);
    }

    @Override
    public int beginArray() throws IOException {
        this.require(State.FIELD_VALUE);
        this._state = State.ARRAY_VALUE;
        long sizeAndTag = this.readVarLong();
        this._content = OctetDataReader.tag(sizeAndTag);
        this._length = OctetDataReader.size(sizeAndTag);
        return this._length;
    }

    @Override
    public void endArray() throws IOException {
        this.require(State.ARRAY_VALUE);
        assert (this._length == 0) : "Received array value (" + this._length + " remaining) while end of array was requested.";
        this._state = State.FIELD;
    }

    @Override
    public void skipValue() throws IOException {
        Tag tag = this._content;
        switch (tag) {
            case VAR: {
                this.nextLong();
                break;
            }
            case F32: {
                this.nextIntFixed();
                break;
            }
            case F64: {
                this.nextLongFixed();
                break;
            }
            case CHAR: 
            case F8: {
                this.consumeValue(tag);
                this._in.read();
                break;
            }
            case OBJ: {
                this.beginObject();
                while (this.hasNext()) {
                    this.nextName();
                    this.skipValue();
                }
                this.endObject();
                break;
            }
            case REPEATED: {
                this.beginArray();
                if (this._content == Tag.REPEATED) {
                    while (this.hasNext()) {
                        long sizeAndTag = this.readVarLong();
                        Tag content = OctetDataReader.tag(sizeAndTag);
                        int innerLength = OctetDataReader.size(sizeAndTag);
                        assert (content == Tag.F8 || content == Tag.CHAR) : "Invalid nested array: " + (Object)((Object)content);
                        this._in.skip(innerLength);
                        --this._length;
                    }
                } else {
                    while (this.hasNext()) {
                        this.skipValue();
                    }
                }
                this.endArray();
                break;
            }
            case STOP: {
                assert (false) : "No value to skip, end of object reached.";
                break;
            }
        }
    }

    private void require(State requested) {
        assert (this._state == requested) : "Expecting '" + (Object)((Object)this._state) + "' but received '" + (Object)((Object)requested) + "'.";
    }

    private void consumeValue(Tag requested) {
        switch (this._state) {
            case START: {
                assert (requested == Tag.OBJ) : "Data starts always with an object, '" + (Object)((Object)requested) + "' was requested.";
                this._state = State.FIELD;
                break;
            }
            case FIELD_VALUE: {
                this._state = State.FIELD;
                break;
            }
            case ARRAY_VALUE: {
                assert (this._length > 0) : "Expecting end of array.";
                --this._length;
                break;
            }
            default: {
                assert (false) : "Cannot read '" + (Object)((Object)requested) + "' in state '" + (Object)((Object)this._state) + "'.";
                break;
            }
        }
        assert (this._content == requested) : "Received '" + (Object)((Object)this._content) + "' while '" + (Object)((Object)requested) + "' was requested.";
    }

    private int readVarInt() throws IOException {
        int result = 0;
        int shift = 0;
        while (true) {
            int data;
            if ((data = this._in.read()) < 0) {
                throw new IOException("End of stream received, while reading var int.");
            }
            result |= (data & 0x7F) << shift;
            if ((data & 0x80) == 0) {
                return result;
            }
            shift += 7;
        }
    }

    private long readVarLong() throws IOException {
        long result = 0L;
        int shift = 0;
        while (true) {
            int data;
            if ((data = this._in.read()) < 0) {
                throw new IOException("End of stream received, while reading var int.");
            }
            result |= (long)((data & 0x7F) << shift);
            if ((data & 0x80) == 0) {
                return result;
            }
            shift += 7;
        }
    }

    private int readFixedInt() throws IOException {
        int result = 0;
        for (int n = 0; n < 4; ++n) {
            int data = this._in.read();
            if (data < 0) {
                throw new IOException("End of stream received, while reading fixed int.");
            }
            result <<= 8;
            result |= data;
        }
        return result;
    }

    private long readFixedLong() throws IOException {
        long result = 0L;
        for (int n = 0; n < 8; ++n) {
            int data = this._in.read();
            if (data < 0) {
                throw new IOException("End of stream received, while reading fixed int.");
            }
            result <<= 8;
            result |= (long)data;
        }
        return result;
    }

    private byte[] readBinary(int size) throws IOException {
        int direct;
        byte[] result = new byte[size];
        for (int offset = 0; offset < size; offset += direct) {
            direct = this._in.read(result, offset, size - offset);
            if (direct >= 0) continue;
            throw new IOException("Received end of stream while receiving a binary string of size '" + size + "'.");
        }
        return result;
    }

    private static int name(int nameAndTag) {
        return nameAndTag >>> 3;
    }

    private static Tag tag(int nameAndTag) {
        return Tag.values()[nameAndTag & 7];
    }

    private static int size(long sizeAndTag) {
        return (int)(sizeAndTag >>> 3);
    }

    private static Tag tag(long sizeAndTag) {
        return Tag.values()[(int)sizeAndTag & 7];
    }

    private static final class SFrame {
        private final State _state;
        private final int _length;
        private Tag _content;

        public SFrame(State state, int length, Tag expected) {
            this._state = state;
            this._length = length;
            this._content = expected;
        }

        public State getState() {
            return this._state;
        }

        public int getLength() {
            return this._length;
        }

        public Tag getContent() {
            return this._content;
        }
    }
}

