/*
 * Decompiled with CFR 0.152.
 */
package de.haumacher.msgbuf.binary;

import de.haumacher.msgbuf.binary.BinaryUtil;
import de.haumacher.msgbuf.binary.DataType;
import de.haumacher.msgbuf.binary.DataWriter;
import de.haumacher.msgbuf.binary.State;
import de.haumacher.msgbuf.binary.Tag;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class OctetDataWriter
implements DataWriter {
    private static final int MASK_7 = 127;
    private static final int MASK_8 = 255;
    private static final int BIT_8 = 128;
    private final OutputStream _out;
    private State _state = State.START;
    private int _field;
    private DataType _content;
    private int _length;
    private final List<SFrame> _stack = new ArrayList<SFrame>();

    public OctetDataWriter(OutputStream out) {
        this._out = out;
    }

    @Override
    public void beginObject() throws IOException {
        State before = this._state;
        switch (this._state) {
            case START: {
                break;
            }
            case FIELD_VALUE: {
                before = State.FIELD;
                break;
            }
            case ARRAY_VALUE: {
                this.consumeArrayValue(DataType.OBJECT);
                break;
            }
            default: {
                assert (false) : "Cannot start object in state '" + (Object)((Object)this._state) + "'.";
                break;
            }
        }
        this._stack.add(new SFrame(before, this._length, this._content));
        this._state = State.FIELD;
    }

    @Override
    public void endObject() throws IOException {
        this.expect(State.FIELD);
        this.writeVarInt(Tag.STOP.ordinal());
        SFrame frame = this._stack.remove(this._stack.size() - 1);
        this._state = frame.getState();
        this._length = frame.getLength();
        this._content = frame.getContent();
    }

    @Override
    public void beginArray(DataType type, int length) throws IOException {
        this.expect(State.FIELD_VALUE);
        this.writeVarInt(this.encodeId(Tag.REPEATED));
        this.writeVarLong(OctetDataWriter.encodeLength(type.tag(), length));
        this._length = length;
        this._content = type;
        this._state = State.ARRAY_VALUE;
    }

    @Override
    public void endArray() throws IOException {
        this.expect(State.ARRAY_VALUE);
        assert (this._length == 0);
        this._state = State.FIELD;
    }

    @Override
    public void name(int id) throws IOException {
        this.expect(State.FIELD);
        this._field = id;
        this._state = State.FIELD_VALUE;
    }

    @Override
    public void value(int value) throws IOException {
        this.valueSeen(DataType.INT);
        this.writeVarInt(value);
    }

    @Override
    public void valueSigned(int value) throws IOException {
        this.valueSeen(DataType.SINT);
        this.writeVarInt(BinaryUtil.zigzagEncode(value));
    }

    @Override
    public void valueFixed(int value) throws IOException {
        this.valueSeen(DataType.FINT);
        this.writeFixedInt(value);
    }

    @Override
    public void value(float value) throws IOException {
        this.valueSeen(DataType.FLOAT);
        this.writeFixedInt(Float.floatToIntBits(value));
    }

    @Override
    public void value(long value) throws IOException {
        this.valueSeen(DataType.LONG);
        this.writeVarLong(value);
    }

    @Override
    public void valueSigned(long value) throws IOException {
        this.valueSeen(DataType.SLONG);
        this.writeVarLong(BinaryUtil.zigzagEncode(value));
    }

    @Override
    public void valueFixed(long value) throws IOException {
        this.valueSeen(DataType.FLONG);
        this.writeFixedLong(value);
    }

    @Override
    public void value(double value) throws IOException {
        this.valueSeen(DataType.DOUBLE);
        this.writeFixedLong(Double.doubleToLongBits(value));
    }

    @Override
    public void value(byte[] value) throws IOException {
        this.valueSeen(DataType.BINARY);
        this.writeVarLong(OctetDataWriter.encodeLength(Tag.F8, value.length));
        this.writeBinary(value);
    }

    @Override
    public void value(String value) throws IOException {
        byte[] bytes = value.getBytes("utf-8");
        this.valueSeen(DataType.STRING);
        this.writeVarLong(OctetDataWriter.encodeLength(Tag.CHAR, bytes.length));
        this.writeBinary(bytes);
    }

    private void expect(State expected) {
        assert (this._state == expected) : "Invalid state '" + (Object)((Object)this._state) + "', expectd '" + (Object)((Object)expected) + "'.";
    }

    private void valueSeen(DataType type) throws IOException {
        switch (this._state) {
            case FIELD_VALUE: {
                this.writeVarInt(this.encodeId(type.tag()));
                this._state = State.FIELD;
                break;
            }
            case ARRAY_VALUE: {
                this.consumeArrayValue(type);
                break;
            }
            default: {
                assert (false) : "Invalid state '" + (Object)((Object)this._state) + "', expecting either '" + (Object)((Object)State.FIELD_VALUE) + "', or '" + (Object)((Object)State.ARRAY_VALUE) + "'.";
                break;
            }
        }
    }

    private void consumeArrayValue(DataType type) {
        assert (this._length > 0) : "End of array expected.";
        assert (this._content == type) : "Expected value of type '" + (Object)((Object)this._content) + "', but received '" + (Object)((Object)type) + "'.";
        --this._length;
    }

    private void writeVarInt(int data) throws IOException {
        int octet;
        while (true) {
            octet = data & 0x7F;
            if ((data >>>= 7) == 0) break;
            this._out.write(octet |= 0x80);
        }
        this._out.write(octet);
    }

    private void writeVarLong(long data) throws IOException {
        int octet;
        while (true) {
            octet = (int)data & 0x7F;
            if ((data >>>= 7) == 0L) break;
            this._out.write(octet |= 0x80);
        }
        this._out.write(octet);
    }

    private void writeFixedInt(int data) throws IOException {
        for (int shift = 24; shift >= 0; shift -= 8) {
            int octet = data >>> shift & 0xFF;
            this._out.write(octet);
        }
    }

    private void writeFixedLong(long data) throws IOException {
        for (int shift = 56; shift >= 0; shift -= 8) {
            int octet = (int)(data >>> shift) & 0xFF;
            this._out.write(octet);
        }
    }

    private void writeBinary(byte[] bytes) throws IOException {
        this._out.write(bytes);
    }

    private int encodeId(Tag tag) {
        return this._field << 3 | tag.ordinal();
    }

    private static long encodeLength(Tag tag, int length) {
        return (long)length << 3 | (long)tag.ordinal();
    }

    private static final class SFrame {
        private final State _state;
        private final int _length;
        private DataType _content;

        public SFrame(State state, int length, DataType dataType) {
            this._state = state;
            this._length = length;
            this._content = dataType;
        }

        public State getState() {
            return this._state;
        }

        public int getLength() {
            return this._length;
        }

        public DataType getContent() {
            return this._content;
        }
    }
}

