/*
 * Decompiled with CFR 0.152.
 */
package de.haumacher.msgbuf.binary;

import de.haumacher.msgbuf.binary.BinaryUtil;
import de.haumacher.msgbuf.binary.ContentTag;
import de.haumacher.msgbuf.binary.DataReader;
import de.haumacher.msgbuf.binary.FieldTag;
import de.haumacher.msgbuf.binary.State;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class OctetDataReader
implements DataReader {
    private static final int MASK_3 = 7;
    private static final int MASK_7 = 127;
    private static final int BIT_8 = 128;
    static final int BIT_1 = 1;
    private static final int NO_NAME = -1;
    private static final int END_OF_OBJECT = -2;
    final InputStream _in;
    State _state = State.START;
    private FieldTag _content = FieldTag.OBJ;
    private int _length;
    private final List<SFrame> _stack = new ArrayList<SFrame>();
    private int _name;

    public OctetDataReader(InputStream in) {
        this._in = in;
    }

    @Override
    public void beginObject() throws IOException {
        this.consumeValue(FieldTag.OBJ);
        this._stack.add(new SFrame(this._state, this._length, this._content));
        this._state = State.FIELD;
        this._name = -1;
    }

    @Override
    public void endObject() throws IOException {
        this.fetchName();
        assert (this._name == -2) : "There are more fields to read: " + this._name;
        SFrame sFrame = this._stack.remove(this._stack.size() - 1);
        this._state = sFrame.getState();
        this._length = sFrame.getLength();
        this._content = sFrame.getContent();
        this._name = -1;
    }

    @Override
    public boolean hasNext() throws IOException {
        switch (this._state) {
            case FIELD: {
                this.fetchName();
                return this._name >= 0;
            }
            case ARRAY_VALUE: {
                return this._length > 0;
            }
        }
        return false;
    }

    @Override
    public int nextName() throws IOException {
        this.requireState(State.FIELD);
        this.fetchName();
        assert (this._name >= 0) : "No more fields left";
        this._state = State.FIELD_VALUE;
        int result = this._name;
        this._name = -1;
        return result;
    }

    private void fetchName() throws IOException {
        if (this._name == -1) {
            int nameAndTag = this.readVarInt();
            this._content = OctetDataReader.tag(nameAndTag);
            this._name = this._content == FieldTag.STOP ? -2 : OctetDataReader.name(nameAndTag);
        }
    }

    @Override
    public int nextInt() throws IOException {
        this.consumeValue(FieldTag.VAR);
        return this.readVarInt();
    }

    @Override
    public int nextIntSigned() throws IOException {
        this.consumeValue(FieldTag.VAR);
        return BinaryUtil.zigzagDecode(this.readVarInt());
    }

    @Override
    public int nextIntFixed() throws IOException {
        this.consumeValue(FieldTag.F32);
        return this.readFixedInt();
    }

    @Override
    public long nextLong() throws IOException {
        this.consumeValue(FieldTag.VAR);
        return this.readVarLong();
    }

    @Override
    public long nextLongSigned() throws IOException {
        this.consumeValue(FieldTag.VAR);
        return BinaryUtil.zigzagDecode(this.readVarLong());
    }

    @Override
    public long nextLongFixed() throws IOException {
        this.consumeValue(FieldTag.F64);
        return this.readFixedLong();
    }

    @Override
    public float nextFloat() throws IOException {
        this.consumeValue(FieldTag.F32);
        return Float.intBitsToFloat(this.readFixedInt());
    }

    @Override
    public double nextDouble() throws IOException {
        this.consumeValue(FieldTag.F64);
        return Double.longBitsToDouble(this.readFixedLong());
    }

    @Override
    public String nextString() throws IOException {
        this.consumeValue(FieldTag.REPEATED);
        long sizeAndTag = this.readVarLong();
        ContentTag tag = OctetDataReader.tag(sizeAndTag);
        assert (tag == ContentTag.CHAR) : "Received '" + (Object)((Object)tag) + "' but character string was requested.";
        int size = OctetDataReader.size(sizeAndTag);
        return new String(this.readBinary(size), "utf-8");
    }

    @Override
    public byte[] nextBinary() throws IOException {
        switch (this._content) {
            case REPEATED: {
                this.consumeValue(FieldTag.REPEATED);
                long sizeAndTag = this.readVarLong();
                ContentTag tag = OctetDataReader.tag(sizeAndTag);
                assert (tag == ContentTag.F8) : "Received '" + (Object)((Object)tag) + "' but binary string was requested.";
                int size = OctetDataReader.size(sizeAndTag);
                return this.readBinary(size);
            }
            case CHUNKED: {
                this.consumeValue(FieldTag.CHUNKED);
                long sizeAndTag = this.readVarLong();
                ContentTag tag = OctetDataReader.tag(sizeAndTag);
                assert (tag == ContentTag.F8) : "Received '" + (Object)((Object)tag) + "' but binary string was requested.";
                Throwable throwable = null;
                Object var5_8 = null;
                try (ChunkedInputStream in = new ChunkedInputStream();){
                    byte[] result = new byte[]{};
                    while (true) {
                        int available;
                        if ((available = ((InputStream)in).available()) == 0) {
                            return result;
                        }
                        int currentLength = result.length;
                        byte[] next = new byte[currentLength + available];
                        System.arraycopy(result, 0, next, 0, currentLength);
                        ((InputStream)in).read(next, currentLength, available);
                        result = next;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        }
        throw this.unexpectedContent(FieldTag.REPEATED);
    }

    @Override
    public InputStream nextBinaryStream() throws IOException {
        switch (this._content) {
            case REPEATED: {
                this.consumeValue(FieldTag.REPEATED);
                long sizeAndTag = this.readVarLong();
                ContentTag tag = OctetDataReader.tag(sizeAndTag);
                assert (tag == ContentTag.F8) : "Received '" + (Object)((Object)tag) + "' but binary string was requested.";
                int size = OctetDataReader.size(sizeAndTag);
                return new LimitedInputStream(size);
            }
            case CHUNKED: {
                this.consumeValue(FieldTag.CHUNKED);
                long sizeAndTag = this.readVarLong();
                ContentTag tag = OctetDataReader.tag(sizeAndTag);
                assert (tag == ContentTag.F8) : "Received '" + (Object)((Object)tag) + "' but binary string was requested.";
                return new ChunkedInputStream();
            }
        }
        throw this.unexpectedContent(FieldTag.REPEATED);
    }

    @Override
    public int beginArray() throws IOException {
        this.requireState(State.FIELD_VALUE);
        this._state = State.ARRAY_VALUE;
        long sizeAndTag = this.readVarLong();
        this._content = OctetDataReader.tag(sizeAndTag).toFieldTag();
        this._length = OctetDataReader.size(sizeAndTag);
        return this._length;
    }

    @Override
    public void endArray() throws IOException {
        this.requireState(State.ARRAY_VALUE);
        assert (this._length == 0) : "Received array value (" + this._length + " remaining) while end of array was requested.";
        this._state = State.FIELD;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void skipValue() throws IOException {
        tag = this._content;
        switch (OctetDataReader.$SWITCH_TABLE$de$haumacher$msgbuf$binary$FieldTag()[tag.ordinal()]) {
            case 1: {
                this.nextLong();
                break;
            }
            case 3: {
                this.nextIntFixed();
                break;
            }
            case 4: {
                this.nextLongFixed();
                break;
            }
            case 2: {
                this.consumeValue(tag);
                this._in.read();
                break;
            }
            case 5: {
                this.beginObject();
                while (this.hasNext()) {
                    this.nextName();
                    this.skipValue();
                }
                this.endObject();
                break;
            }
            case 7: {
                this.beginArray();
                if (this._content != FieldTag.REPEATED) ** GOTO lbl45
                while (this.hasNext()) {
                    sizeAndTag = this.readVarLong();
                    content = OctetDataReader.tag(sizeAndTag);
                    innerLength = OctetDataReader.size(sizeAndTag);
                    if (!OctetDataReader.$assertionsDisabled && content != ContentTag.F8 && content != ContentTag.CHAR) {
                        throw new AssertionError((Object)("Invalid nested array: " + (Object)content));
                    }
                    this._in.skip(innerLength);
                    --this._length;
                }
                ** GOTO lbl46
lbl-1000:
                // 1 sources

                {
                    this.skipValue();
lbl45:
                    // 2 sources

                    ** while (this.hasNext())
                }
lbl46:
                // 2 sources

                this.endArray();
                break;
            }
            case 8: {
                this.requireState(State.FIELD_VALUE);
                sizeAndTag = this.readVarLong();
                this._content = OctetDataReader.tag(sizeAndTag).toFieldTag();
                while ((chunkSize = this.readVarInt()) != 0) {
                    this._in.skip(chunkSize);
                }
                this._state = State.FIELD;
                break;
            }
            case 6: {
                if (!OctetDataReader.$assertionsDisabled) {
                    throw new AssertionError((Object)"No value to skip, end of object reached.");
                }
                break;
            }
        }
    }

    private void requireState(State requested) {
        assert (this._state == requested) : "Expecting '" + (Object)((Object)requested) + "' but received '" + (Object)((Object)this._state) + "'.";
    }

    private void consumeValue(FieldTag requested) throws IOException {
        assert (this._content == requested) : "Received '" + (Object)((Object)this._content) + "' while '" + (Object)((Object)requested) + "' was requested.";
        switch (this._state) {
            case START: {
                assert (requested == FieldTag.OBJ) : "Data starts always with an object, '" + (Object)((Object)requested) + "' was requested.";
                this._state = State.FIELD;
                break;
            }
            case FIELD: {
                break;
            }
            case FIELD_VALUE: {
                this._state = State.FIELD;
                break;
            }
            case ARRAY_VALUE: {
                assert (this._length > 0) : "Expecting end of array.";
                --this._length;
                break;
            }
            default: {
                throw this.unexpectedContent(requested);
            }
        }
    }

    private IOException unexpectedContent(FieldTag requested) throws IOException {
        throw new IOException("Cannot read '" + (Object)((Object)requested) + "' in state '" + (Object)((Object)this._state) + "'.");
    }

    final int readVarInt() throws IOException {
        int result = 0;
        int shift = 0;
        while (true) {
            int data;
            if ((data = this._in.read()) < 0) {
                throw new IOException("End of stream received, while reading var int.");
            }
            result |= (data & 0x7F) << shift;
            if ((data & 0x80) == 0) {
                return result;
            }
            shift += 7;
        }
    }

    private long readVarLong() throws IOException {
        long result = 0L;
        int shift = 0;
        while (true) {
            int data;
            if ((data = this._in.read()) < 0) {
                throw new IOException("End of stream received, while reading var int.");
            }
            result |= (long)((data & 0x7F) << shift);
            if ((data & 0x80) == 0) {
                return result;
            }
            shift += 7;
        }
    }

    private int readFixedInt() throws IOException {
        int result = 0;
        int n = 0;
        while (n < 4) {
            int data = this._in.read();
            if (data < 0) {
                throw new IOException("End of stream received, while reading fixed int.");
            }
            result <<= 8;
            result |= data;
            ++n;
        }
        return result;
    }

    private long readFixedLong() throws IOException {
        long result = 0L;
        int n = 0;
        while (n < 8) {
            int data = this._in.read();
            if (data < 0) {
                throw new IOException("End of stream received, while reading fixed int.");
            }
            result <<= 8;
            result |= (long)data;
            ++n;
        }
        return result;
    }

    private byte[] readBinary(int size) throws IOException {
        byte[] result = new byte[size];
        int offset = 0;
        while (offset < size) {
            int direct = this._in.read(result, offset, size - offset);
            if (direct < 0) {
                throw new IOException("Received end of stream while receiving a binary string of size '" + size + "'.");
            }
            offset += direct;
        }
        return result;
    }

    private static int name(int nameAndTag) {
        return nameAndTag >>> 3;
    }

    private static FieldTag tag(int nameAndTag) {
        return FieldTag.values()[nameAndTag & 7];
    }

    private static int size(long sizeAndTag) {
        return (int)(sizeAndTag >>> 3);
    }

    private static ContentTag tag(long sizeAndTag) {
        return ContentTag.values()[(int)sizeAndTag & 7];
    }

    private class ChunkedInputStream
    extends InputStream {
        private final State _before;
        int _chunkSize;
        int _pos;

        public ChunkedInputStream() throws IOException {
            this._before = OctetDataReader.this._state;
            OctetDataReader.this._state = State.CHUNKED_VALUE;
            this.fetchChunkSize();
        }

        @Override
        public int read() throws IOException {
            this.ensureData();
            if (this._chunkSize == 0) {
                return -1;
            }
            ++this._pos;
            return OctetDataReader.this._in.read();
        }

        @Override
        public int read(byte[] buffer, int off, int len) throws IOException {
            int available = this.available();
            if (this._chunkSize == 0) {
                return -1;
            }
            int direct = Math.min(available, len);
            OctetDataReader.this._in.read(buffer, off, direct);
            this._pos += direct;
            return direct;
        }

        @Override
        public int available() throws IOException {
            this.ensureData();
            return this._chunkSize - this._pos;
        }

        @Override
        public void close() throws IOException {
            while (this._chunkSize > 0) {
                int available = this.available();
                this._pos += available;
                OctetDataReader.this._in.skip(available);
            }
            OctetDataReader.this._state = this._before;
        }

        private void ensureData() throws IOException {
            if (this._pos == this._chunkSize && this._chunkSize > 0) {
                this.fetchChunkSize();
            }
        }

        private void fetchChunkSize() throws IOException {
            this._chunkSize = OctetDataReader.this.readVarInt();
            this._pos = 0;
        }
    }

    private class LimitedInputStream
    extends InputStream {
        private int _available;

        public LimitedInputStream(int size) {
            this._available = size;
        }

        @Override
        public int read() throws IOException {
            if (this._available == 0) {
                return -1;
            }
            --this._available;
            return OctetDataReader.this._in.read();
        }

        @Override
        public int read(byte[] buffer, int off, int len) throws IOException {
            if (this._available == 0) {
                return -1;
            }
            int direct = Math.min(this._available, len);
            this._available -= direct;
            OctetDataReader.this._in.read(buffer, off, direct);
            return direct;
        }

        @Override
        public int available() throws IOException {
            return this._available;
        }

        @Override
        public void close() throws IOException {
            if (this._available > 0) {
                OctetDataReader.this._in.skip(this._available);
            }
        }
    }

    private static final class SFrame {
        private final State _state;
        private final int _length;
        private FieldTag _content;

        public SFrame(State state, int length, FieldTag expected) {
            this._state = state;
            this._length = length;
            this._content = expected;
        }

        public State getState() {
            return this._state;
        }

        public int getLength() {
            return this._length;
        }

        public FieldTag getContent() {
            return this._content;
        }
    }
}

