/*
 * Decompiled with CFR 0.152.
 */
package de.haumacher.msgbuf.graph;

import de.haumacher.msgbuf.graph.AbstractSharedGraphNode;
import de.haumacher.msgbuf.graph.ScopeMixin;
import de.haumacher.msgbuf.graph.SharedGraphNode;
import de.haumacher.msgbuf.graph.cmd.Command;
import de.haumacher.msgbuf.graph.cmd.InsertElement;
import de.haumacher.msgbuf.graph.cmd.ListUpdate;
import de.haumacher.msgbuf.graph.cmd.RemoveElement;
import de.haumacher.msgbuf.graph.cmd.SetProperty;
import de.haumacher.msgbuf.json.JsonReader;
import de.haumacher.msgbuf.json.JsonWriter;
import de.haumacher.msgbuf.observer.Listener;
import de.haumacher.msgbuf.observer.Observable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class DefaultScope
implements Listener,
ScopeMixin {
    private static final Function<? super SharedGraphNode, ? extends Map<String, Command>> NEW_MAP = x -> new LinkedHashMap();
    private Map<SharedGraphNode, Map<String, Command>> _changes = new LinkedHashMap<SharedGraphNode, Map<String, Command>>();
    private Map<Object, SharedGraphNode> _index = new HashMap<Object, SharedGraphNode>();
    private final ChangeExtractor _extractor = new ChangeExtractor();
    private final ChangeApplicator _applicator = new ChangeApplicator();
    private int _nextId;
    private int _totalParticipants;
    private boolean _applying;

    public DefaultScope(int totalParticipants, int participantId) {
        this._totalParticipants = totalParticipants;
        this._nextId = 1 + participantId;
    }

    public static DefaultScope newServerInstance() {
        return new DefaultScope(2, 0);
    }

    public static DefaultScope newClientInstance() {
        return new DefaultScope(2, 1);
    }

    @Override
    public void beforeSet(Observable obj, String property, Object value) {
        if (this._applying) {
            return;
        }
        AbstractSharedGraphNode node = (AbstractSharedGraphNode)obj;
        this.changes(node).put(property, SetProperty.create().setNode(node).setId(node.id()).setProperty(property));
    }

    @Override
    public void beforeAdd(Observable obj, String property, int index, Object element) {
        if (this._applying) {
            return;
        }
        AbstractSharedGraphNode node = (AbstractSharedGraphNode)obj;
        Map<String, Command> changes = this.changes(node);
        InsertElement insert = InsertElement.create();
        insert.setElement(element).setIndex(index).setNode(node).setId(node.id()).setProperty(property);
        DefaultScope.putUpdate(changes, property, insert);
    }

    @Override
    public void afterRemove(Observable obj, String property, int index, Object element) {
        if (this._applying) {
            return;
        }
        AbstractSharedGraphNode node = (AbstractSharedGraphNode)obj;
        Map<String, Command> changes = this.changes(node);
        RemoveElement remove = RemoveElement.create();
        remove.setIndex(index).setNode(node).setId(node.id()).setProperty(property);
        DefaultScope.putUpdate(changes, property, remove);
    }

    private static void putUpdate(Map<String, Command> changes, String property, ListUpdate update) {
        Command clash = changes.put(property, update);
        if (clash != null) {
            if (clash instanceof SetProperty) {
                changes.put(property, clash);
            } else {
                changes.put(property, DefaultScope.append((ListUpdate)clash, update));
            }
        }
    }

    private static Command append(ListUpdate clash, ListUpdate update) {
        ListUpdate next;
        ListUpdate current = clash;
        int cnt = 1;
        while ((next = current.getNext()) != null) {
            if (++cnt > 10) {
                return SetProperty.create().setNode(update.getNode()).setProperty(update.getProperty());
            }
            current = next;
        }
        current.setNext(update);
        return clash;
    }

    public void createPatch(JsonWriter json) throws IOException {
        json.beginArray();
        json.beginArray();
        this.foreachCommand(command -> command.writeTo(json));
        json.endArray();
        json.beginArray();
        this.foreachCommand(command -> {
            Void void_ = command.visit(this._extractor, json);
        });
        json.endArray();
        json.endArray();
        this._changes.clear();
    }

    public void applyChanges(JsonReader json) throws IOException {
        boolean before = this._applying;
        this._applying = true;
        try {
            ArrayList<Command> commands = new ArrayList<Command>();
            json.beginArray();
            json.beginArray();
            while (json.hasNext()) {
                commands.add(Command.readCommand(json));
            }
            json.endArray();
            json.beginArray();
            for (Command command : commands) {
                command.visit(this._applicator, json);
            }
            json.endArray();
            json.endArray();
        }
        finally {
            this._applying = before;
        }
    }

    @Override
    public void enter(SharedGraphNode node, int id) {
        ScopeMixin.super.enter(node, id);
        node.registerListener(this);
    }

    @Override
    public void readData(SharedGraphNode node, int id, JsonReader in) throws IOException {
        boolean before = this._applying;
        this._applying = true;
        try {
            ScopeMixin.super.readData(node, id, in);
        }
        finally {
            this._applying = before;
        }
    }

    private void foreachCommand(Transmission fun) throws IOException {
        for (Map<String, Command> perObject : this._changes.values()) {
            Iterator<Command> iterator = perObject.values().iterator();
            while (iterator.hasNext()) {
                Command first;
                Command command = first = iterator.next();
                fun.process(command);
                if (!(command instanceof ListUpdate)) continue;
                ListUpdate next = ((ListUpdate)command).getNext();
                while (next != null) {
                    fun.process(next);
                    next = next.getNext();
                }
            }
        }
    }

    private Map<String, Command> changes(SharedGraphNode obj) {
        return this._changes.computeIfAbsent(obj, NEW_MAP);
    }

    @Override
    public int id(SharedGraphNode node) {
        return ((AbstractSharedGraphNode)node).id();
    }

    @Override
    public void initId(SharedGraphNode node, int id) {
        ((AbstractSharedGraphNode)node).initId(id);
    }

    @Override
    public int newId() {
        int result = this._nextId;
        this._nextId += this._totalParticipants;
        return result;
    }

    @Override
    public Map<Object, SharedGraphNode> index() {
        return this._index;
    }

    final class ChangeApplicator
    implements Command.Visitor<Void, JsonReader, IOException> {
        ChangeApplicator() {
        }

        @Override
        public Void visit(SetProperty self, JsonReader arg) throws IOException {
            SharedGraphNode target = this.resolveTarget(self);
            target.readField(DefaultScope.this, arg, self.getProperty());
            return null;
        }

        @Override
        public Void visit(InsertElement self, JsonReader arg) throws IOException {
            SharedGraphNode target = this.resolveTarget(self);
            Object element = target.readElement(DefaultScope.this, arg, self.getProperty());
            List<Object> value = this.listValue(self, target);
            value.add(self.getIndex(), element);
            return null;
        }

        @Override
        public Void visit(RemoveElement self, JsonReader arg) throws IOException {
            SharedGraphNode target = this.resolveTarget(self);
            List<Object> value = this.listValue(self, target);
            value.remove(self.getIndex());
            return null;
        }

        private SharedGraphNode resolveTarget(Command self) {
            return DefaultScope.this.resolveOrFail(self.getId());
        }

        private List<Object> listValue(ListUpdate self, SharedGraphNode node) {
            List value = (List)node.get(self.getProperty());
            return value;
        }
    }

    final class ChangeExtractor
    implements Command.Visitor<Void, JsonWriter, IOException> {
        ChangeExtractor() {
        }

        @Override
        public Void visit(SetProperty self, JsonWriter arg) throws IOException {
            String property = self.getProperty();
            SharedGraphNode node = self.getNode();
            node.writeFieldValue(DefaultScope.this, arg, property);
            return null;
        }

        @Override
        public Void visit(InsertElement self, JsonWriter arg) throws IOException {
            self.getNode().writeElement(DefaultScope.this, arg, self.getProperty(), self.getElement());
            return null;
        }

        @Override
        public Void visit(RemoveElement self, JsonWriter arg) throws IOException {
            return null;
        }
    }

    static interface Transmission {
        public void process(Command var1) throws IOException;
    }
}

