/*
 * Decompiled with CFR 0.152.
 */
package de.haumacher.msgbuf.graph.cmd;

import de.haumacher.msgbuf.binary.BinaryDataObject;
import de.haumacher.msgbuf.binary.DataReader;
import de.haumacher.msgbuf.binary.DataWriter;
import de.haumacher.msgbuf.data.AbstractDataObject;
import de.haumacher.msgbuf.graph.SharedGraphNode;
import de.haumacher.msgbuf.graph.cmd.InsertElement;
import de.haumacher.msgbuf.graph.cmd.ListUpdate;
import de.haumacher.msgbuf.graph.cmd.RemoveElement;
import de.haumacher.msgbuf.graph.cmd.SetProperty;
import de.haumacher.msgbuf.json.JsonReader;
import de.haumacher.msgbuf.json.JsonUtil;
import de.haumacher.msgbuf.json.JsonWriter;
import de.haumacher.msgbuf.observer.Listener;
import de.haumacher.msgbuf.observer.Observable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public abstract class Command
extends AbstractDataObject
implements BinaryDataObject,
Observable {
    public static final String ID = "id";
    public static final String PROPERTY = "p";
    public static final String NODE = "node";
    public static final int ID__ID = 1;
    public static final int PROPERTY__ID = 2;
    private int _id = 0;
    private String _property = "";
    private transient SharedGraphNode _node = null;
    protected Listener _listener = Listener.NONE;
    private static List<String> PROPERTIES = Collections.unmodifiableList(Arrays.asList("id", "p", "node"));

    protected Command() {
    }

    public abstract TypeKind kind();

    public final int getId() {
        return this._id;
    }

    public final Command setId(int value) {
        this._listener.beforeSet(this, ID, value);
        this._id = value;
        return this;
    }

    public final String getProperty() {
        return this._property;
    }

    public final Command setProperty(String value) {
        this._listener.beforeSet(this, PROPERTY, value);
        this._property = value;
        return this;
    }

    public final SharedGraphNode getNode() {
        return this._node;
    }

    public final Command setNode(SharedGraphNode value) {
        this._listener.beforeSet(this, NODE, value);
        this._node = value;
        return this;
    }

    public final boolean hasNode() {
        return this._node != null;
    }

    @Override
    public Command registerListener(Listener l) {
        this._listener = Listener.register(this._listener, l);
        return this;
    }

    @Override
    public Command unregisterListener(Listener l) {
        this._listener = Listener.unregister(this._listener, l);
        return this;
    }

    @Override
    public List<String> properties() {
        return PROPERTIES;
    }

    @Override
    public Object get(String field) {
        switch (field) {
            case "id": {
                return this.getId();
            }
            case "p": {
                return this.getProperty();
            }
            case "node": {
                return this.getNode();
            }
        }
        return Observable.super.get(field);
    }

    @Override
    public void set(String field, Object value) {
        switch (field) {
            case "id": {
                this.setId((Integer)value);
                break;
            }
            case "p": {
                this.setProperty((String)value);
                break;
            }
            case "node": {
                this.setNode((SharedGraphNode)value);
            }
        }
    }

    public static Command readCommand(JsonReader in) throws IOException {
        Command result;
        String type;
        in.beginArray();
        switch (type = in.nextString()) {
            case "S": {
                result = SetProperty.readSetProperty(in);
                break;
            }
            case "I": {
                result = InsertElement.readInsertElement(in);
                break;
            }
            case "R": {
                result = RemoveElement.readRemoveElement(in);
                break;
            }
            default: {
                in.skipValue();
                result = null;
            }
        }
        in.endArray();
        return result;
    }

    @Override
    public final void writeTo(JsonWriter out) throws IOException {
        out.beginArray();
        out.value(this.jsonType());
        this.writeContent(out);
        out.endArray();
    }

    @Override
    protected void writeFields(JsonWriter out) throws IOException {
        super.writeFields(out);
        out.name(ID);
        out.value(this.getId());
        out.name(PROPERTY);
        out.value(this.getProperty());
    }

    @Override
    protected void readField(JsonReader in, String field) throws IOException {
        switch (field) {
            case "id": {
                this.setId(in.nextInt());
                break;
            }
            case "p": {
                this.setProperty(JsonUtil.nextStringOptional(in));
                break;
            }
            default: {
                super.readField(in, field);
            }
        }
    }

    public abstract int typeId();

    @Override
    public final void writeTo(DataWriter out) throws IOException {
        out.beginObject();
        out.name(0);
        out.value(this.typeId());
        this.writeFields(out);
        out.endObject();
    }

    protected void writeFields(DataWriter out) throws IOException {
        out.name(1);
        out.value(this.getId());
        out.name(2);
        out.value(this.getProperty());
    }

    /*
     * Unable to fully structure code
     */
    public static Command readCommand(DataReader in) throws IOException {
        in.beginObject();
        typeField = in.nextName();
        if (!Command.$assertionsDisabled && typeField != 0) {
            throw new AssertionError();
        }
        type = in.nextInt();
        switch (type) {
            case 1: {
                result = SetProperty.create();
                ** GOTO lbl25
            }
            case 2: {
                result = InsertElement.create();
                ** GOTO lbl25
            }
            case 3: {
                result = RemoveElement.create();
                if (true) ** GOTO lbl25
            }
            default: {
                while (in.hasNext()) {
                    in.skipValue();
                }
                in.endObject();
                return null;
            }
        }
        do {
            field = in.nextName();
            result.readField(in, field);
lbl25:
            // 4 sources

        } while (in.hasNext());
        in.endObject();
        return result;
    }

    protected void readField(DataReader in, int field) throws IOException {
        switch (field) {
            case 1: {
                this.setId(in.nextInt());
                break;
            }
            case 2: {
                this.setProperty(in.nextString());
                break;
            }
            default: {
                in.skipValue();
            }
        }
    }

    public abstract <R, A, E extends Throwable> R visit(Visitor<R, A, E> var1, A var2) throws E;

    public static enum TypeKind {
        SET_PROPERTY,
        INSERT_ELEMENT,
        REMOVE_ELEMENT;

    }

    public static interface Visitor<R, A, E extends Throwable>
    extends ListUpdate.Visitor<R, A, E> {
        public R visit(SetProperty var1, A var2) throws E;
    }
}

