/*
 * Decompiled with CFR 0.152.
 */
package de.haumacher.msgbuf.graph.cmd;

import de.haumacher.msgbuf.binary.DataReader;
import de.haumacher.msgbuf.binary.DataWriter;
import de.haumacher.msgbuf.graph.cmd.Command;
import de.haumacher.msgbuf.graph.cmd.InsertElement;
import de.haumacher.msgbuf.graph.cmd.RemoveElement;
import de.haumacher.msgbuf.json.JsonReader;
import de.haumacher.msgbuf.json.JsonWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public abstract class ListUpdate
extends Command {
    public static final String INDEX = "i";
    public static final String NEXT = "next";
    public static final int INDEX__ID = 4;
    private int _index = 0;
    private transient ListUpdate _next = null;
    private static List<String> PROPERTIES = Collections.unmodifiableList(Arrays.asList("i", "next"));

    protected ListUpdate() {
    }

    public final int getIndex() {
        return this._index;
    }

    public final ListUpdate setIndex(int value) {
        this._listener.beforeSet(this, INDEX, value);
        this._index = value;
        return this;
    }

    public final ListUpdate getNext() {
        return this._next;
    }

    public final ListUpdate setNext(ListUpdate value) {
        this._listener.beforeSet(this, NEXT, value);
        this._next = value;
        return this;
    }

    public final boolean hasNext() {
        return this._next != null;
    }

    @Override
    public List<String> properties() {
        return PROPERTIES;
    }

    @Override
    public Object get(String field) {
        switch (field) {
            case "i": {
                return this.getIndex();
            }
            case "next": {
                return this.getNext();
            }
        }
        return super.get(field);
    }

    @Override
    public void set(String field, Object value) {
        switch (field) {
            case "i": {
                this.setIndex((Integer)value);
                break;
            }
            case "next": {
                this.setNext((ListUpdate)value);
                break;
            }
            default: {
                super.set(field, value);
            }
        }
    }

    public static ListUpdate readListUpdate(JsonReader in) throws IOException {
        ListUpdate result;
        String type;
        in.beginArray();
        switch (type = in.nextString()) {
            case "I": {
                result = InsertElement.readInsertElement(in);
                break;
            }
            case "R": {
                result = RemoveElement.readRemoveElement(in);
                break;
            }
            default: {
                in.skipValue();
                result = null;
            }
        }
        in.endArray();
        return result;
    }

    @Override
    protected void writeFields(JsonWriter out) throws IOException {
        super.writeFields(out);
        out.name(INDEX);
        out.value(this.getIndex());
    }

    @Override
    protected void readField(JsonReader in, String field) throws IOException {
        switch (field) {
            case "i": {
                this.setIndex(in.nextInt());
                break;
            }
            default: {
                super.readField(in, field);
            }
        }
    }

    @Override
    protected void writeFields(DataWriter out) throws IOException {
        super.writeFields(out);
        out.name(4);
        out.value(this.getIndex());
    }

    public static ListUpdate readListUpdate(DataReader in) throws IOException {
        ListUpdate result;
        in.beginObject();
        int typeField = in.nextName();
        assert (typeField == 0);
        int type = in.nextInt();
        switch (type) {
            case 2: {
                result = InsertElement.create();
                break;
            }
            case 3: {
                result = RemoveElement.create();
                break;
            }
            default: {
                while (in.hasNext()) {
                    in.skipValue();
                }
                in.endObject();
                return null;
            }
        }
        while (in.hasNext()) {
            int field = in.nextName();
            result.readField(in, field);
        }
        in.endObject();
        return result;
    }

    @Override
    protected void readField(DataReader in, int field) throws IOException {
        switch (field) {
            case 4: {
                this.setIndex(in.nextInt());
                break;
            }
            default: {
                super.readField(in, field);
            }
        }
    }

    public abstract <R, A, E extends Throwable> R visit(Visitor<R, A, E> var1, A var2) throws E;

    @Override
    public final <R, A, E extends Throwable> R visit(Command.Visitor<R, A, E> v, A arg) throws E {
        return this.visit((Visitor<R, A, E>)v, arg);
    }

    public static interface Visitor<R, A, E extends Throwable> {
        public R visit(InsertElement var1, A var2) throws E;

        public R visit(RemoveElement var1, A var2) throws E;
    }
}

