/*
 * Decompiled with CFR 0.152.
 */
package de.haumacher.msgbuf.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class ReferenceMap<K, V>
extends HashMap<K, V> {
    @Override
    public V put(K key, V value) {
        V oldValue = this.remove(key);
        this.beforeAdd(key, value);
        super.put(key, value);
        this.afterChanged();
        return oldValue;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> collection) {
        this.beforeAddAll(collection);
        super.putAll(collection);
        this.afterChanged();
    }

    private void beforeAddAll(Map<? extends K, ? extends V> collection) {
        for (Map.Entry<K, V> value : collection.entrySet()) {
            this.beforeAdd(value.getKey(), value.getValue());
        }
    }

    protected abstract void beforeAdd(K var1, V var2);

    @Override
    public V remove(Object key) {
        V removed = this.internalRemove(key);
        if (removed != null) {
            this.afterChanged();
        }
        return removed;
    }

    private V internalRemove(Object key) {
        Object removed = super.remove(key);
        if (removed != null) {
            Object removedKey = key;
            this.afterRemove(removedKey, removed);
        }
        return removed;
    }

    @Override
    public boolean remove(Object key, Object value) {
        boolean success = super.remove(key, value);
        if (success) {
            Object removedKey = key;
            Object removed = value;
            this.afterRemove(removedKey, removed);
            this.afterChanged();
        }
        return success;
    }

    @Override
    public void clear() {
        Set keys = this.keySet();
        if (keys.isEmpty()) {
            return;
        }
        for (Object key : new ArrayList(keys)) {
            this.internalRemove(key);
        }
        this.afterChanged();
    }

    protected abstract void afterRemove(K var1, V var2);

    protected void afterChanged() {
    }
}

