/*
 * Decompiled with CFR 0.152.
 */
package de.haumacher.msgbuf.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public abstract class ReferenceList<T>
extends ArrayList<T> {
    @Override
    public void add(int index, T element) {
        this.beforeAdd(index, element);
        super.add(index, element);
    }

    @Override
    public boolean add(T element) {
        this.beforeAdd(this.size(), element);
        return super.add(element);
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        this.beforeAddAll(collection);
        return super.addAll(collection);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> collection) {
        this.beforeAddAll(collection);
        return super.addAll(index, collection);
    }

    private void beforeAddAll(Collection<? extends T> collection) {
        int index = this.size();
        for (T element : collection) {
            this.beforeAdd(index++, element);
        }
    }

    protected abstract void beforeAdd(int var1, T var2);

    @Override
    public T remove(int index) {
        Object removed = super.remove(index);
        this.afterRemove(index, removed);
        return (T)removed;
    }

    @Override
    public boolean remove(Object element) {
        boolean success;
        int index = super.indexOf(element);
        boolean bl = success = index >= 0;
        if (success) {
            Object removed = super.remove(index);
            this.afterRemove(index, removed);
        }
        return success;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.doRemoveAll(c, true);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.doRemoveAll(c, false);
    }

    @Override
    public void clear() {
        for (int index = this.size() - 1; index >= 0; --index) {
            this.remove(index);
        }
    }

    private boolean doRemoveAll(Collection<?> c, boolean removePresent) {
        boolean changed = false;
        HashSet test = c instanceof Set || c.size() < 10 ? c : new HashSet(c);
        for (int index = this.size() - 1; index >= 0; --index) {
            Object element = this.get(index);
            if (test.contains(element) != removePresent) continue;
            this.remove(index);
            changed = true;
        }
        return changed;
    }

    protected abstract void afterRemove(int var1, T var2);
}

