/*
 * Decompiled with CFR 0.152.
 */
package de.haumacher.msgbuf.graph;

import de.haumacher.msgbuf.graph.DummyScope;
import de.haumacher.msgbuf.graph.Scope;
import de.haumacher.msgbuf.graph.SharedGraphNode;
import de.haumacher.msgbuf.io.StringW;
import de.haumacher.msgbuf.json.JsonReader;
import de.haumacher.msgbuf.json.JsonWriter;
import de.haumacher.msgbuf.observer.Listener;
import java.io.IOException;

public abstract class AbstractSharedGraphNode
implements SharedGraphNode {
    private int _id;
    protected Listener _listener = Listener.NONE;

    public final int id() {
        return this._id;
    }

    protected void initId(int id) {
        assert (this._id == 0) : "ID already assigned.";
        if (id <= 0) {
            throw new IllegalArgumentException("Invalid ID: " + id);
        }
        this._id = id;
    }

    @Override
    public SharedGraphNode registerListener(Listener l) {
        this._listener = Listener.register(this._listener, l);
        return this;
    }

    @Override
    public SharedGraphNode unregisterListener(Listener l) {
        this._listener = Listener.unregister(this._listener, l);
        return this;
    }

    @Override
    public final void writeTo(Scope scope, JsonWriter out) throws IOException {
        scope.writeRefOrData(out, this);
    }

    @Override
    public final void writeData(Scope scope, JsonWriter out, int id) throws IOException {
        out.beginArray();
        out.value(this.jsonType());
        out.value(id);
        out.beginObject();
        this.writeFields(scope, out);
        out.endObject();
        out.endArray();
    }

    protected void writeFields(Scope scope, JsonWriter out) throws IOException {
    }

    @Override
    public final void readFields(Scope scope, JsonReader in) throws IOException {
        while (in.hasNext()) {
            String field = in.nextName();
            this.readField(scope, in, field);
        }
    }

    @Override
    public void readField(Scope scope, JsonReader in, String field) throws IOException {
        in.skipValue();
    }

    @Override
    public void writeElement(Scope scope, JsonWriter out, String field, Object element) throws IOException {
        out.nullValue();
    }

    @Override
    public Object readElement(Scope scope, JsonReader in, String field) throws IOException {
        in.skipValue();
        return null;
    }

    @Override
    public void writeFieldValue(Scope scope, JsonWriter out, String field) throws IOException {
        out.nullValue();
    }

    public String toString() {
        StringW out = new StringW();
        try {
            this.writeTo(new DummyScope(), new JsonWriter(out));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return out.toString();
    }
}

