/*
 * Decompiled with CFR 0.152.
 */
package de.haumacher.msgbuf.graph;

import de.haumacher.msgbuf.graph.Scope;
import de.haumacher.msgbuf.graph.SharedGraphNode;
import de.haumacher.msgbuf.json.JsonReader;
import de.haumacher.msgbuf.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

public interface ScopeMixin
extends Scope {
    @Override
    default public SharedGraphNode resolveOrFail(int id) {
        SharedGraphNode result = this.index().get(id);
        if (result == null) {
            throw new IllegalArgumentException("No object with ID '" + id + "'.");
        }
        return result;
    }

    default public void enter(SharedGraphNode node, int id) {
        this.initId(node, id);
        SharedGraphNode clash = this.index().put(id, node);
        if (!1.$assertionsDisabled && clash != null) {
            throw new AssertionError((Object)("Clash of ID " + id + ": " + String.valueOf(clash) + " vs. " + String.valueOf(node)));
        }
    }

    @Override
    default public void readData(SharedGraphNode node, int id, JsonReader in) throws IOException {
        this.enter(node, id);
        in.beginObject();
        node.readFields(this, in);
        in.endObject();
    }

    @Override
    default public void writeRefOrData(JsonWriter out, SharedGraphNode node) throws IOException {
        int id = this.id(node);
        if (id == 0) {
            id = this.newId();
            this.enter(node, id);
            node.writeData(this, out, id);
        } else {
            out.value(id);
        }
    }

    public int id(SharedGraphNode var1);

    public void initId(SharedGraphNode var1, int var2);

    public int newId();

    public Map<Object, SharedGraphNode> index();

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

