/*
 * Decompiled with CFR 0.152.
 */
package de.haumacher.msgbuf.observer;

import de.haumacher.msgbuf.observer.Observable;
import java.util.ArrayList;

public interface Listener {
    public static final Listener NONE = new Listener(){

        @Override
        public void beforeSet(Observable obj, String property, Object value) {
        }
    };

    public void beforeSet(Observable var1, String var2, Object var3);

    default public void beforeAdd(Observable obj, String property, int index, Object element) {
    }

    default public void beforeAdd(Observable obj, String property, Object index, Object element) {
    }

    default public void afterRemove(Observable obj, String property, int index, Object element) {
    }

    default public void afterRemove(Observable obj, String property, Object index, Object element) {
    }

    public static Listener register(Listener current, Listener added) {
        if (current == NONE || current == added) {
            return added;
        }
        if (current instanceof MultiplexListener) {
            return ((MultiplexListener)current).register(added);
        }
        return new MultiplexListener(current, added);
    }

    public static Listener unregister(Listener current, Listener removed) {
        if (current == removed) {
            return NONE;
        }
        if (current instanceof MultiplexListener) {
            return ((MultiplexListener)current).unregister(removed);
        }
        return current;
    }

    public static final class MultiplexListener
    extends ArrayList<Listener>
    implements Listener {
        public MultiplexListener(Listener a, Listener b) {
            super(2);
            this.add(a);
            this.add(b);
        }

        @Override
        public void beforeSet(Observable obj, String property, Object value) {
            for (Listener l : this.current()) {
                l.beforeSet(obj, property, value);
            }
        }

        @Override
        public void beforeAdd(Observable obj, String property, int index, Object element) {
            for (Listener l : this.current()) {
                l.beforeAdd(obj, property, index, element);
            }
        }

        @Override
        public void afterRemove(Observable obj, String property, int index, Object element) {
            for (Listener l : this.current()) {
                l.afterRemove(obj, property, index, element);
            }
        }

        private Listener[] current() {
            return this.toArray(new Listener[0]);
        }

        public Listener register(Listener l) {
            if (!this.contains(l)) {
                this.add(l);
            }
            return this;
        }

        public Listener unregister(Listener removed) {
            this.remove(removed);
            if (this.isEmpty()) {
                return NONE;
            }
            return this;
        }
    }
}

