/*
 * Decompiled with CFR 0.152.
 */
package de.haumacher.msgbuf.generator;

import de.haumacher.msgbuf.generator.FileGenerator;
import java.io.IOError;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;

public abstract class AbstractFileGenerator
implements FileGenerator {
    private static final String NL;
    private static final String INDENT = "\t";
    private Appendable _out;
    private int _indent = 0;

    static {
        StringWriter out = new StringWriter();
        Throwable throwable = null;
        Object var2_3 = null;
        try (PrintWriter p = new PrintWriter(out);){
            p.println();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        NL = out.toString();
    }

    @Override
    public void generate(Appendable out) {
        this._out = out;
        try {
            this.generate();
        }
        finally {
            this._out = null;
        }
    }

    protected void generateInner(AbstractFileGenerator outer) {
        this.setIndent(outer.getIndent());
        this.generate(outer._out);
    }

    public int getIndent() {
        return this._indent;
    }

    private void setIndent(int indent) {
        this._indent = indent;
    }

    protected abstract void generate();

    protected void docComment(String comment) {
        if (!comment.isEmpty()) {
            this.line("/**");
            String[] stringArray = comment.split("\n");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                this.line(" *" + (line.isEmpty() ? "" : " " + line));
                ++n2;
            }
            this.line(" */");
        }
    }

    protected void line(String line) {
        this.lineStart(line);
        this.nl();
    }

    protected void lineStart(String line) {
        int closing = this.countClose(line);
        int delta = this.countDelta(line);
        this._indent += closing;
        int n = 0;
        while (n < this._indent) {
            this.internalAppend(INDENT);
            ++n;
        }
        this._indent += delta - closing;
        this.internalAppend(line);
    }

    protected void append(String part) {
        this.internalAppend(part);
        this._indent += this.countDelta(part);
    }

    private void internalAppend(String part) {
        try {
            this._out.append(part);
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    private int countDelta(String line) {
        int result = 0;
        int n = 0;
        int cnt = line.length();
        while (n < cnt) {
            switch (line.charAt(n)) {
                case '(': 
                case '[': 
                case '{': {
                    ++result;
                    break;
                }
                case ')': 
                case ']': 
                case '}': {
                    --result;
                }
            }
            ++n;
        }
        return result;
    }

    private int countClose(String line) {
        int result = 0;
        int n = 0;
        int cnt = line.length();
        while (n < cnt) {
            switch (line.charAt(n)) {
                case ')': 
                case ']': 
                case '}': {
                    --result;
                    break;
                }
                case '(': 
                case '[': 
                case '{': {
                    return result;
                }
            }
            ++n;
        }
        return result;
    }

    protected void nl() {
        this.internalAppend(NL);
    }
}

