/*
 * Decompiled with CFR 0.152.
 */
package de.haumacher.msgbuf.generator;

import java.util.regex.Pattern;

public class CodeUtil {
    private static final String QUOTE = "\"";
    private static final Pattern NAME_PART_PATTERN = Pattern.compile("(?<=\\p{javaLowerCase})(?=\\p{javaUpperCase})|(?<=\\p{javaLetter})(?=\\p{javaDigit})|(?<=\\p{javaDigit})(?=\\p{javaLetter})|_+");

    public static String camelCase(String name) {
        StringBuilder result = new StringBuilder();
        String[] stringArray = name.split("_+");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            result.append(CodeUtil.firstUpperCase(part));
            ++n2;
        }
        return result.toString();
    }

    public static String firstUpperCase(String name) {
        return String.valueOf(Character.toUpperCase(name.charAt(0))) + name.substring(1);
    }

    public static String allUpperCase(String name) {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        String[] stringArray = NAME_PART_PATTERN.split(name);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            if (first) {
                first = false;
            } else {
                result.append('_');
            }
            result.append(part.toUpperCase());
            ++n2;
        }
        return result.toString();
    }

    public static String firstLowerCase(String name) {
        return String.valueOf(Character.toLowerCase(name.charAt(0))) + name.substring(1);
    }

    public static String stringLiteral(String str) {
        return QUOTE + str.replace("\\", "\\\\").replace(QUOTE, "\\\"") + QUOTE;
    }
}

