/*
 * Decompiled with CFR 0.152.
 */
package de.haumacher.msgbuf.generator;

import de.haumacher.msgbuf.generator.CodeConvention;
import de.haumacher.msgbuf.generator.Util;
import de.haumacher.msgbuf.generator.ast.Constant;
import de.haumacher.msgbuf.generator.ast.Definition;
import de.haumacher.msgbuf.generator.ast.DefinitionFile;
import de.haumacher.msgbuf.generator.ast.EnumDef;
import de.haumacher.msgbuf.generator.ast.Field;
import de.haumacher.msgbuf.generator.ast.MessageDef;
import de.haumacher.msgbuf.generator.ast.QName;
import java.util.HashMap;
import java.util.Map;

public class NameTable
implements Definition.Visitor<Void, Void> {
    private final Map<String, Package> _packageByName = new HashMap<String, Package>();
    private final Map<String, Definition> _definitionByName = new HashMap<String, Definition>();

    public void enter(DefinitionFile file) {
        Package pkg = this.mkPackage(file.getPackage());
        for (Definition def : file.getDefinitions()) {
            pkg.enter(file, def);
            def.visit(this, null);
        }
    }

    @Override
    public Void visit(EnumDef self, Void arg) {
        this.enterDef(self);
        for (Constant part : self.getConstants()) {
            part.setOwner(self);
        }
        return null;
    }

    @Override
    public Void visit(MessageDef self, Void arg) {
        this.enterDef(self);
        for (Field part : self.getFields()) {
            part.setOwner(self);
        }
        for (Definition inner : self.getDefinitions()) {
            inner.setOuter(self);
            inner.visit(this, arg);
        }
        return null;
    }

    private void enterDef(Definition def) {
        this._definitionByName.put(def.getName(), def);
    }

    private Package mkPackage(QName qName) {
        String name = qName == null ? "" : CodeConvention.packageName(qName);
        Package result = this._packageByName.get(name);
        if (result == null) {
            result = new Package(name);
            this._packageByName.put(name, result);
        }
        return result;
    }

    public void error(String message) {
        System.err.println(message);
    }

    public Definition lookup(MessageDef context, QName name) {
        return this._definitionByName.get(Util.last(name));
    }

    class Package {
        private final String _name;
        private final Map<String, Definition> _definitionsByName = new HashMap<String, Definition>();

        public Package(String name) {
            this._name = name;
        }

        public String getName() {
            return this._name;
        }

        public void enter(DefinitionFile file, Definition def) {
            def.setFile(file);
            Definition clash = this._definitionsByName.put(def.getName(), def);
            if (clash != null) {
                NameTable.this.error("Duplicate definition '" + def.getName() + "' in package '" + this.getName() + "'.");
            }
        }
    }
}

