/*
 * Decompiled with CFR 0.152.
 */
package de.haumacher.msgbuf.generator.ast;

import de.haumacher.msgbuf.generator.ast.Constant;
import de.haumacher.msgbuf.generator.ast.Definition;
import de.haumacher.msgbuf.generator.ast.EnumDef;
import de.haumacher.msgbuf.generator.ast.Field;
import de.haumacher.msgbuf.generator.ast.MessageDef;
import de.haumacher.msgbuf.generator.ast.Option;
import de.haumacher.msgbuf.generator.ast.Part;
import de.haumacher.msgbuf.generator.ast.WithOptions;
import de.haumacher.msgbuf.json.JsonReader;
import de.haumacher.msgbuf.json.JsonUtil;
import de.haumacher.msgbuf.json.JsonWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public abstract class DefinitionBase
extends WithOptions {
    public static final String COMMENT = "comment";
    private String _comment = "";
    private static List<String> PROPERTIES = Collections.unmodifiableList(Arrays.asList("comment"));

    protected DefinitionBase() {
    }

    public final String getComment() {
        return this._comment;
    }

    public DefinitionBase setComment(String value) {
        this.internalSetComment(value);
        return this;
    }

    protected final void internalSetComment(String value) {
        this._listener.beforeSet(this, COMMENT, value);
        this._comment = value;
    }

    @Override
    public DefinitionBase setOptions(Map<String, Option> value) {
        this.internalSetOptions(value);
        return this;
    }

    @Override
    public DefinitionBase putOption(String key, Option value) {
        this.internalPutOption(key, value);
        return this;
    }

    @Override
    public List<String> properties() {
        return PROPERTIES;
    }

    @Override
    public Object get(String field) {
        switch (field) {
            case "comment": {
                return this.getComment();
            }
        }
        return super.get(field);
    }

    @Override
    public void set(String field, Object value) {
        switch (field) {
            case "comment": {
                this.setComment((String)value);
                break;
            }
            default: {
                super.set(field, value);
            }
        }
    }

    public static DefinitionBase readDefinitionBase(JsonReader in) throws IOException {
        DefinitionBase result;
        String type;
        in.beginArray();
        switch (type = in.nextString()) {
            case "Constant": {
                result = Constant.readConstant(in);
                break;
            }
            case "Field": {
                result = Field.readField(in);
                break;
            }
            case "EnumDef": {
                result = EnumDef.readEnumDef(in);
                break;
            }
            case "MessageDef": {
                result = MessageDef.readMessageDef(in);
                break;
            }
            default: {
                in.skipValue();
                result = null;
            }
        }
        in.endArray();
        return result;
    }

    @Override
    protected void writeFields(JsonWriter out) throws IOException {
        super.writeFields(out);
        out.name(COMMENT);
        out.value(this.getComment());
    }

    @Override
    protected void readField(JsonReader in, String field) throws IOException {
        switch (field) {
            case "comment": {
                this.setComment(JsonUtil.nextStringOptional(in));
                break;
            }
            default: {
                super.readField(in, field);
            }
        }
    }

    public abstract <R, A> R visit(Visitor<R, A> var1, A var2);

    @Override
    public final <R, A> R visit(WithOptions.Visitor<R, A> v, A arg) {
        return this.visit((Visitor<R, A>)v, arg);
    }

    public static interface Visitor<R, A>
    extends Part.Visitor<R, A>,
    Definition.Visitor<R, A> {
    }
}

