/*
 * Decompiled with CFR 0.152.
 */
package de.haumacher.msgbuf.json;

import de.haumacher.msgbuf.json.Base64Utils;
import de.haumacher.msgbuf.json.JsonReader;
import de.haumacher.msgbuf.json.JsonToken;
import de.haumacher.msgbuf.json.JsonWriter;
import java.io.IOException;

public class JsonUtil {
    public static String nextStringOptional(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        return in.nextString();
    }

    public static byte[] nextBinaryOptional(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        return Base64Utils.fromBase64(in.nextString());
    }

    public static void writeBinaryOptional(JsonWriter out, byte[] value) throws IOException {
        if (value == null) {
            out.nullValue();
        } else {
            out.value(Base64Utils.toBase64(value));
        }
    }
}

