/*
 * Decompiled with CFR 0.152.
 */
package de.haumacher.msgbuf.generator.ast;

import de.haumacher.msgbuf.generator.ast.DefinitionBase;
import de.haumacher.msgbuf.generator.ast.DefinitionFile;
import de.haumacher.msgbuf.generator.ast.EnumDef;
import de.haumacher.msgbuf.generator.ast.MessageDef;
import de.haumacher.msgbuf.generator.ast.Option;
import de.haumacher.msgbuf.json.JsonReader;
import de.haumacher.msgbuf.json.JsonUtil;
import de.haumacher.msgbuf.json.JsonWriter;
import de.haumacher.msgbuf.observer.Observable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public abstract class Definition
extends DefinitionBase {
    public static final String NAME = "name";
    public static final String FILE = "file";
    public static final String OUTER = "outer";
    private String _name = "";
    private transient DefinitionFile _file = null;
    private transient MessageDef _outer = null;
    private static List<String> PROPERTIES = Collections.unmodifiableList(Arrays.asList("name", "file", "outer"));

    protected Definition() {
    }

    public final String getName() {
        return this._name;
    }

    public Definition setName(String value) {
        this.internalSetName(value);
        return this;
    }

    protected final void internalSetName(String value) {
        this._listener.beforeSet((Observable)this, NAME, (Object)value);
        this._name = value;
    }

    public final DefinitionFile getFile() {
        return this._file;
    }

    public Definition setFile(DefinitionFile value) {
        this.internalSetFile(value);
        return this;
    }

    protected final void internalSetFile(DefinitionFile value) {
        this._listener.beforeSet((Observable)this, FILE, (Object)value);
        this._file = value;
    }

    public final boolean hasFile() {
        return this._file != null;
    }

    public final MessageDef getOuter() {
        return this._outer;
    }

    public Definition setOuter(MessageDef value) {
        this.internalSetOuter(value);
        return this;
    }

    protected final void internalSetOuter(MessageDef value) {
        this._listener.beforeSet((Observable)this, OUTER, (Object)value);
        this._outer = value;
    }

    public final boolean hasOuter() {
        return this._outer != null;
    }

    @Override
    public Definition setComment(String value) {
        this.internalSetComment(value);
        return this;
    }

    @Override
    public Definition setOptions(Map<String, Option> value) {
        this.internalSetOptions(value);
        return this;
    }

    @Override
    public Definition putOption(String key, Option value) {
        this.internalPutOption(key, value);
        return this;
    }

    @Override
    public List<String> properties() {
        return PROPERTIES;
    }

    @Override
    public Object get(String field) {
        switch (field) {
            case "name": {
                return this.getName();
            }
            case "file": {
                return this.getFile();
            }
            case "outer": {
                return this.getOuter();
            }
        }
        return super.get(field);
    }

    @Override
    public void set(String field, Object value) {
        switch (field) {
            case "name": {
                this.setName((String)value);
                break;
            }
            case "file": {
                this.setFile((DefinitionFile)((Object)value));
                break;
            }
            case "outer": {
                this.setOuter((MessageDef)((Object)value));
                break;
            }
            default: {
                super.set(field, value);
            }
        }
    }

    public static Definition readDefinition(JsonReader in) throws IOException {
        Definition result;
        String type;
        in.beginArray();
        switch (type = in.nextString()) {
            case "EnumDef": {
                result = EnumDef.readEnumDef(in);
                break;
            }
            case "MessageDef": {
                result = MessageDef.readMessageDef(in);
                break;
            }
            default: {
                in.skipValue();
                result = null;
            }
        }
        in.endArray();
        return result;
    }

    @Override
    protected void writeFields(JsonWriter out) throws IOException {
        super.writeFields(out);
        out.name(NAME);
        out.value(this.getName());
    }

    @Override
    protected void readField(JsonReader in, String field) throws IOException {
        switch (field) {
            case "name": {
                this.setName(JsonUtil.nextStringOptional((JsonReader)in));
                break;
            }
            default: {
                super.readField(in, field);
            }
        }
    }

    public abstract <R, A> R visit(Visitor<R, A> var1, A var2);

    @Override
    public final <R, A> R visit(DefinitionBase.Visitor<R, A> v, A arg) {
        return this.visit((Visitor<R, A>)v, arg);
    }

    public static interface Visitor<R, A> {
        public R visit(EnumDef var1, A var2);

        public R visit(MessageDef var1, A var2);
    }
}

