/*
 * Decompiled with CFR 0.152.
 */
package de.haumacher.msgbuf.generator.ast;

import de.haumacher.msgbuf.generator.FieldOperations;
import de.haumacher.msgbuf.generator.ast.Definition;
import de.haumacher.msgbuf.generator.ast.Option;
import de.haumacher.msgbuf.generator.ast.Part;
import de.haumacher.msgbuf.generator.ast.Type;
import de.haumacher.msgbuf.generator.ast.WithOptions;
import de.haumacher.msgbuf.json.JsonReader;
import de.haumacher.msgbuf.json.JsonWriter;
import de.haumacher.msgbuf.observer.Observable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class Field
extends Part
implements FieldOperations {
    public static final String FIELD__TYPE = "Field";
    public static final String TRANSIENT = "transient";
    public static final String REPEATED = "repeated";
    public static final String TYPE = "type";
    private boolean _transient = false;
    private boolean _repeated = false;
    private Type _type = null;
    private static List<String> PROPERTIES = Collections.unmodifiableList(Arrays.asList("transient", "repeated", "type"));

    public static Field create() {
        return new Field();
    }

    protected Field() {
    }

    @Override
    public WithOptions.TypeKind kind() {
        return WithOptions.TypeKind.FIELD;
    }

    public final boolean isTransient() {
        return this._transient;
    }

    public Field setTransient(boolean value) {
        this.internalSetTransient(value);
        return this;
    }

    protected final void internalSetTransient(boolean value) {
        this._listener.beforeSet((Observable)this, TRANSIENT, (Object)value);
        this._transient = value;
    }

    public final boolean isRepeated() {
        return this._repeated;
    }

    public Field setRepeated(boolean value) {
        this.internalSetRepeated(value);
        return this;
    }

    protected final void internalSetRepeated(boolean value) {
        this._listener.beforeSet((Observable)this, REPEATED, (Object)value);
        this._repeated = value;
    }

    public final Type getType() {
        return this._type;
    }

    public Field setType(Type value) {
        this.internalSetType(value);
        return this;
    }

    protected final void internalSetType(Type value) {
        this._listener.beforeSet((Observable)this, TYPE, (Object)value);
        this._type = value;
    }

    public final boolean hasType() {
        return this._type != null;
    }

    @Override
    public Field setName(String value) {
        this.internalSetName(value);
        return this;
    }

    @Override
    public Field setIndex(int value) {
        this.internalSetIndex(value);
        return this;
    }

    @Override
    public Field setOwner(Definition value) {
        this.internalSetOwner(value);
        return this;
    }

    @Override
    public Field setComment(String value) {
        this.internalSetComment(value);
        return this;
    }

    @Override
    public Field setOptions(Map<String, Option> value) {
        this.internalSetOptions(value);
        return this;
    }

    @Override
    public Field putOption(String key, Option value) {
        this.internalPutOption(key, value);
        return this;
    }

    public String jsonType() {
        return FIELD__TYPE;
    }

    @Override
    public List<String> properties() {
        return PROPERTIES;
    }

    @Override
    public Object get(String field) {
        switch (field) {
            case "transient": {
                return this.isTransient();
            }
            case "repeated": {
                return this.isRepeated();
            }
            case "type": {
                return this.getType();
            }
        }
        return super.get(field);
    }

    @Override
    public void set(String field, Object value) {
        switch (field) {
            case "transient": {
                this.setTransient((Boolean)value);
                break;
            }
            case "repeated": {
                this.setRepeated((Boolean)value);
                break;
            }
            case "type": {
                this.setType((Type)((Object)value));
                break;
            }
            default: {
                super.set(field, value);
            }
        }
    }

    public static Field readField(JsonReader in) throws IOException {
        Field result = new Field();
        in.beginObject();
        result.readFields(in);
        in.endObject();
        return result;
    }

    @Override
    protected void writeFields(JsonWriter out) throws IOException {
        super.writeFields(out);
        out.name(TRANSIENT);
        out.value(this.isTransient());
        out.name(REPEATED);
        out.value(this.isRepeated());
        if (this.hasType()) {
            out.name(TYPE);
            this.getType().writeTo(out);
        }
    }

    @Override
    protected void readField(JsonReader in, String field) throws IOException {
        switch (field) {
            case "transient": {
                this.setTransient(in.nextBoolean());
                break;
            }
            case "repeated": {
                this.setRepeated(in.nextBoolean());
                break;
            }
            case "type": {
                this.setType(Type.readType(in));
                break;
            }
            default: {
                super.readField(in, field);
            }
        }
    }

    @Override
    public <R, A> R visit(Part.Visitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }
}

