/*
 * Decompiled with CFR 0.152.
 */
package de.haumacher.msgbuf.generator.ast;

import de.haumacher.msgbuf.data.AbstractDataObject;
import de.haumacher.msgbuf.generator.ast.Flag;
import de.haumacher.msgbuf.generator.ast.NumberOption;
import de.haumacher.msgbuf.generator.ast.StringOption;
import de.haumacher.msgbuf.json.JsonReader;
import de.haumacher.msgbuf.json.JsonWriter;
import de.haumacher.msgbuf.observer.Listener;
import de.haumacher.msgbuf.observer.Observable;
import java.io.IOException;

public abstract class Option
extends AbstractDataObject
implements Observable {
    protected Listener _listener = Listener.NONE;

    protected Option() {
    }

    public abstract TypeKind kind();

    public Option registerListener(Listener l) {
        this.internalRegisterListener(l);
        return this;
    }

    protected final void internalRegisterListener(Listener l) {
        this._listener = Listener.register((Listener)this._listener, (Listener)l);
    }

    public Option unregisterListener(Listener l) {
        this.internalUnregisterListener(l);
        return this;
    }

    protected final void internalUnregisterListener(Listener l) {
        this._listener = Listener.unregister((Listener)this._listener, (Listener)l);
    }

    public static Option readOption(JsonReader in) throws IOException {
        Option result;
        String type;
        in.beginArray();
        switch (type = in.nextString()) {
            case "StringOption": {
                result = StringOption.readStringOption(in);
                break;
            }
            case "NumberOption": {
                result = NumberOption.readNumberOption(in);
                break;
            }
            case "Flag": {
                result = Flag.readFlag(in);
                break;
            }
            default: {
                in.skipValue();
                result = null;
            }
        }
        in.endArray();
        return result;
    }

    public final void writeTo(JsonWriter out) throws IOException {
        out.beginArray();
        out.value(this.jsonType());
        this.writeContent(out);
        out.endArray();
    }

    public abstract <R, A> R visit(Visitor<R, A> var1, A var2);

    public static enum TypeKind {
        STRING_OPTION,
        NUMBER_OPTION,
        FLAG;

    }

    public static interface Visitor<R, A> {
        public R visit(StringOption var1, A var2);

        public R visit(NumberOption var1, A var2);

        public R visit(Flag var1, A var2);
    }
}

