/*
 * Decompiled with CFR 0.152.
 */
package de.haumacher.msgbuf.generator.ast;

import de.haumacher.msgbuf.data.AbstractDataObject;
import de.haumacher.msgbuf.generator.ast.CustomType;
import de.haumacher.msgbuf.generator.ast.MapType;
import de.haumacher.msgbuf.generator.ast.PrimitiveType;
import de.haumacher.msgbuf.json.JsonReader;
import de.haumacher.msgbuf.json.JsonWriter;
import de.haumacher.msgbuf.observer.Listener;
import de.haumacher.msgbuf.observer.Observable;
import java.io.IOException;

public abstract class Type
extends AbstractDataObject
implements Observable {
    protected Listener _listener = Listener.NONE;

    protected Type() {
    }

    public abstract TypeKind kind();

    public Type registerListener(Listener l) {
        this.internalRegisterListener(l);
        return this;
    }

    protected final void internalRegisterListener(Listener l) {
        this._listener = Listener.register((Listener)this._listener, (Listener)l);
    }

    public Type unregisterListener(Listener l) {
        this.internalUnregisterListener(l);
        return this;
    }

    protected final void internalUnregisterListener(Listener l) {
        this._listener = Listener.unregister((Listener)this._listener, (Listener)l);
    }

    public static Type readType(JsonReader in) throws IOException {
        Type result;
        String type;
        in.beginArray();
        switch (type = in.nextString()) {
            case "CustomType": {
                result = CustomType.readCustomType(in);
                break;
            }
            case "PrimitiveType": {
                result = PrimitiveType.readPrimitiveType(in);
                break;
            }
            case "MapType": {
                result = MapType.readMapType(in);
                break;
            }
            default: {
                in.skipValue();
                result = null;
            }
        }
        in.endArray();
        return result;
    }

    public final void writeTo(JsonWriter out) throws IOException {
        out.beginArray();
        out.value(this.jsonType());
        this.writeContent(out);
        out.endArray();
    }

    public abstract <R, A> R visit(Visitor<R, A> var1, A var2);

    public static enum TypeKind {
        CUSTOM_TYPE,
        PRIMITIVE_TYPE,
        MAP_TYPE;

    }

    public static interface Visitor<R, A> {
        public R visit(CustomType var1, A var2);

        public R visit(PrimitiveType var1, A var2);

        public R visit(MapType var1, A var2);
    }
}

