/*
 * Decompiled with CFR 0.152.
 */
package de.haumacher.msgbuf.generator.ast;

import de.haumacher.msgbuf.data.AbstractDataObject;
import de.haumacher.msgbuf.generator.ast.Constant;
import de.haumacher.msgbuf.generator.ast.DefinitionBase;
import de.haumacher.msgbuf.generator.ast.DefinitionFile;
import de.haumacher.msgbuf.generator.ast.EnumDef;
import de.haumacher.msgbuf.generator.ast.Field;
import de.haumacher.msgbuf.generator.ast.MessageDef;
import de.haumacher.msgbuf.generator.ast.Option;
import de.haumacher.msgbuf.generator.ast.OptionContainer;
import de.haumacher.msgbuf.json.JsonReader;
import de.haumacher.msgbuf.json.JsonWriter;
import de.haumacher.msgbuf.observer.Listener;
import de.haumacher.msgbuf.observer.Observable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class WithOptions
extends AbstractDataObject
implements Observable {
    public static final String OPTIONS = "options";
    private final Map<String, Option> _options = new HashMap<String, Option>();
    protected Listener _listener = Listener.NONE;
    private static List<String> PROPERTIES = Collections.unmodifiableList(Arrays.asList("options"));

    protected WithOptions() {
    }

    public abstract TypeKind kind();

    public final Map<String, Option> getOptions() {
        return this._options;
    }

    public WithOptions setOptions(Map<String, Option> value) {
        this.internalSetOptions(value);
        return this;
    }

    protected final void internalSetOptions(Map<String, Option> value) {
        if (value == null) {
            throw new IllegalArgumentException("Property 'options' cannot be null.");
        }
        this._options.clear();
        this._options.putAll(value);
    }

    public WithOptions putOption(String key, Option value) {
        this.internalPutOption(key, value);
        return this;
    }

    protected final void internalPutOption(String key, Option value) {
        if (this._options.containsKey(key)) {
            throw new IllegalArgumentException("Property 'options' already contains a value for key '" + key + "'.");
        }
        this._options.put(key, value);
    }

    public final void removeOption(String key) {
        this._options.remove(key);
    }

    public WithOptions registerListener(Listener l) {
        this.internalRegisterListener(l);
        return this;
    }

    protected final void internalRegisterListener(Listener l) {
        this._listener = Listener.register((Listener)this._listener, (Listener)l);
    }

    public WithOptions unregisterListener(Listener l) {
        this.internalUnregisterListener(l);
        return this;
    }

    protected final void internalUnregisterListener(Listener l) {
        this._listener = Listener.unregister((Listener)this._listener, (Listener)l);
    }

    public List<String> properties() {
        return PROPERTIES;
    }

    public Object get(String field) {
        switch (field) {
            case "options": {
                return this.getOptions();
            }
        }
        return super.get(field);
    }

    public void set(String field, Object value) {
        switch (field) {
            case "options": {
                this.setOptions((Map)value);
            }
        }
    }

    public static WithOptions readWithOptions(JsonReader in) throws IOException {
        WithOptions result;
        String type;
        in.beginArray();
        switch (type = in.nextString()) {
            case "OptionContainer": {
                result = OptionContainer.readOptionContainer(in);
                break;
            }
            case "DefinitionFile": {
                result = DefinitionFile.readDefinitionFile(in);
                break;
            }
            case "Constant": {
                result = Constant.readConstant(in);
                break;
            }
            case "Field": {
                result = Field.readField(in);
                break;
            }
            case "EnumDef": {
                result = EnumDef.readEnumDef(in);
                break;
            }
            case "MessageDef": {
                result = MessageDef.readMessageDef(in);
                break;
            }
            default: {
                in.skipValue();
                result = null;
            }
        }
        in.endArray();
        return result;
    }

    public final void writeTo(JsonWriter out) throws IOException {
        out.beginArray();
        out.value(this.jsonType());
        this.writeContent(out);
        out.endArray();
    }

    protected void writeFields(JsonWriter out) throws IOException {
        super.writeFields(out);
        out.name(OPTIONS);
        out.beginObject();
        for (Map.Entry<String, Option> entry : this.getOptions().entrySet()) {
            out.name(entry.getKey());
            entry.getValue().writeTo(out);
        }
        out.endObject();
    }

    protected void readField(JsonReader in, String field) throws IOException {
        switch (field) {
            case "options": {
                in.beginObject();
                while (in.hasNext()) {
                    this.putOption(in.nextName(), Option.readOption(in));
                }
                in.endObject();
                break;
            }
            default: {
                super.readField(in, field);
            }
        }
    }

    public abstract <R, A> R visit(Visitor<R, A> var1, A var2);

    public static enum TypeKind {
        OPTION_CONTAINER,
        CONSTANT,
        FIELD,
        ENUM_DEF,
        MESSAGE_DEF,
        DEFINITION_FILE;

    }

    public static interface Visitor<R, A>
    extends DefinitionBase.Visitor<R, A> {
        public R visit(OptionContainer var1, A var2);

        public R visit(DefinitionFile var1, A var2);
    }
}

