/*
 * Decompiled with CFR 0.152.
 */
package de.haumacher.msgbuf.generator.ast;

import de.haumacher.msgbuf.generator.ast.Constant;
import de.haumacher.msgbuf.generator.ast.Definition;
import de.haumacher.msgbuf.generator.ast.DefinitionBase;
import de.haumacher.msgbuf.generator.ast.Field;
import de.haumacher.msgbuf.generator.ast.Option;
import de.haumacher.msgbuf.json.JsonReader;
import de.haumacher.msgbuf.json.JsonUtil;
import de.haumacher.msgbuf.json.JsonWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public abstract class Part
extends DefinitionBase {
    public static final String NAME = "name";
    public static final String INDEX = "index";
    public static final String OWNER = "owner";
    private String _name = "";
    private int _index = 0;
    private transient Definition _owner = null;
    private static List<String> PROPERTIES = Collections.unmodifiableList(Arrays.asList("name", "index", "owner"));

    protected Part() {
    }

    public final String getName() {
        return this._name;
    }

    public Part setName(String value) {
        this.internalSetName(value);
        return this;
    }

    protected final void internalSetName(String value) {
        this._listener.beforeSet(this, NAME, value);
        this._name = value;
    }

    public final int getIndex() {
        return this._index;
    }

    public Part setIndex(int value) {
        this.internalSetIndex(value);
        return this;
    }

    protected final void internalSetIndex(int value) {
        this._listener.beforeSet(this, INDEX, value);
        this._index = value;
    }

    public final Definition getOwner() {
        return this._owner;
    }

    public Part setOwner(Definition value) {
        this.internalSetOwner(value);
        return this;
    }

    protected final void internalSetOwner(Definition value) {
        this._listener.beforeSet(this, OWNER, value);
        this._owner = value;
    }

    public final boolean hasOwner() {
        return this._owner != null;
    }

    @Override
    public Part setComment(String value) {
        this.internalSetComment(value);
        return this;
    }

    @Override
    public Part setOptions(Map<String, Option> value) {
        this.internalSetOptions(value);
        return this;
    }

    @Override
    public Part putOption(String key, Option value) {
        this.internalPutOption(key, value);
        return this;
    }

    @Override
    public List<String> properties() {
        return PROPERTIES;
    }

    @Override
    public Object get(String field) {
        switch (field) {
            case "name": {
                return this.getName();
            }
            case "index": {
                return this.getIndex();
            }
            case "owner": {
                return this.getOwner();
            }
        }
        return super.get(field);
    }

    @Override
    public void set(String field, Object value) {
        switch (field) {
            case "name": {
                this.internalSetName((String)value);
                break;
            }
            case "index": {
                this.internalSetIndex((Integer)value);
                break;
            }
            case "owner": {
                this.internalSetOwner((Definition)value);
                break;
            }
            default: {
                super.set(field, value);
            }
        }
    }

    public static Part readPart(JsonReader in) throws IOException {
        Part result;
        String type;
        in.beginArray();
        switch (type = in.nextString()) {
            case "Constant": {
                result = Constant.readConstant(in);
                break;
            }
            case "Field": {
                result = Field.readField(in);
                break;
            }
            default: {
                in.skipValue();
                result = null;
            }
        }
        in.endArray();
        return result;
    }

    @Override
    protected void writeFields(JsonWriter out) throws IOException {
        super.writeFields(out);
        out.name(NAME);
        out.value(this.getName());
        out.name(INDEX);
        out.value(this.getIndex());
    }

    @Override
    protected void readField(JsonReader in, String field) throws IOException {
        switch (field) {
            case "name": {
                this.setName(JsonUtil.nextStringOptional(in));
                break;
            }
            case "index": {
                this.setIndex(in.nextInt());
                break;
            }
            default: {
                super.readField(in, field);
            }
        }
    }

    public abstract <R, A> R visit(Visitor<R, A> var1, A var2);

    @Override
    public final <R, A> R visit(DefinitionBase.Visitor<R, A> v, A arg) {
        return this.visit((Visitor<R, A>)v, arg);
    }

    public static interface Visitor<R, A> {
        public R visit(Constant var1, A var2);

        public R visit(Field var1, A var2);
    }
}

