/*
 * Decompiled with CFR 0.152.
 */
package de.haumacher.msgbuf.generator.dart;

import de.haumacher.msgbuf.generator.ast.Field;
import de.haumacher.msgbuf.generator.ast.MessageDef;
import de.haumacher.msgbuf.generator.common.Util;
import de.haumacher.msgbuf.generator.dart.DartCoding;
import de.haumacher.msgbuf.generator.dart.ReadOperationBuilder;
import de.haumacher.msgbuf.generator.dart.WriteOperationBuilder;
import de.haumacher.msgbuf.generator.util.AbstractDartGenerator;
import java.util.stream.Collectors;

public class DartClassGenerator
extends AbstractDartGenerator {
    private MessageDef _def;

    public DartClassGenerator(MessageDef def) {
        this._def = def;
    }

    @Override
    protected void generate() {
        String typeName = DartCoding.typeName(this._def);
        if (this._def.isAbstract()) {
            this.line("/// Visitor interface for " + typeName + ".");
            this.line("abstract class " + DartCoding.visitorName(this._def) + "<R, A>" + this.visitorExtends() + " {");
            for (MessageDef specialization : this._def.getSpecializations()) {
                if (specialization.isAbstract()) continue;
                String caseName = DartCoding.typeName(specialization);
                this.line("R visit" + caseName + "(" + caseName + " self, A arg);");
            }
            this.line("}");
            this.nl();
        }
        this.docComment(this._def.getComment());
        this.line(this.abstractModifier() + "class " + typeName + " extends " + this.extendsName() + " {");
        for (Field field : this._def.getFields()) {
            this.docComment(field.getComment());
            this.line(DartCoding.typeName(field) + this.nullableModifier(field) + " " + DartCoding.fieldName(field) + ";");
            this.nl();
        }
        this.line("/// Creates a " + typeName + ".");
        if (this._def.getFields().isEmpty()) {
            this.line(typeName + "();");
        } else {
            this.line(typeName + "({");
            for (Field field : this._def.getFields()) {
                this.line("this." + DartCoding.fieldName(field) + DartCoding.initializer(field) + ", ");
            }
            this.line("});");
        }
        this.nl();
        this.line("/// Parses a " + typeName + " from a string source.");
        this.line("static " + typeName + "? fromString(String source) {");
        this.line("return read(JsonReader.fromString(source));");
        this.line("}");
        this.nl();
        this.line("/// Reads a " + typeName + " instance from the given reader.");
        if (this._def.isAbstract()) {
            this.line("static " + typeName + "? read(JsonReader json) {");
            this.line(typeName + "? result;");
            this.nl();
            this.line("json.expectArray();");
            this.line("if (!json.hasNext()) {");
            this.line("return null;");
            this.line("}");
            this.nl();
            this.line("switch (json.expectString()) {");
            for (MessageDef specialization : Util.concreteTransitiveSpecializations(this._def)) {
                this.line("case " + DartCoding.jsonTypeIdLiteral(specialization) + ": result = " + DartCoding.typeName(specialization) + "(); break;");
            }
            this.line("default: result = null;");
            this.line("}");
            this.nl();
            this.line("if (!json.hasNext() || json.tryNull()) {");
            this.line("return null;");
            this.line("}");
            this.nl();
            this.line("if (result == null) {");
            this.line("json.skipAnyValue();");
            this.line("} else {");
            this.line("result._readContent(json);");
            this.line("}");
            this.line("json.endArray();");
            this.nl();
            this.line("return result;");
            this.line("}");
            this.nl();
        } else {
            this.line("static " + typeName + " read(JsonReader json) {");
            this.line(typeName + " result = " + typeName + "();");
            this.line("result._readContent(json);");
            this.line("return result;");
            this.line("}");
            this.nl();
            this.line("@override");
            this.line("String _jsonType() => " + DartCoding.jsonTypeIdLiteral(this._def) + ";");
            this.nl();
        }
        if (!this._def.getFields().isEmpty()) {
            this.line("@override");
            this.line("void _readProperty(String key, JsonReader json) {");
            this.line("switch (key) {");
            for (Field field : this._def.getFields()) {
                if (field.isTransient()) continue;
                this.line("case " + DartCoding.jsonName(field) + ": {");
                this.include(new ReadOperationBuilder(field));
                this.line("break;");
                this.line("}");
            }
            this.line("default: super._readProperty(key, json);");
            this.line("}");
            this.line("}");
            this.nl();
            this.line("@override");
            this.line("void _writeProperties(JsonSink json) {");
            this.line("super._writeProperties(json);");
            for (Field field : this._def.getFields()) {
                Object var;
                if (field.isTransient()) continue;
                this.nl();
                boolean nullable = Util.isNullable(field);
                String value = DartCoding.fieldName(field);
                if (nullable) {
                    var = "_" + value;
                    this.line("var " + (String)var + " = " + value + ";");
                    this.line("if (" + (String)var + " != null) {");
                } else {
                    var = value;
                }
                this.line("json.addKey(" + DartCoding.jsonName(field) + ");");
                this.include(new WriteOperationBuilder(field.isRepeated(), field.getType(), (String)var));
                if (!nullable) continue;
                this.line("}");
            }
            this.line("}");
            this.nl();
        }
        if (this._def.isAbstract()) {
            this.line("R " + DartCoding.visitMethod(this._def) + "<R, A>(" + DartCoding.visitorName(this._def) + "<R, A> v, A arg);");
            this.nl();
        }
        if (this._def.getExtendedDef() != null) {
            String impl = this._def.isAbstract() ? DartCoding.visitMethod(this._def) + "(v, arg)" : "v." + DartCoding.visitCaseMethod(this._def) + "(this, arg)";
            this.line("@override");
            this.line("R " + DartCoding.visitMethod(this._def.getExtendedDef()) + "<R, A>(" + DartCoding.visitorName(this._def.getExtendedDef()) + "<R, A> v, A arg) => " + impl + ";");
            this.nl();
        }
        this.line("}");
        this.nl();
    }

    private String nullableModifier(Field field) {
        return Util.isNullable(field) ? "?" : "";
    }

    private String abstractModifier() {
        return this._def.isAbstract() ? "abstract " : "";
    }

    private String extendsName() {
        return this._def.getExtendedDef() == null ? "_JsonObject" : DartCoding.typeName(this._def.getExtendedDef());
    }

    private String visitorExtends() {
        String extendsList = this._def.getSpecializations().stream().filter(s -> s.isAbstract()).map(s -> DartCoding.visitorName(s) + "<R, A>").collect(Collectors.joining(", "));
        if (extendsList.isEmpty()) {
            return "";
        }
        return " implements " + extendsList;
    }
}

