/*
 * Decompiled with CFR 0.152.
 */
package de.haumacher.msgbuf.generator;

import de.haumacher.msgbuf.generator.MessageGenerator;
import de.haumacher.msgbuf.generator.ast.Constant;
import de.haumacher.msgbuf.generator.ast.CustomType;
import de.haumacher.msgbuf.generator.ast.Definition;
import de.haumacher.msgbuf.generator.ast.DefinitionFile;
import de.haumacher.msgbuf.generator.ast.Field;
import de.haumacher.msgbuf.generator.ast.MapType;
import de.haumacher.msgbuf.generator.ast.MessageDef;
import de.haumacher.msgbuf.generator.ast.PrimitiveType;
import de.haumacher.msgbuf.generator.ast.QName;
import de.haumacher.msgbuf.generator.ast.Type;
import de.haumacher.msgbuf.generator.common.Util;
import de.haumacher.msgbuf.generator.util.CodeUtil;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class CodeConvention {
    static final String TYPE_KIND_NAME = "TypeKind";
    public static final String ENUM_VALUE_OF_PROTOCOL = "valueOfProtocol";
    public static final String ENUM_PROTOCOL_NAME_FUN = "protocolName";

    public static String qTypeName(CustomType def) {
        Definition definition = def.getDefinition();
        if (definition == null) {
            return CodeConvention.qTypeName(def.getName());
        }
        return CodeConvention.qTypeName(definition);
    }

    public static String qTypeName(Definition def) {
        return CodeConvention.qName(def, CodeConvention::typeName);
    }

    public static String qImplName(Definition def) {
        return CodeConvention.qName(def, CodeConvention::implName);
    }

    public static String qName(Definition def, Function<String, String> localNameConvention) {
        QName pkg;
        DefinitionFile file = def.getFile();
        Object scope = file == null ? CodeConvention.qName(def.getOuter(), localNameConvention) + "." : ((pkg = file.getPackage()).getNames().size() == 0 ? "" : CodeConvention.qName(pkg) + ".");
        return (String)scope + localNameConvention.apply(def.getName());
    }

    public static String qTypeName(QName qName) {
        return CodeConvention.qName(qName, CodeConvention::typeName);
    }

    public static String qImplName(QName qName) {
        return CodeConvention.qName(qName, CodeConvention::implName);
    }

    public static String qName(QName qName, Function<String, String> localNameConvention) {
        StringBuilder result = new StringBuilder();
        List<String> names = qName.getNames();
        int cnt = names.size();
        for (int n = 0; n < cnt; ++n) {
            if (n > 0) {
                result.append('.');
            }
            String part = names.get(n);
            result.append(localNameConvention.apply(part));
        }
        return result.toString();
    }

    public static String typeName(Definition def) {
        return CodeConvention.typeName(def.getName());
    }

    public static String typeName(String name) {
        return CodeUtil.camelCase(name);
    }

    public static String implName(Definition def) {
        return CodeConvention.implName(def.getName());
    }

    public static String implName(String name) {
        return CodeConvention.typeName(name) + "_Impl";
    }

    public static String suffix(Field field) {
        return CodeUtil.camelCase(field.getName());
    }

    public static String binaryConstant(Field field) {
        return CodeUtil.allUpperCase(field.getName()) + "__ID";
    }

    public static String constant(Field field) {
        return CodeUtil.allUpperCase(field.getName()) + "__PROP";
    }

    public static String factoryName(MessageDef def) {
        return "create";
    }

    public static String getterName(Field field) {
        Type type = field.getType();
        if (type instanceof PrimitiveType && ((PrimitiveType)type).getKind() == PrimitiveType.Kind.BOOL && !Util.isNullable(field)) {
            return "is" + CodeConvention.suffix(field);
        }
        return "get" + CodeConvention.suffix(field);
    }

    public static String adderName(Field field) {
        String suffix = CodeConvention.singularSuffix(field);
        if (field.getType() instanceof MapType) {
            return "put" + suffix;
        }
        return "add" + suffix;
    }

    public static String internalAdderName(Field field) {
        String suffix = CodeConvention.singularSuffix(field);
        if (field.getType() instanceof MapType) {
            return "internalPut" + suffix;
        }
        return "internalAdd" + suffix;
    }

    public static String removerName(Field field) {
        String suffix = CodeConvention.singularSuffix(field);
        return "remove" + suffix;
    }

    private static String singularSuffix(Field field) {
        String suffix = CodeConvention.suffix(field);
        if (suffix.endsWith("s")) {
            String singularSuffix = suffix.substring(0, suffix.length() - 1);
            String name = field.getName();
            String singularName = name.substring(0, name.length() - 1);
            MessageDef owner = (MessageDef)field.getOwner();
            if (CodeConvention.getField(owner, singularName) == null) {
                return singularSuffix;
            }
        }
        return suffix;
    }

    public static String hasName(Field field) {
        return "has" + CodeConvention.suffix(field);
    }

    public static String name(Field field) {
        return CodeUtil.firstLowerCase(CodeUtil.camelCase(field.getName()));
    }

    public static String setterName(Field field) {
        return "set" + CodeConvention.suffix(field);
    }

    public static String internalSetterName(Field field) {
        return "internalSet" + CodeConvention.suffix(field);
    }

    public static String readerName(String name) {
        return "read" + name;
    }

    public static String readerNameContent(String name) {
        return "read" + name + "_Content";
    }

    public static String readerName(Definition def) {
        return CodeConvention.readerName(def.getName());
    }

    public static String readerNameContent(Definition def) {
        return CodeConvention.readerNameContent(def.getName());
    }

    public static String packageName(QName packageName) {
        return CodeConvention.qName(packageName);
    }

    public static String qName(QName qName) {
        return qName.getNames().stream().collect(Collectors.joining("."));
    }

    public static String jsonTypeConstant(MessageDef def) {
        return CodeUtil.allUpperCase(def.getName()) + "__TYPE";
    }

    public static String jsonTypeConstantRef(MessageDef def) {
        return CodeConvention.typeName(def) + "." + CodeConvention.jsonTypeConstant(def);
    }

    public static String mkBinaryTypeConstant(MessageDef def) {
        return CodeUtil.allUpperCase(def.getName()) + "__TYPE_ID";
    }

    public static String fieldMemberName(Field field) {
        return "_" + CodeConvention.name(field);
    }

    public static String typeKindConstant(MessageDef caseDef) {
        return CodeUtil.allUpperCase(caseDef.getName());
    }

    public static Field getField(MessageDef def, String name) {
        Field result = MessageGenerator.getLocalField(def, name);
        if (result != null) {
            return result;
        }
        MessageDef extendedDef = def.getExtendedDef();
        if (extendedDef != null) {
            return CodeConvention.getField(extendedDef, name);
        }
        return null;
    }

    public static String classifierName(Constant constant) {
        return CodeUtil.allUpperCase(constant.getName());
    }
}

