/*
 * Decompiled with CFR 0.152.
 */
package de.haumacher.msgbuf.generator;

import de.haumacher.msgbuf.generator.CodeConvention;
import de.haumacher.msgbuf.generator.ast.Constant;
import de.haumacher.msgbuf.generator.ast.DefinitionFile;
import de.haumacher.msgbuf.generator.ast.EnumDef;
import de.haumacher.msgbuf.generator.ast.QName;
import de.haumacher.msgbuf.generator.common.MsgBufJsonProtocol;
import de.haumacher.msgbuf.generator.util.AbstractJavaGenerator;
import de.haumacher.msgbuf.generator.util.CodeUtil;
import java.util.HashSet;
import java.util.List;

public class EnumGenerator
extends AbstractJavaGenerator {
    private EnumDef _def;

    public EnumGenerator(EnumDef def) {
        this._def = def;
    }

    @Override
    protected void generate() {
        QName packageName;
        DefinitionFile file = this._def.getFile();
        if (file != null && (packageName = file.getPackage()) != null) {
            this.line("package " + CodeConvention.packageName(packageName) + ";");
        }
        this.nl();
        this.docComment(this._def.getComment());
        this.line("public enum " + CodeConvention.typeName(this._def) + " implements de.haumacher.msgbuf.data.ProtocolEnum {");
        this.generateConstants();
        this.nl();
        this.line("private final String _protocolName;");
        this.nl();
        this.line("private " + CodeConvention.typeName(this._def) + "(String protocolName) {");
        this.line("_protocolName = protocolName;");
        this.line("}");
        this.nl();
        this.line("/**");
        this.line(" * The protocol name of a {@link " + CodeConvention.typeName(this._def) + "} constant.");
        this.line(" *");
        this.line(" * @see #valueOfProtocol(String)");
        this.line(" */");
        this.line("@Override");
        this.line("public String protocolName() {");
        this.line("return _protocolName;");
        this.line("}");
        this.nl();
        this.line("/** Looks up a {@link " + CodeConvention.typeName(this._def) + "} constant by it's protocol name. */");
        this.line("public static " + CodeConvention.typeName(this._def) + " valueOfProtocol(String protocolName) {");
        List<Constant> constants = this._def.getConstants();
        this.line("if (protocolName == null) { return null; }");
        this.line("switch (protocolName) {");
        for (Constant constant : constants) {
            this.line("case " + CodeUtil.stringLiteral(MsgBufJsonProtocol.classifierId(constant)) + ": return " + CodeConvention.classifierName(constant) + ";");
        }
        this.line("}");
        this.line("return " + this.defaultValue() + ";");
        this.line("}");
        this.nl();
        this.line("/** Writes this instance to the given output. */");
        this.line("public final void writeTo(de.haumacher.msgbuf.json.JsonWriter out) throws java.io.IOException {");
        this.line("out.value(protocolName());");
        this.line("}");
        this.nl();
        this.line("/** Reads a new instance from the given reader. */");
        this.line("public static " + CodeConvention.typeName(this._def) + " " + CodeConvention.readerName(this._def) + "(de.haumacher.msgbuf.json.JsonReader in) throws java.io.IOException {");
        this.line("return valueOfProtocol(in.nextString());");
        this.line("}");
        this.nl();
        this.line("/** Writes this instance to the given binary output. */");
        this.line("public final void writeTo(de.haumacher.msgbuf.binary.DataWriter out) throws java.io.IOException {");
        this.line("switch (this) {");
        for (Constant constant : constants) {
            this.line("case " + CodeConvention.classifierName(constant) + ": out.value(" + constant.getIndex() + "); break;");
        }
        this.line("default: out.value(0);");
        this.line("}");
        this.line("}");
        this.nl();
        this.line("/** Reads a new instance from the given binary reader. */");
        this.line("public static " + CodeConvention.typeName(this._def) + " " + CodeConvention.readerName(this._def) + "(de.haumacher.msgbuf.binary.DataReader in) throws java.io.IOException {");
        this.line("switch (in.nextInt()) {");
        HashSet<Integer> ids = new HashSet<Integer>();
        for (Constant constant : constants) {
            if (!ids.add(constant.getIndex())) continue;
            this.line("case " + constant.getIndex() + ": return " + CodeConvention.classifierName(constant) + ";");
        }
        this.line("default: return " + this.defaultValue() + ";");
        this.line("}");
        this.line("}");
        this.line("}");
    }

    private void generateConstants() {
        for (Constant constant : this._def.getConstants()) {
            this.nl();
            this.docComment(constant.getComment());
            this.line(CodeConvention.classifierName(constant) + "(" + CodeUtil.stringLiteral(MsgBufJsonProtocol.classifierId(constant)) + "),");
        }
        this.nl();
        this.line(";");
    }

    private String defaultValue() {
        List<Constant> constants = this._def.getConstants();
        return constants.size() > 0 ? CodeConvention.classifierName(constants.get(0)) : "null";
    }
}

