/*
 * Decompiled with CFR 0.152.
 */
package de.haumacher.msgbuf.generator;

import de.haumacher.msgbuf.generator.ast.Constant;
import de.haumacher.msgbuf.generator.ast.Definition;
import de.haumacher.msgbuf.generator.ast.DefinitionFile;
import de.haumacher.msgbuf.generator.ast.EnumDef;
import de.haumacher.msgbuf.generator.ast.Field;
import de.haumacher.msgbuf.generator.ast.MessageDef;
import de.haumacher.msgbuf.generator.common.Util;
import java.util.HashMap;
import java.util.Map;

public class FieldIDSynthesizer
implements Definition.Visitor<Map<Integer, String>, Void> {
    public void process(DefinitionFile file) {
        for (Definition def : file.getDefinitions()) {
            def.visit(this, null);
        }
    }

    @Override
    public Map<Integer, String> visit(EnumDef self, Void arg) {
        HashMap<Integer, String> partByIndex = new HashMap<Integer, String>();
        for (Constant constant : self.getConstants()) {
            String clash;
            int index = constant.getIndex();
            if (index <= 0 || (clash = partByIndex.put(index, constant.getName())) == null) continue;
            this.error("Duplicate index '" + index + "' for '" + constant.getName() + "' and '" + clash + "' in type '" + Util.toString(self) + "'.");
        }
        int nextIndex = 1;
        for (Constant constant : self.getConstants()) {
            int index = constant.getIndex();
            if (index != 0) continue;
            while (partByIndex.containsKey(nextIndex)) {
                ++nextIndex;
            }
            partByIndex.put(nextIndex, constant.getName());
            constant.setIndex(nextIndex);
        }
        return partByIndex;
    }

    private void error(String message) {
        System.err.println(message);
    }

    @Override
    public Map<Integer, String> visit(MessageDef self, Void arg) {
        Map<Object, Object> partByIndex = self.getExtendedDef() != null ? self.getExtendedDef().visit(this, arg) : new HashMap();
        for (Field field : self.getFields()) {
            String clash;
            int index = field.getIndex();
            if (index <= 0 || (clash = partByIndex.put(index, field.getName())) == null) continue;
            this.error("Duplicate index '" + index + "' for '" + field.getName() + "' and '" + clash + "' in type '" + Util.toString(self) + "'.");
        }
        int nextIndex = 1;
        for (Field field : self.getFields()) {
            int index = field.getIndex();
            if (index != 0) continue;
            while (partByIndex.containsKey(nextIndex)) {
                ++nextIndex;
            }
            partByIndex.put(nextIndex, field.getName());
            field.setIndex(nextIndex);
        }
        for (Definition inner : self.getDefinitions()) {
            inner.visit(this, arg);
        }
        return partByIndex;
    }
}

