/*
 * Decompiled with CFR 0.152.
 */
package de.haumacher.msgbuf.generator;

import de.haumacher.msgbuf.binary.DataType;
import de.haumacher.msgbuf.generator.AbstractMessageGenerator;
import de.haumacher.msgbuf.generator.CodeConvention;
import de.haumacher.msgbuf.generator.DefaultValueGenerator;
import de.haumacher.msgbuf.generator.EnumGenerator;
import de.haumacher.msgbuf.generator.GeneratorPlugin;
import de.haumacher.msgbuf.generator.NameTable;
import de.haumacher.msgbuf.generator.TypeGenerator;
import de.haumacher.msgbuf.generator.ast.CustomType;
import de.haumacher.msgbuf.generator.ast.Definition;
import de.haumacher.msgbuf.generator.ast.EnumDef;
import de.haumacher.msgbuf.generator.ast.Field;
import de.haumacher.msgbuf.generator.ast.MapType;
import de.haumacher.msgbuf.generator.ast.MessageDef;
import de.haumacher.msgbuf.generator.ast.Option;
import de.haumacher.msgbuf.generator.ast.PrimitiveType;
import de.haumacher.msgbuf.generator.ast.QName;
import de.haumacher.msgbuf.generator.ast.StringOption;
import de.haumacher.msgbuf.generator.ast.Type;
import de.haumacher.msgbuf.generator.ast.WithOptions;
import de.haumacher.msgbuf.generator.common.MsgBufJsonProtocol;
import de.haumacher.msgbuf.generator.common.Util;
import de.haumacher.msgbuf.generator.util.CodeUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class MessageGenerator
extends AbstractMessageGenerator
implements Definition.Visitor<Void, Void> {
    private final NameTable _table;
    private final MessageDef _def;
    private final GeneratorPlugin _plugin;
    private boolean _graph;
    private boolean _json;
    private boolean _binary;
    private boolean _reflection;
    private boolean _visitor;
    private boolean _visitEx;
    private boolean _typeKind;
    private Map<String, Option> _options;
    private boolean _listener;
    private boolean _interface;

    public MessageGenerator(NameTable table, Map<String, Option> options, boolean isInterface, MessageDef def, GeneratorPlugin plugin) {
        super(options);
        this._table = table;
        this._options = options;
        this._interface = isInterface;
        this._def = def;
        this._plugin = plugin;
        this._graph = MessageGenerator.isTrue(options.get("SharedGraph"), false);
        this._json = this._graph || !MessageGenerator.isTrue(options.get("NoJson"), false);
        this._binary = !this._graph && !MessageGenerator.isTrue(options.get("NoBinary"), false);
        this._listener = this._graph || !MessageGenerator.isTrue(options.get("NoListener"), false);
        this._reflection = this._listener || !MessageGenerator.isTrue(options.get("NoReflection"), false);
        this._visitor = !MessageGenerator.isTrue(options.get("NoVisitor"), false);
        this._visitEx = !MessageGenerator.isTrue(options.get("NoVisitorExceptions"), false);
        this._typeKind = !MessageGenerator.isTrue(options.get("NoTypeKind"), false);
    }

    public boolean isJson() {
        return this._json;
    }

    public void setJson(boolean json) {
        this._json = json;
    }

    public boolean isBinary() {
        return this._binary;
    }

    public void setBinary(boolean binary) {
        this._binary = binary;
    }

    public boolean isReflection() {
        return this._reflection;
    }

    public void setReflection(boolean reflection) {
        this._reflection = reflection;
    }

    @Override
    protected void generate() {
        String modifier;
        if (this._def.getFile() != null) {
            QName packageName = this._def.getFile().getPackage();
            if (packageName != null) {
                this.line("package " + CodeConvention.packageName(packageName) + ";");
                this.nl();
            }
            modifier = "";
        } else {
            modifier = this._interface ? "" : "static";
        }
        this.docComment(this._def.getComment());
        this.line(this._interface || this._noInterfaces ? "public" : "", modifier, this.mkAbstract(), this._interface ? "interface" : "class", this._interface || this._noInterfaces ? CodeConvention.typeName(this._def) : this.implName(this._def), this.getExtends(), this.getImplements(), "{");
        this.generateClassContents();
        this.nl();
        this.line("}");
    }

    private String mkAbstract() {
        return !this._interface && this._def.isAbstract() ? "abstract" : "";
    }

    private String getExtends() {
        ArrayList<String> generalizations = new ArrayList<String>();
        if (this.isBaseClass()) {
            if (this._graph) {
                generalizations.add(this._interface ? "de.haumacher.msgbuf.graph.SharedGraphNode" : "de.haumacher.msgbuf.graph.AbstractSharedGraphNode");
            } else if (this._json) {
                generalizations.add(this._interface ? "de.haumacher.msgbuf.data.DataObject" : "de.haumacher.msgbuf.data.AbstractDataObject");
            }
        } else {
            generalizations.add(this._interface || this._noInterfaces ? CodeConvention.qTypeName(this._def.getExtends()) : this.implName(this._def.getExtendedDef()));
        }
        if (this._interface) {
            if (this.isBaseClass()) {
                this.addImplements(generalizations);
            }
            this.addMixins(generalizations);
        }
        return this.generalizationList("extends", generalizations);
    }

    private String getImplements() {
        if (this._interface) {
            return "";
        }
        ArrayList<String> generalizations = new ArrayList<String>();
        if (this._noInterfaces) {
            if (this.isBaseClass()) {
                this.addImplements(generalizations);
            }
            this.addMixins(generalizations);
        } else {
            generalizations.add(CodeConvention.typeName(this._def));
        }
        return this.generalizationList("implements", generalizations);
    }

    private void addImplements(List<String> generalizations) {
        if (this._binary) {
            generalizations.add("de.haumacher.msgbuf.binary.BinaryDataObject");
        }
        if (!this._graph) {
            if (this._listener) {
                generalizations.add("de.haumacher.msgbuf.observer.Observable");
            } else if (this._reflection) {
                generalizations.add("de.haumacher.msgbuf.data.ReflectiveDataObject");
            }
        }
    }

    private void addMixins(List<String> generalizations) {
        this._plugin.addInterfaces(this._options, this._def, generalizations);
        Option operations = this._def.getOptions().get("Operations");
        if (operations != null) {
            if (operations instanceof StringOption) {
                StringOption singleOperation = (StringOption)operations;
                generalizations.add(singleOperation.getValue());
            } else {
                System.err.println("String option 'Operations' expected, got: " + operations);
            }
        }
    }

    private String generalizationList(String keyword, List<String> generalizations) {
        if (generalizations.isEmpty()) {
            return "";
        }
        return keyword + " " + generalizations.stream().collect(Collectors.joining(", "));
    }

    @Override
    protected void docComment(String comment) {
        Pattern ref = Pattern.compile("([a-zA-Z_][a-zA-Z_0-9]*)?#([a-zA-Z_][a-zA-Z_0-9]*)");
        Matcher matcher = ref.matcher(comment);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            String type = matcher.group(1);
            String name = matcher.group(2);
            Definition def = this._def;
            if (type != null) {
                def = this._table.lookup(this._def, MessageGenerator.qName(type));
            }
            Field field = def instanceof MessageDef ? CodeConvention.getField(def, name) : null;
            String replacement = (type == null ? "" : type) + "#";
            replacement = field == null ? replacement + name : replacement + MessageGenerator.getterCall(field);
            matcher.appendReplacement(buffer, replacement);
        }
        matcher.appendTail(buffer);
        super.docComment(buffer.toString());
    }

    private void generateClassContents() {
        if (this._interface || this._noInterfaces) {
            if (this._typeKind) {
                this.generateTypeCodeEnum();
            }
            if (this._visitor) {
                this.generateVisitorInterface();
            }
        }
        this.generateInnerDefinitions();
        if (this._interface || this._noInterfaces) {
            this.generateFactoryMethod();
        }
        this.generateConstants();
        if (!this._interface) {
            this.generateFieldMembers();
            this.generateConstructor();
        }
        if (this._typeKind) {
            this.generateKindLookup();
        }
        this.generateAccessors();
        this.generatedSetterOverrides();
        if (this._listener) {
            this.generateListener();
        }
        if (this._reflection || this._json) {
            this.reflectionType();
        }
        if (this._reflection && !this._interface) {
            this.generateReflection();
        }
        if (this._json) {
            this.generateJson();
        }
        if (this._binary) {
            this.generateBinaryIO();
        }
        if (!this._interface) {
            this.include(this._plugin.messageImplContents(this.getOptions(), this._def));
        }
        if (this._interface || this._noInterfaces) {
            this.include(this._plugin.messageInterfaceContents(this.getOptions(), this._def));
        }
        if (this._visitor) {
            this.generateVisitMethods();
        }
    }

    private void generateTypeCodeEnum() {
        if (!this._def.getSpecializations().isEmpty() && this._def == MessageGenerator.getRoot(this._def)) {
            this.nl();
            this.line("/** Type codes for the {@link " + CodeConvention.typeName(this._def) + "} hierarchy. */");
            this.line("public enum TypeKind {");
            for (MessageDef caseDef : MessageGenerator.concreteSpecializations(this._def)) {
                this.nl();
                this.line("/** Type literal for {@link " + CodeConvention.typeName(caseDef) + "}. */");
                this.line(CodeConvention.typeKindConstant(caseDef) + ",");
            }
            this.line(";");
            this.nl();
            this.line("}");
        }
    }

    private void generateVisitorInterface() {
        if (this._def.isAbstract()) {
            this.nl();
            this.line("/** Visitor interface for the {@link " + CodeConvention.typeName(this._def) + "} hierarchy.*/");
            this.lineStart("public interface Visitor<R,A" + this.onVisitEx(",E extends Throwable") + ">");
            boolean first = true;
            for (MessageDef specialization : this._def.getSpecializations()) {
                if (!specialization.isAbstract()) continue;
                if (first) {
                    first = false;
                    this.append(" extends ");
                } else {
                    this.append(", ");
                }
                this.append(CodeConvention.typeName(specialization) + ".Visitor<R,A" + this.onVisitEx(",E") + ">");
            }
            this.append(" {");
            this.nl();
            boolean hasCase = false;
            for (MessageDef specialization : this._def.getSpecializations()) {
                if (specialization.isAbstract()) continue;
                this.nl();
                this.line("/** Visit case for {@link " + CodeConvention.typeName(specialization) + "}.*/");
                this.line("R visit(" + CodeConvention.typeName(specialization) + " self, A arg)" + this.onVisitEx(" throws E") + ";");
                hasCase = true;
            }
            if (!hasCase) {
                this.nl();
                this.line("// Pure sum interface.");
            }
            this.nl();
            this.line("}");
        }
    }

    private void generateInnerDefinitions() {
        for (Definition def : this._def.getDefinitions()) {
            def.visit(this, null);
        }
    }

    @Override
    public Void visit(EnumDef def, Void arg) {
        if (this._interface || this._noInterfaces) {
            this.include(new EnumGenerator(def));
        }
        return null;
    }

    @Override
    public Void visit(MessageDef def, Void arg) {
        this.include(new MessageGenerator(this._table, this._options, this._interface, def, this._plugin));
        return null;
    }

    private void generateFactoryMethod() {
        if (!this._def.isAbstract()) {
            this.nl();
            this.line("/**");
            this.line(" * Creates a {@link " + CodeConvention.typeName(this._def) + "} instance.");
            this.line(" */");
            this.line((this._noInterfaces ? "public " : "") + "static " + CodeConvention.typeName(this._def) + " " + CodeConvention.factoryName(this._def) + "() {");
            this.line("return new " + this.qImplName(this._def) + "();");
            this.line("}");
        }
    }

    private void generateConstants() {
        if ((this._interface || this._noInterfaces) && (this._json || this._reflection) && !this._def.isAbstract()) {
            this.nl();
            this.line("/** Identifier for the {@link " + CodeConvention.typeName(this._def) + "} type in JSON format. */");
            this.line((this._noInterfaces ? "public " : "") + "static final String " + CodeConvention.jsonTypeConstant(this._def) + " = " + this.jsonTypeID(this._def) + ";");
        }
        if ((this._json || this._reflection) && (this._interface || this._noInterfaces)) {
            String modifier = this._reflection ? (this._noInterfaces ? "public " : "") : "private ";
            for (Field field : this.getFields()) {
                if (!this._reflection && field.isTransient()) continue;
                this.nl();
                this.line("/** @see #" + MessageGenerator.getterCall(field) + " */");
                this.line(modifier + "static final String " + CodeConvention.constant(field) + " = " + this.getFieldNameString(field) + ";");
            }
        }
        if (this._binary && (this._interface || this._noInterfaces)) {
            if (!this._def.isAbstract() && MessageGenerator.getRoot(this._def).isAbstract()) {
                this.nl();
                this.line("/** Identifier for the {@link " + CodeConvention.typeName(this._def) + "} type in binary format. */");
                this.line("static final int " + CodeConvention.mkBinaryTypeConstant(this._def) + " = " + this._def.getId() + ";");
            }
            for (Field field : this.getFields()) {
                if (field.isTransient() || field.isDerived()) continue;
                this.nl();
                this.line("/** Identifier for the property {@link #" + MessageGenerator.getterCall(field) + "} in binary format. */");
                this.line("static final int " + CodeConvention.binaryConstant(field) + " = " + field.getIndex() + ";");
            }
        }
    }

    private String getFieldNameString(Field field) {
        return CodeUtil.stringLiteral(MsgBufJsonProtocol.fieldId(field));
    }

    private void generateConstructor() {
        this.nl();
        this.line("/**");
        this.line(" * Creates a {@link " + this.implName(this._def) + "} instance.");
        if (!this._def.isAbstract()) {
            this.line(" *");
            this.line(" * @see " + CodeConvention.typeName(this._def) + "#" + CodeConvention.factoryName(this._def) + "()");
        }
        this.line(" */");
        this.line("protected " + this.implName(this._def) + "() {");
        this.line("super();");
        this.line("}");
    }

    private void generateFieldMembers() {
        for (Field field : this.getFields()) {
            this.nl();
            if (field.isRepeated()) {
                boolean hasReverseEnd;
                Field reverseEnd = this.reverseEnd(field);
                boolean bl = hasReverseEnd = reverseEnd != null;
                if (this._listener || hasReverseEnd) {
                    String qFieldTypeName = TypeGenerator.mkTypeWrapped(field.getType());
                    this.line("private" + this.mkTransient(field) + this.mkFinal(field) + " " + TypeGenerator.mkType(field) + " " + CodeConvention.fieldMemberName(field) + " = new de.haumacher.msgbuf.util.ReferenceList<" + qFieldTypeName + ">() {");
                    this.line("@Override");
                    this.line("protected void beforeAdd(int index, " + qFieldTypeName + " element) {");
                    if (this._listener) {
                        this.line("_listener.beforeAdd(" + this.implName(this._def) + ".this, " + CodeConvention.constant(field) + ", index, element);");
                    }
                    if (hasReverseEnd) {
                        this.line("((" + TypeGenerator.mkTypeWrappedImpl(field.getType()) + ") element)." + CodeConvention.adderName(reverseEnd) + "(" + this.implName(this._def) + ".this);");
                    }
                    this.line("}");
                    this.nl();
                    this.line("@Override");
                    this.line("protected void afterRemove(int index, " + qFieldTypeName + " element) {");
                    if (hasReverseEnd) {
                        this.line("((" + TypeGenerator.mkTypeWrappedImpl(field.getType()) + ") element)." + CodeConvention.removerName(reverseEnd) + "(" + this.implName(this._def) + ".this);");
                    }
                    if (this._listener) {
                        this.line("_listener.afterRemove(" + this.implName(this._def) + ".this, " + CodeConvention.constant(field) + ", index, element);");
                    }
                    this.line("}");
                    this.line("};");
                    continue;
                }
            }
            this.line("private" + this.mkTransient(field) + this.mkFinal(field) + " " + TypeGenerator.mkType(field) + " " + CodeConvention.fieldMemberName(field) + this.mkInitializer(field) + ";");
        }
    }

    private void generateKindLookup() {
        boolean hasTypeLookup;
        boolean hasSpecializations = !this._def.getSpecializations().isEmpty();
        boolean bl = hasTypeLookup = !this.isBaseClass() || hasSpecializations;
        if (hasTypeLookup) {
            if (this._interface) {
                if (this.isBaseClass()) {
                    this.nl();
                    this.kindLookupComment();
                    this.line("TypeKind kind();");
                }
            } else if (this._def.isAbstract()) {
                if (this.isBaseClass()) {
                    this.nl();
                    this.kindLookupComment();
                    this.line("public abstract TypeKind kind();");
                }
            } else {
                this.nl();
                this.line("@Override");
                this.line("public TypeKind kind() {");
                this.line("return TypeKind." + CodeConvention.typeKindConstant(this._def) + ";");
                this.line("}");
            }
        }
    }

    private void kindLookupComment() {
        this.line("/** The type code of this instance. */");
    }

    private void generateAccessors() {
        for (Field field : this.getFields()) {
            this.generateAccessors(field);
        }
    }

    private void generateAccessors(Field field) {
        this.accessorGetter(field);
        this.accessorSetter(field, false);
        if (!this._interface) {
            this.accessorSetterImpl(field);
        }
        this.accessorAdder(field, false);
        this.accessorAdderImpl(field);
        this.accessorHasValue(field);
    }

    private void generatedSetterOverrides() {
        for (MessageDef anchestor = this._def.getExtendedDef(); anchestor != null; anchestor = anchestor.getExtendedDef()) {
            for (Field field : anchestor.getFields()) {
                this.accessorSetter(field, true);
                this.accessorAdder(field, true);
            }
        }
    }

    private void accessorGetter(Field field) {
        this.nl();
        if (this._interface) {
            this.docComment(field.getComment());
            this.line(TypeGenerator.mkType(field) + " " + CodeConvention.getterName(field) + "();");
        } else {
            if (this._noInterfaces) {
                this.docComment(field.getComment());
            } else {
                this.line("@Override");
            }
            this.line("public final " + TypeGenerator.mkType(field) + " " + CodeConvention.getterName(field) + "() {");
            this.line("return " + CodeConvention.fieldMemberName(field) + ";");
            this.line("}");
        }
    }

    private void accessorSetter(Field field, boolean override) {
        if (this._interface) {
            if (!field.isDerived()) {
                this.nl();
                if (override) {
                    this.line("@Override");
                } else {
                    this.setterDoc(field);
                }
                this.line(this.myType() + " " + CodeConvention.setterName(field) + "(" + TypeGenerator.mkTypeReadOnly(field) + " value);");
            }
        } else {
            this.nl();
            if (!field.isDerived()) {
                if (!override && this._noInterfaces) {
                    this.setterDoc(field);
                } else {
                    this.line("@Override");
                }
            }
            this.line(this.setterModifier(field) + this.myType() + " " + CodeConvention.setterName(field) + "(" + TypeGenerator.mkTypeReadOnly(field) + " value) {");
            this.line(CodeConvention.internalSetterName(field) + "(value);");
            this.generateChain();
            this.line("}");
        }
    }

    private void setterDoc(Field field) {
        this.line("/**");
        this.line(" * @see #" + CodeConvention.getterName(field) + "()");
        this.line(" */");
    }

    private void accessorSetterImpl(Field field) {
        this.nl();
        this.line("/** Internal setter for {@link #" + CodeConvention.getterName(field) + "()} without chain call utility. */");
        this.line("protected final void " + CodeConvention.internalSetterName(field) + "(" + TypeGenerator.mkTypeReadOnly(field) + " value) {");
        Type type = field.getType();
        if (!Util.isNullable(field) && !(type instanceof PrimitiveType)) {
            this.line("if (value == null) throw new IllegalArgumentException(" + CodeUtil.stringLiteral("Property '" + field.getName() + "' cannot be null.") + ");");
        }
        if (field.isRepeated()) {
            this.setterReset(field);
            this.line(CodeConvention.fieldMemberName(field) + ".addAll(value);");
        } else if (type instanceof MapType) {
            this.setterReset(field);
            this.line(CodeConvention.fieldMemberName(field) + ".putAll(value);");
        } else {
            boolean hasReverseEnd;
            Field reverseEnd = this.reverseEnd(field);
            boolean bl = hasReverseEnd = reverseEnd != null;
            if (this._listener) {
                this.line("_listener.beforeSet(this, " + CodeConvention.constant(field) + ", value);");
            }
            if (hasReverseEnd) {
                this.line("if (" + CodeConvention.fieldMemberName(field) + " != null) {");
                this.line("((" + TypeGenerator.mkTypeWrappedImpl(type) + ") " + CodeConvention.fieldMemberName(field) + ")." + CodeConvention.removerName(reverseEnd) + "(this);");
                this.line("}");
            }
            this.line(CodeConvention.fieldMemberName(field) + " = value;");
            if (hasReverseEnd) {
                this.line("if (value != null) {");
                this.line("((" + TypeGenerator.mkTypeWrappedImpl(type) + ") value)." + CodeConvention.adderName(reverseEnd) + "(this);");
                this.line("}");
            }
        }
        this.line("}");
    }

    private Field reverseEnd(Field field) {
        Definition typeDef;
        Type type = field.getType();
        if (type instanceof CustomType && (typeDef = ((CustomType)type).getDefinition()) instanceof MessageDef) {
            MessageDef messageType = (MessageDef)typeDef;
            return MessageGenerator.getReverseField(messageType, field.getName());
        }
        return null;
    }

    private void setterReset(Field field) {
        if (Util.isNullable(field)) {
            this.adderInitNullable(field);
        }
        this.line(CodeConvention.fieldMemberName(field) + ".clear();");
    }

    private void accessorAdder(Field field, boolean override) {
        Type type = field.getType();
        if (field.isRepeated()) {
            if (this._interface) {
                if (!field.isDerived()) {
                    this.nl();
                    if (override) {
                        this.line("@Override");
                    } else {
                        this.adderDoc(field);
                    }
                    this.line(this.myType() + " " + CodeConvention.adderName(field) + "(" + TypeGenerator.mkType(type) + " value);");
                }
            } else {
                this.nl();
                if (!field.isDerived()) {
                    if (!override && this._noInterfaces) {
                        this.adderDoc(field);
                    } else {
                        this.line("@Override");
                    }
                }
                this.line(this.setterModifier(field) + this.myType() + " " + CodeConvention.adderName(field) + "(" + TypeGenerator.mkType(type) + " value) {");
                this.line(CodeConvention.internalAdderName(field) + "(value);");
                this.generateChain();
                this.line("}");
            }
        } else if (type instanceof MapType) {
            MapType mapType = (MapType)type;
            if (this._interface) {
                if (!field.isDerived()) {
                    this.nl();
                    if (override) {
                        this.line("@Override");
                    } else {
                        this.putDoc(field);
                    }
                    this.line(this.myType() + " " + CodeConvention.adderName(field) + "(" + TypeGenerator.mkType(mapType.getKeyType()) + " key, " + TypeGenerator.mkType(mapType.getValueType()) + " value);");
                }
            } else {
                this.nl();
                if (!field.isDerived()) {
                    if (!override && this._noInterfaces) {
                        this.putDoc(field);
                    } else {
                        this.line("@Override");
                    }
                }
                this.line(this.setterModifier(field) + this.myType() + " " + CodeConvention.adderName(field) + "(" + TypeGenerator.mkType(mapType.getKeyType()) + " key, " + TypeGenerator.mkType(mapType.getValueType()) + " value) {");
                this.line(CodeConvention.internalAdderName(field) + "(key, value);");
                this.generateChain();
                this.line("}");
            }
        }
    }

    private void putDoc(Field field) {
        this.line("/**");
        this.line(" * Adds a key value pair to the {@link #" + CodeConvention.getterName(field) + "()} map.");
        this.line(" */");
    }

    private void adderDoc(Field field) {
        this.line("/**");
        this.line(" * Adds a value to the {@link #" + CodeConvention.getterName(field) + "()} list.");
        this.line(" */");
    }

    private void accessorAdderImpl(Field field) {
        Type type = field.getType();
        if (field.isRepeated()) {
            if (!this._interface) {
                this.nl();
                this.line("/** Implementation of {@link #" + CodeConvention.adderName(field) + "(" + TypeGenerator.mkType(type) + ")} without chain call utility. */");
                this.line("protected final void " + CodeConvention.internalAdderName(field) + "(" + TypeGenerator.mkType(type) + " value) {");
                this.adderInitNullable(field);
                this.line(CodeConvention.fieldMemberName(field) + ".add(value);");
                this.line("}");
            }
            if (this._interface) {
                if (!field.isDerived()) {
                    this.nl();
                    this.removerDoc(field);
                    this.line("void " + CodeConvention.removerName(field) + "(" + TypeGenerator.mkType(type) + " value);");
                }
            } else {
                this.nl();
                if (!field.isDerived()) {
                    if (this._noInterfaces) {
                        this.removerDoc(field);
                    } else {
                        this.line("@Override");
                    }
                }
                this.line(this.setterModifier(field) + "final void " + CodeConvention.removerName(field) + "(" + TypeGenerator.mkType(type) + " value) {");
                this.adderInitNullable(field);
                this.line(CodeConvention.fieldMemberName(field) + ".remove(value);");
                this.line("}");
            }
        } else if (type instanceof MapType) {
            MapType mapType = (MapType)type;
            if (!this._interface) {
                this.nl();
                this.line("/** Implementation of {@link #" + CodeConvention.adderName(field) + "(" + TypeGenerator.mkType(mapType.getKeyType()) + ", " + TypeGenerator.mkType(mapType.getValueType()) + ")} without chain call utility. */");
                this.line("protected final void  " + CodeConvention.internalAdderName(field) + "(" + TypeGenerator.mkType(mapType.getKeyType()) + " key, " + TypeGenerator.mkType(mapType.getValueType()) + " value) {");
                this.adderInitNullable(field);
                this.line("if (" + CodeConvention.fieldMemberName(field) + ".containsKey(key)) {");
                this.line("throw new IllegalArgumentException(" + CodeUtil.stringLiteral("Property '" + field.getName() + "' already contains a value for key '") + " + key + " + CodeUtil.stringLiteral("'.") + ");");
                this.line("}");
                this.line(CodeConvention.fieldMemberName(field) + ".put(key, value);");
                this.line("}");
            }
            if (this._interface) {
                if (!field.isDerived()) {
                    this.nl();
                    this.removeKeyDoc(field);
                    this.line("void " + CodeConvention.removerName(field) + "(" + TypeGenerator.mkType(mapType.getKeyType()) + " key);");
                }
            } else {
                this.nl();
                if (!field.isDerived()) {
                    if (this._noInterfaces) {
                        this.removeKeyDoc(field);
                    } else {
                        this.line("@Override");
                    }
                }
                this.line(this.setterModifier(field) + "final void " + CodeConvention.removerName(field) + "(" + TypeGenerator.mkType(mapType.getKeyType()) + " key) {");
                this.adderInitNullable(field);
                this.line(CodeConvention.fieldMemberName(field) + ".remove(key);");
                this.line("}");
            }
        }
    }

    private void removeKeyDoc(Field field) {
        this.line("/**");
        this.line(" * Removes a key from the {@link #" + CodeConvention.getterName(field) + "()} map.");
        this.line(" */");
    }

    private void removerDoc(Field field) {
        this.line("/**");
        this.line(" * Removes a value from the {@link #" + CodeConvention.getterName(field) + "()} list.");
        this.line(" */");
    }

    private String setterModifier(Field field) {
        String modifier = field.isDerived() ? "" : "public ";
        return modifier;
    }

    private void adderInitNullable(Field field) {
        if (Util.isNullable(field)) {
            this.line("if (" + CodeConvention.fieldMemberName(field) + " == null) " + CodeConvention.fieldMemberName(field) + " = " + DefaultValueGenerator.mkDefaultValueNonNullable(field) + ";");
        }
    }

    private void accessorHasValue(Field field) {
        if (Util.isNullable(field)) {
            this.nl();
            if (this._interface) {
                this.hasValueDoc(field);
                this.line("boolean " + CodeConvention.hasName(field) + "();");
            } else {
                if (this._noInterfaces) {
                    this.hasValueDoc(field);
                } else {
                    this.line("@Override");
                }
                this.line("public final boolean " + CodeConvention.hasName(field) + "() {");
                this.line("return _" + CodeConvention.name(field) + " != null;");
                this.line("}");
            }
        }
    }

    private void hasValueDoc(Field field) {
        this.line("/**");
        this.line(" * Checks, whether {@link #" + CodeConvention.getterName(field) + "()} has a value.");
        this.line(" */");
    }

    private void generateListener() {
        if (!this._graph && this.isBaseClass()) {
            if (!this._interface) {
                this.nl();
                this.line("protected de.haumacher.msgbuf.observer.Listener _listener = de.haumacher.msgbuf.observer.Listener.NONE;");
            }
            this.nl();
            if (this._interface) {
                this.line("@Override");
                this.line("public " + this.myType() + " registerListener(de.haumacher.msgbuf.observer.Listener l);");
            } else {
                this.line("@Override");
                this.line("public " + this.myType() + " registerListener(de.haumacher.msgbuf.observer.Listener l) {");
                this.line("internalRegisterListener(l);");
                this.generateChain();
                this.line("}");
            }
            if (!this._interface) {
                this.nl();
                this.line("protected final void internalRegisterListener(de.haumacher.msgbuf.observer.Listener l) {");
                this.line("_listener = de.haumacher.msgbuf.observer.Listener.register(_listener, l);");
                this.line("}");
            }
            this.nl();
            if (this._interface) {
                this.line("@Override");
                this.line("public " + this.myType() + " unregisterListener(de.haumacher.msgbuf.observer.Listener l);");
            } else {
                this.line("@Override");
                this.line("public " + this.myType() + " unregisterListener(de.haumacher.msgbuf.observer.Listener l) {");
                this.line("internalUnregisterListener(l);");
                this.generateChain();
                this.line("}");
            }
            if (!this._interface) {
                this.nl();
                this.line("protected final void internalUnregisterListener(de.haumacher.msgbuf.observer.Listener l) {");
                this.line("_listener = de.haumacher.msgbuf.observer.Listener.unregister(_listener, l);");
                this.line("}");
            }
        }
    }

    private void generateReflection() {
        if (this.hasFields()) {
            this.reflectionPropertiesConstant();
            this.reflectionProperties();
            this.reflectionGet();
            this.reflectionSet();
        }
    }

    private void reflectionType() {
        if (!this._reflection || !this._def.isAbstract()) {
            this.nl();
            if (this._def.isAbstract()) {
                if (this._interface || this._noInterfaces) {
                    this.jsonTypeDoc();
                    this.line((this._noInterfaces ? "public abstract " : "") + "String jsonType();");
                }
            } else if (!this._interface) {
                this.line("@Override");
                this.line("public String jsonType() {");
                this.line("return " + CodeConvention.jsonTypeConstant(this._def) + ";");
                this.line("}");
            }
        }
    }

    private void jsonTypeDoc() {
        this.line("/** The type identifier for this concrete subtype. */");
    }

    private void reflectionPropertiesConstant() {
        this.nl();
        this.line("private static java.util.List<String> PROPERTIES = java.util.Collections.unmodifiableList(");
        this.line("java.util.Arrays.asList(");
        boolean first = true;
        for (Field field : this.getFields()) {
            if (first) {
                first = false;
            } else {
                this.append(", ");
                this.nl();
            }
            this.lineStart(CodeConvention.constant(field));
        }
        this.append("));");
        this.nl();
    }

    private void reflectionProperties() {
        this.nl();
        this.line("@Override");
        this.line("public java.util.List<String> properties() {");
        this.line("return PROPERTIES;");
        this.line("}");
    }

    private void reflectionGet() {
        this.nl();
        this.line("@Override");
        this.line("public Object get(String field) {");
        this.line("switch (field) {");
        for (Field field : this.getFields()) {
            this.line("case " + CodeConvention.constant(field) + ": return " + CodeConvention.getterName(field) + "();");
        }
        if (!this._graph && this.isBaseClass()) {
            if (this._noInterfaces) {
                this.line("default: return null;");
            } else {
                this.line("default: return " + CodeConvention.typeName(this._def) + ".super.get(field);");
            }
        } else {
            this.line("default: return super.get(field);");
        }
        this.line("}");
        this.line("}");
    }

    private void reflectionSet() {
        this.nl();
        this.line("@Override");
        this.line("public void set(String field, Object value) {");
        this.line("switch (field) {");
        for (Field field : this.getFields()) {
            if (field.isDerived()) continue;
            this.line("case " + CodeConvention.constant(field) + ": " + CodeConvention.internalSetterName(field) + "(" + this.mkCast(field, "value") + "); break;");
        }
        if (!this.isBaseClass()) {
            this.line("default: super.set(field, value); break;");
        }
        this.line("}");
        this.line("}");
    }

    private void generateJson() {
        if (this._interface || this._noInterfaces) {
            this.nl();
            this.line("/** Reads a new instance from the given reader. */");
            this.line((this._noInterfaces ? "public " : "") + "static " + this.thisType() + " " + CodeConvention.readerName(this._def) + "(" + this.scopeParam() + "de.haumacher.msgbuf.json.JsonReader in) throws java.io.IOException {");
            if (this._graph) {
                this.line("if (in.peek() == de.haumacher.msgbuf.json.JsonToken.NUMBER) {");
                this.line("return (" + this.thisType() + ") scope.resolveOrFail(in.nextInt());");
                this.line("}");
            }
            if (this._def.isAbstract()) {
                this.line(this.thisType() + " result;");
                this.line("in.beginArray();");
                this.line("String type = in.nextString();");
                if (this._graph) {
                    this.line("int id = in.nextInt();");
                }
                this.line("switch (type) {");
                for (MessageDef specialization : Util.concreteTransitiveSpecializations(this._def)) {
                    if (this._graph) {
                        this.line("case " + CodeConvention.jsonTypeConstantRef(specialization) + ": result = " + CodeConvention.typeName(specialization) + ".create(); break;");
                        continue;
                    }
                    this.line("case " + CodeConvention.jsonTypeConstantRef(specialization) + ": result = " + CodeConvention.qTypeName(specialization) + "." + CodeConvention.readerName(specialization) + "(in); break;");
                }
                this.line("default: in.skipValue(); result = null; break;");
                this.line("}");
                if (this._graph) {
                    this.line("if (result != null) {");
                    this.line("scope.readData(result, id, in);");
                    this.line("}");
                }
                this.line("in.endArray();");
            } else {
                if (this._graph) {
                    this.line("in.beginArray();");
                    this.line("String type = in.nextString();");
                    this.line("assert " + CodeConvention.jsonTypeConstant(this._def) + ".equals(type);");
                    this.line("int id = in.nextInt();");
                }
                this.line(this.qImplName(this._def) + " result = new " + this.qImplName(this._def) + "();");
                if (this._graph) {
                    this.line("scope.readData(result, id, in);");
                    this.line("in.endArray();");
                } else {
                    this.line("result.readContent(" + this.scopeArg() + "in);");
                }
            }
            this.line("return result;");
            this.line("}");
        }
        if (!this._interface) {
            if (!this._graph && this.isBaseClass()) {
                this.nl();
                this.line("@Override");
                this.line("public final void writeTo(" + this.scopeParam() + "de.haumacher.msgbuf.json.JsonWriter out) throws java.io.IOException {");
                if (this._def.isAbstract()) {
                    this.line("out.beginArray();");
                    this.line("out.value(jsonType());");
                    this.line("writeContent(" + this.scopeArg() + "out);");
                    this.line("out.endArray();");
                } else {
                    this.line("writeContent(out);");
                }
                this.line("}");
            }
            if (this.hasFields()) {
                List fieldsWithElements;
                boolean nullable;
                this.nl();
                this.line("@Override");
                this.line("protected void writeFields(" + this.scopeParam() + "de.haumacher.msgbuf.json.JsonWriter out) throws java.io.IOException {");
                this.line("super.writeFields(" + this.scopeArg() + "out);");
                for (Field field2 : this.getFields()) {
                    if (field2.isTransient() || field2.isDerived()) continue;
                    nullable = Util.isNullable(field2);
                    if (nullable) {
                        this.line("if (" + CodeConvention.hasName(field2) + "()) {");
                    }
                    this.line("out.name(" + CodeConvention.constant(field2) + ");");
                    this.writeFieldValue(field2);
                    if (!nullable) continue;
                    this.line("}");
                }
                this.line("}");
                if (this._graph) {
                    this.nl();
                    this.line("@Override");
                    this.line("public void writeFieldValue(" + this.scopeParam() + "de.haumacher.msgbuf.json.JsonWriter out, String field) throws java.io.IOException {");
                    this.line("switch (field) {");
                    for (Field field2 : this.getFields()) {
                        this.line("case " + CodeConvention.constant(field2) + ": {");
                        nullable = Util.isNullable(field2);
                        if (nullable) {
                            this.line("if (" + CodeConvention.hasName(field2) + "()) {");
                        }
                        this.writeFieldValue(field2);
                        if (nullable) {
                            this.line("} else {");
                            this.line("out.nullValue();");
                            this.line("}");
                        }
                        this.line("break;");
                        this.line("}");
                    }
                    this.line("default: super.writeFieldValue(" + this.scopeArg() + "out, field);");
                    this.line("}");
                    this.line("}");
                }
                this.nl();
                this.line("@Override");
                this.line((this._graph ? "public" : "protected") + " void readField(" + this.scopeParam() + "de.haumacher.msgbuf.json.JsonReader in, String field) throws java.io.IOException {");
                this.line("switch (field) {");
                for (Field field2 : this.getFields()) {
                    this.jsonReadField(field2);
                }
                this.line("default: super.readField(" + this.scopeArg() + "in, field);");
                this.line("}");
                this.line("}");
                if (this._graph && !(fieldsWithElements = this.getFields().stream().filter(field -> !field.isTransient() && !field.isDerived() && field.isRepeated()).collect(Collectors.toList())).isEmpty()) {
                    this.nl();
                    this.line("@Override");
                    this.line("public void writeElement(de.haumacher.msgbuf.graph.Scope scope, de.haumacher.msgbuf.json.JsonWriter out, String field, Object element) throws java.io.IOException {");
                    this.line("switch (field) {");
                    for (Field field3 : fieldsWithElements) {
                        this.line("case " + CodeConvention.constant(field3) + ": {");
                        this.jsonOutValue(field3.getType(), "((" + TypeGenerator.mkType(field3.getType()) + ") element)");
                        this.line("break;");
                        this.line("}");
                    }
                    this.line("default: super.writeElement(scope, out, field, element);");
                    this.line("}");
                    this.line("}");
                    this.nl();
                    this.line("@Override");
                    this.line("public Object readElement(de.haumacher.msgbuf.graph.Scope scope, de.haumacher.msgbuf.json.JsonReader in, String field) throws java.io.IOException {");
                    this.line("switch (field) {");
                    for (Field field4 : fieldsWithElements) {
                        this.line("case " + CodeConvention.constant(field4) + ": {");
                        this.line("return " + this.jsonReadEntry(field4.getType()) + ";");
                        this.line("}");
                    }
                    this.line("default: return super.readElement(scope, in, field);");
                    this.line("}");
                    this.line("}");
                }
            }
        }
    }

    private void writeFieldValue(Field field) {
        if (field.isRepeated()) {
            this.line("out.beginArray();");
            this.line("for (" + TypeGenerator.mkType(field.getType()) + " x : " + CodeConvention.getterName(field) + "()) {");
            this.jsonOutValue(field.getType(), "x");
            this.line("}");
            this.line("out.endArray();");
        } else {
            this.jsonOutValue(field.getType(), MessageGenerator.getterCall(field));
        }
    }

    private String scopeParam() {
        return this._graph ? "de.haumacher.msgbuf.graph.Scope scope, " : "";
    }

    private String scopeArg() {
        return this._graph ? "scope, " : "";
    }

    private void jsonReadField(Field field) {
        if (field.isTransient()) {
            return;
        }
        if (field.isDerived()) {
            return;
        }
        Type type = field.getType();
        if (field.isRepeated()) {
            this.line("case " + CodeConvention.constant(field) + ": {");
            this.line("in.beginArray();");
            this.line("while (in.hasNext()) {");
            this.line(CodeConvention.adderName(field) + "(" + this.jsonReadEntry(type) + ");");
            this.line("}");
            this.line("in.endArray();");
            this.line("}");
            this.line("break;");
        } else if (type instanceof MapType) {
            MapType mapType = (MapType)type;
            this.line("case " + CodeConvention.constant(field) + ": {");
            Type keyType = mapType.getKeyType();
            Type valueType = mapType.getValueType();
            if (keyType instanceof PrimitiveType && ((PrimitiveType)keyType).getKind() == PrimitiveType.Kind.STRING) {
                this.line("in.beginObject();");
                this.line("while (in.hasNext()) {");
                this.line(CodeConvention.adderName(field) + "(in.nextName(), " + this.jsonReadEntry(valueType) + ");");
                this.line("}");
                this.line("in.endObject();");
            } else {
                this.line("in.beginArray();");
                this.line("while (in.hasNext()) {");
                this.line("in.beginObject();");
                this.line(TypeGenerator.mkType(keyType) + " key = " + DefaultValueGenerator.mkDefaultValue(keyType) + ";");
                this.line(TypeGenerator.mkType(valueType) + " value = " + DefaultValueGenerator.mkDefaultValue(valueType) + ";");
                this.line("while (in.hasNext()) {");
                this.line("switch (in.nextName()) {");
                this.line("case \"key\": key = " + this.jsonReadEntry(keyType) + "; break;");
                this.line("case \"value\": value = " + this.jsonReadEntry(valueType) + "; break;");
                this.line("default: in.skipValue(); break;");
                this.line("}");
                this.line("}");
                this.line(CodeConvention.adderName(field) + "(key, value);");
                this.line("in.endObject();");
                this.line("}");
                this.line("in.endArray();");
            }
            this.line("break;");
            this.line("}");
        } else {
            this.line("case " + CodeConvention.constant(field) + ": " + CodeConvention.setterName(field) + "(" + this.jsonReadEntry(type) + "); break;");
        }
    }

    private String jsonReadEntry(Type type) {
        if (type instanceof PrimitiveType) {
            return this.jsonType(((PrimitiveType)type).getKind());
        }
        if (type instanceof CustomType) {
            CustomType messageType = (CustomType)type;
            QName name = messageType.getName();
            if (messageType.getDefinition() == null) {
                System.err.println("ERROR: No definition found for type '" + type + "'.");
                return "ERROR";
            }
            if (messageType.getDefinition().kind() == WithOptions.TypeKind.ENUM_DEF) {
                return CodeConvention.qTypeName(messageType) + "." + CodeConvention.readerName(Util.last(name)) + "(in)";
            }
            return CodeConvention.qTypeName(messageType) + "." + CodeConvention.readerName(Util.last(name)) + "(" + this.scopeArg() + "in)";
        }
        throw new RuntimeException("Unsupported: " + type);
    }

    private String jsonTypeID(MessageDef def) {
        return CodeUtil.stringLiteral(MsgBufJsonProtocol.typeId(def));
    }

    private String jsonType(PrimitiveType.Kind primitive) {
        switch (primitive) {
            case BOOL: {
                return "in.nextBoolean()";
            }
            case FLOAT: {
                return "(float) in.nextDouble()";
            }
            case DOUBLE: {
                return "in.nextDouble()";
            }
            case INT_32: 
            case SINT_32: 
            case UINT_32: 
            case FIXED_32: 
            case SFIXED_32: {
                return "in.nextInt()";
            }
            case INT_64: 
            case SINT_64: 
            case UINT_64: 
            case FIXED_64: 
            case SFIXED_64: {
                return "in.nextLong()";
            }
            case STRING: {
                return "de.haumacher.msgbuf.json.JsonUtil.nextStringOptional(in)";
            }
            case BYTES: {
                return "de.haumacher.msgbuf.json.JsonUtil.nextBinaryOptional(in)";
            }
        }
        throw new RuntimeException("No such type: " + primitive);
    }

    private void jsonOutValue(Type type, String x) {
        this.jsonOutValue(type, x, 0);
    }

    private void jsonOutValue(Type type, String x, int depth) {
        if (type instanceof PrimitiveType) {
            switch (((PrimitiveType)type).getKind()) {
                case BYTES: {
                    this.line("de.haumacher.msgbuf.json.JsonUtil.writeBinaryOptional(out, " + x + ");");
                    break;
                }
                default: {
                    this.line("out.value(" + x + ");");
                    break;
                }
            }
        } else if (type instanceof CustomType) {
            CustomType customType = (CustomType)type;
            if (!this._graph && this.isMonomorphicReferenceToTypeInPolymorphicHierarchy(customType)) {
                this.line(x + ".writeContent(" + this.scopeArg() + "out);");
            } else if (customType.getDefinition() == null) {
                System.err.println("ERROR: No definition found for type '" + type + "'.");
            } else if (customType.getDefinition().kind() == WithOptions.TypeKind.ENUM_DEF) {
                this.line(x + ".writeTo(out);");
            } else {
                this.line(x + ".writeTo(" + this.scopeArg() + "out);");
            }
        } else if (type instanceof MapType) {
            MapType mapType = (MapType)type;
            Type keyType = mapType.getKeyType();
            Type valueType = mapType.getValueType();
            if (keyType instanceof PrimitiveType && ((PrimitiveType)keyType).getKind() == PrimitiveType.Kind.STRING) {
                this.line("out.beginObject();");
                Object entry = "entry";
                if (depth > 0) {
                    entry = (String)entry + depth;
                }
                this.line("for (" + this.mkEntryType(mapType) + " " + (String)entry + " : " + x + ".entrySet()) {");
                this.line("out.name(" + (String)entry + ".getKey());");
                this.jsonOutValue(valueType, (String)entry + ".getValue()", depth + 1);
                this.line("}");
                this.line("out.endObject();");
            } else {
                this.line("out.beginArray();");
                Object entry = "entry";
                if (depth > 0) {
                    entry = (String)entry + depth;
                }
                this.line("for (" + this.mkEntryType(mapType) + " " + (String)entry + " : " + x + ".entrySet()) {");
                this.line("out.beginObject();");
                this.line("out.name(\"key\");");
                this.jsonOutValue(keyType, (String)entry + ".getKey()", depth + 1);
                this.line("out.name(\"value\");");
                this.jsonOutValue(valueType, (String)entry + ".getValue()", depth + 1);
                this.line("out.endObject();");
                this.line("}");
                this.line("out.endArray();");
            }
        } else {
            throw new RuntimeException("Unsupported: " + type);
        }
    }

    private String mkEntryType(MapType mapType) {
        return "java.util.Map.Entry<" + TypeGenerator.mkTypeWrapped(mapType.getKeyType()) + "," + TypeGenerator.mkTypeWrapped(mapType.getValueType()) + ">";
    }

    private void generateBinaryIO() {
        this.binaryTypeId();
        if (!this._interface) {
            this.binaryWrite();
        }
        this.binaryRead();
    }

    private void binaryTypeId() {
        if (this.isBaseClass()) {
            if (this._def.isAbstract() && (this._interface || this._noInterfaces)) {
                this.nl();
                this.typeIdDoc();
                this.line("abstract int typeId();");
            }
        } else if (!this._def.isAbstract() && MessageGenerator.getRoot(this._def).isAbstract() && !this._interface) {
            this.nl();
            if (this._noInterfaces) {
                this.typeIdDoc();
            } else {
                this.line("@Override");
            }
            this.line("public int typeId() {");
            this.line("return " + CodeConvention.mkBinaryTypeConstant(this._def) + ";");
            this.line("}");
        }
    }

    private void typeIdDoc() {
        this.line("/** The binary identifier for this concrete type in the polymorphic {@link " + CodeConvention.typeName(this._def) + "} hierarchy. */");
    }

    private void binaryWrite() {
        if (this.isBaseClass()) {
            this.nl();
            this.line("@Override");
            this.line("public final void writeTo(de.haumacher.msgbuf.binary.DataWriter out) throws java.io.IOException {");
            this.line("out.beginObject();");
            if (this._def.isAbstract()) {
                this.line("out.name(0);");
                this.line("out.value(typeId());");
            }
            this.line("writeFields(out);");
            this.line("out.endObject();");
            this.line("}");
        }
        if (this.isBaseClass() || this.hasFields()) {
            this.nl();
            if (this.isBaseClass()) {
                this.line("/**");
                this.line(" * Serializes all fields of this instance to the given binary output.");
                this.line(" *");
                this.line(" * @param out");
                this.line(" *        The binary output to write to.");
                this.line(" * @throws java.io.IOException If writing fails.");
                this.line(" */");
            } else {
                this.line("@Override");
            }
            this.line("protected void writeFields(de.haumacher.msgbuf.binary.DataWriter out) throws java.io.IOException {");
            if (!this.isBaseClass()) {
                this.line("super.writeFields(out);");
            }
            if (this.getFields().isEmpty()) {
                this.line("// No fields to write, hook for subclasses.");
            } else {
                for (Field field : this.getFields()) {
                    if (field.isTransient() || field.isDerived()) continue;
                    boolean nullable = Util.isNullable(field);
                    if (nullable) {
                        this.line("if (" + CodeConvention.hasName(field) + "()) {");
                    }
                    this.line("out.name(" + CodeConvention.binaryConstant(field) + ");");
                    if (field.isRepeated()) {
                        this.line("{");
                        this.line(TypeGenerator.mkType(field) + " values = " + CodeConvention.getterName(field) + "();");
                        this.line("out.beginArray(de.haumacher.msgbuf.binary.DataType." + this.mkBinaryType(field.getType()) + ", values.size());");
                        this.line("for (" + TypeGenerator.mkType(field.getType()) + " x : values) {");
                        this.binaryWriteValue(field.getType(), "x");
                        this.line("}");
                        this.line("out.endArray();");
                        this.line("}");
                    } else {
                        this.binaryWriteValue(field.getType(), MessageGenerator.getterCall(field));
                    }
                    if (!nullable) continue;
                    this.line("}");
                }
            }
            this.line("}");
        }
    }

    private void binaryWriteValue(Type type, String x) {
        if (type instanceof PrimitiveType) {
            this.line("out.value(" + x + ");");
        } else if (type instanceof CustomType) {
            this.line(x + ".writeTo(out);");
        }
    }

    private void binaryRead() {
        if (this._interface || this._noInterfaces) {
            this.nl();
            this.line("/** Reads a new instance from the given reader. */");
            this.line((this._noInterfaces ? "public " : "") + "static " + this.thisType() + " " + CodeConvention.readerName(this._def) + "(de.haumacher.msgbuf.binary.DataReader in) throws java.io.IOException {");
            this.line("in.beginObject();");
            if (this._def.isAbstract()) {
                this.line("int typeField = in.nextName();");
                this.line("assert typeField == 0;");
                this.line("int type = in.nextInt();");
                this.line(this.thisType() + " result;");
                this.line("switch (type) {");
                for (MessageDef specialization : Util.concreteTransitiveSpecializations(this._def)) {
                    this.line("case " + this.mkBinaryTypeConstantRef(specialization) + ": result = " + this.qImplName(specialization) + "." + CodeConvention.readerNameContent(specialization) + "(in); break;");
                }
                this.line("default: result = null; while (in.hasNext()) {in.skipValue(); }");
                this.line("}");
            } else {
                this.line(this.thisType() + " result = " + this.qImplName(this._def) + "." + CodeConvention.readerNameContent(this._def) + "(in);");
            }
            this.line("in.endObject();");
            this.line("return result;");
            this.line("}");
        }
        if (!this._interface) {
            if (!this._def.isAbstract()) {
                this.nl();
                this.line("/** Helper for creating an object of type {@link " + this.thisType() + "} from a polymorphic composition. */");
                this.line("public static " + this.thisType() + " " + CodeConvention.readerNameContent(this._def) + "(de.haumacher.msgbuf.binary.DataReader in) throws java.io.IOException {");
                this.line(this.qImplName(this._def) + " result = new " + this.implName(this._def) + "();");
                this.line("result.readContent(in);");
                this.line("return result;");
                this.line("}");
            }
            if (this.isBaseClass()) {
                this.nl();
                this.line("/** Helper for reading all fields of this instance. */");
                this.line("protected final void readContent(de.haumacher.msgbuf.binary.DataReader in) throws java.io.IOException {");
                this.line("while (in.hasNext()) {");
                this.line("int field = in.nextName();");
                this.line("readField(in, field);");
                this.line("}");
                this.line("}");
            }
            if (this.isBaseClass() || this.hasFields()) {
                this.nl();
                if (this.isBaseClass()) {
                    this.line("/** Consumes the value for the field with the given ID and assigns its value. */");
                } else {
                    this.line("@Override");
                }
                this.line("protected void readField(de.haumacher.msgbuf.binary.DataReader in, int field) throws java.io.IOException {");
                this.line("switch (field) {");
                for (Field field : this.getFields()) {
                    this.binaryReadField(field);
                }
                if (this.isBaseClass()) {
                    this.line("default: in.skipValue(); ");
                } else {
                    this.line("default: super.readField(in, field);");
                }
                this.line("}");
                this.line("}");
            }
        }
    }

    private String thisType() {
        return CodeConvention.typeName(this._def);
    }

    private String myType() {
        return CodeConvention.typeName(this._def);
    }

    private void generateChain() {
        this.line("return this;");
    }

    private void binaryReadField(Field field) {
        if (field.isTransient()) {
            return;
        }
        if (field.isDerived()) {
            return;
        }
        Type type = field.getType();
        if (field.isRepeated()) {
            this.line("case " + CodeConvention.binaryConstant(field) + ": {");
            this.line("in.beginArray();");
            this.line("while (in.hasNext()) {");
            this.line(CodeConvention.adderName(field) + "(" + this.binaryReadEntry(type) + ");");
            this.line("}");
            this.line("in.endArray();");
            this.line("}");
            this.line("break;");
        } else if (type instanceof MapType) {
            MapType mapType = (MapType)type;
            this.line("case " + CodeConvention.binaryConstant(field) + ": {");
            Type keyType = mapType.getKeyType();
            Type valueType = mapType.getValueType();
            this.line("in.beginArray();");
            this.line("while (in.hasNext()) {");
            this.line("in.beginObject();");
            this.line(TypeGenerator.mkType(keyType) + " key = " + DefaultValueGenerator.mkDefaultValue(keyType) + ";");
            this.line(TypeGenerator.mkType(valueType) + " value = " + DefaultValueGenerator.mkDefaultValue(valueType) + ";");
            this.line("while (in.hasNext()) {");
            this.line("switch (in.nextName()) {");
            this.line("case 1: key = " + this.binaryReadEntry(keyType) + "; break;");
            this.line("case 2: value = " + this.binaryReadEntry(valueType) + "; break;");
            this.line("default: in.skipValue(); break;");
            this.line("}");
            this.line("}");
            this.line(CodeConvention.adderName(field) + "(key, value);");
            this.line("in.endObject();");
            this.line("}");
            this.line("in.endArray();");
            this.line("break;");
            this.line("}");
        } else {
            this.line("case " + CodeConvention.binaryConstant(field) + ": " + CodeConvention.setterName(field) + "(" + this.binaryReadEntry(type) + "); break;");
        }
    }

    private String binaryReadEntry(Type type) {
        if (type instanceof PrimitiveType) {
            return this.mkBinaryReadValue(((PrimitiveType)type).getKind());
        }
        if (type instanceof CustomType) {
            CustomType messageType = (CustomType)type;
            QName messageTypeName = messageType.getName();
            return CodeConvention.qTypeName(messageType) + "." + CodeConvention.readerName(Util.last(messageTypeName)) + "(in)";
        }
        throw new RuntimeException("Unsupported: " + type);
    }

    private String mkBinaryTypeConstantRef(MessageDef def) {
        return CodeConvention.typeName(def) + "." + CodeConvention.mkBinaryTypeConstant(def);
    }

    private String mkBinaryReadValue(PrimitiveType.Kind kind) {
        switch (kind) {
            case BOOL: {
                return "in.nextBoolean()";
            }
            case FLOAT: {
                return "in.nextFloat()";
            }
            case DOUBLE: {
                return "in.nextDouble()";
            }
            case INT_32: 
            case UINT_32: {
                return "in.nextInt()";
            }
            case SINT_32: {
                return "in.nextIntSigned()";
            }
            case FIXED_32: 
            case SFIXED_32: {
                return "in.nextIntFixed()";
            }
            case INT_64: 
            case UINT_64: {
                return "in.nextLong()";
            }
            case SINT_64: {
                return "in.nextLongSigned()";
            }
            case FIXED_64: 
            case SFIXED_64: {
                return "in.nextLongFixed()";
            }
            case STRING: {
                return "in.nextString()";
            }
            case BYTES: {
                return "in.nextBinary()";
            }
        }
        throw new RuntimeException("No such type: " + kind);
    }

    private DataType mkBinaryType(Type type) {
        if (type instanceof PrimitiveType) {
            return this.mkBinaryType(((PrimitiveType)type).getKind());
        }
        if (type instanceof CustomType) {
            Definition definition = ((CustomType)type).getDefinition();
            if (definition instanceof EnumDef) {
                return DataType.INT;
            }
            return DataType.OBJECT;
        }
        return DataType.OBJECT;
    }

    private DataType mkBinaryType(PrimitiveType.Kind primitive) {
        switch (primitive) {
            case BOOL: {
                return DataType.INT;
            }
            case FLOAT: {
                return DataType.FLOAT;
            }
            case DOUBLE: {
                return DataType.DOUBLE;
            }
            case INT_32: 
            case UINT_32: {
                return DataType.INT;
            }
            case SINT_32: {
                return DataType.SINT;
            }
            case FIXED_32: 
            case SFIXED_32: {
                return DataType.FINT;
            }
            case INT_64: 
            case UINT_64: {
                return DataType.LONG;
            }
            case SINT_64: {
                return DataType.SLONG;
            }
            case FIXED_64: 
            case SFIXED_64: {
                return DataType.FLONG;
            }
            case STRING: {
                return DataType.STRING;
            }
            case BYTES: {
                return DataType.BINARY;
            }
        }
        throw new RuntimeException("No such type: " + primitive);
    }

    private void generateVisitMethods() {
        MessageDef gen;
        if (this._def.isAbstract() && (this._interface || this._noInterfaces)) {
            this.nl();
            this.visitDoc();
            this.line("public abstract <R,A" + this.onVisitEx(",E extends Throwable") + "> R visit(Visitor<R,A" + this.onVisitEx(",E") + "> v, A arg)" + this.onVisitEx(" throws E") + ";");
        }
        if ((gen = this.getAbstractGeneralization()) != null && !this._interface) {
            this.nl();
            this.line("@Override");
            this.line("public" + (this._def.isAbstract() ? " final" : "") + " <R,A" + this.onVisitEx(",E extends Throwable") + "> R visit(" + CodeConvention.typeName(gen) + ".Visitor<R,A" + this.onVisitEx(",E") + "> v, A arg) " + this.onVisitEx("throws E ") + "{");
            if (this._def.isAbstract()) {
                this.line("return visit((" + CodeConvention.typeName(this._def) + ".Visitor<R,A" + this.onVisitEx(",E") + ">) v, arg);");
            } else {
                this.line("return v.visit(this, arg);");
            }
            this.line("}");
        }
    }

    private void visitDoc() {
        this.line("/** Accepts the given visitor. */");
    }

    private String onVisitEx(String code) {
        return this._visitEx ? code : "";
    }

    private MessageDef getAbstractGeneralization() {
        MessageDef current = this._def;
        MessageDef extendsDef;
        while ((extendsDef = current.getExtendedDef()) != null) {
            if (extendsDef.isAbstract()) {
                return extendsDef;
            }
            current = extendsDef;
        }
        return null;
    }

    private boolean hasFields() {
        return MessageGenerator.hasFields(this._def);
    }

    static boolean hasFields(MessageDef def) {
        return !def.getFields().isEmpty();
    }

    private List<Field> getFields() {
        return this._def.getFields();
    }

    private boolean isBaseClass() {
        return this._def.getExtends() == null;
    }

    private static MessageDef getRoot(MessageDef def) {
        MessageDef extendedDef = def.getExtendedDef();
        if (extendedDef == null) {
            return def;
        }
        return MessageGenerator.getRoot(extendedDef);
    }

    private boolean isMonomorphicReferenceToTypeInPolymorphicHierarchy(CustomType customType) {
        MessageDef messageDef;
        Definition definition = customType.getDefinition();
        return definition instanceof MessageDef && (messageDef = (MessageDef)definition).getExtendedDef() != null && !messageDef.isAbstract();
    }

    private String mkCast(Field field, String var) {
        if (field.isRepeated()) {
            String elementType = TypeGenerator.mkTypeWrapped(field.getType());
            return "de.haumacher.msgbuf.util.Conversions.asList(" + elementType + ".class, " + var + ")";
        }
        return "(" + TypeGenerator.mkType(field.getType(), Util.isNullable(field)) + ") " + var;
    }

    private String mkTransient(Field field) {
        return field.isTransient() ? " transient" : "";
    }

    private String mkFinal(Field field) {
        boolean isCollection = field.isRepeated() || field.getType() instanceof MapType;
        return isCollection && !Util.isNullable(field) ? " final" : "";
    }

    private String mkInitializer(Field field) {
        return " = " + DefaultValueGenerator.mkDefaultValue(field);
    }

    static QName qName(String name) {
        QName result = QName.create();
        for (String part : name.split("\\.")) {
            result.addName(part);
        }
        return result;
    }

    static String getterCall(Field field) {
        return CodeConvention.getterName(field) + "()";
    }

    static Field getLocalField(MessageDef def, String name) {
        return def.getFields().stream().filter(f -> name.equals(f.getName())).findFirst().orElse(null);
    }

    private static Field getReverseField(MessageDef def, String name) {
        Field result = MessageGenerator.getLocalReverseField(def, name);
        if (result != null) {
            return result;
        }
        MessageDef extendedDef = def.getExtendedDef();
        if (extendedDef != null) {
            return MessageGenerator.getReverseField(extendedDef, name);
        }
        return null;
    }

    static Field getLocalReverseField(MessageDef def, String name) {
        return def.getFields().stream().filter(f -> MessageGenerator.hasReverseName(f, name)).findFirst().orElse(null);
    }

    private static boolean hasReverseName(Field f, String name) {
        StringOption reverseOption = (StringOption)f.getOptions().get("Reverse");
        if (reverseOption == null) {
            return false;
        }
        return reverseOption.getValue().equals(name);
    }
}

