/*
 * Decompiled with CFR 0.152.
 */
package de.haumacher.msgbuf.generator.ast;

import de.haumacher.msgbuf.generator.FieldOperations;
import de.haumacher.msgbuf.generator.ast.Definition;
import de.haumacher.msgbuf.generator.ast.Option;
import de.haumacher.msgbuf.generator.ast.Part;
import de.haumacher.msgbuf.generator.ast.Type;
import de.haumacher.msgbuf.generator.ast.WithOptions;
import de.haumacher.msgbuf.json.JsonReader;
import de.haumacher.msgbuf.json.JsonUtil;
import de.haumacher.msgbuf.json.JsonWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class Field
extends Part
implements FieldOperations {
    public static final String FIELD__TYPE = "Field";
    public static final String TRANSIENT__PROP = "transient";
    public static final String REPEATED__PROP = "repeated";
    public static final String TYPE__PROP = "type";
    public static final String DEFAULT_VALUE__PROP = "defaultValue";
    private boolean _transient = false;
    private boolean _repeated = false;
    private Type _type = null;
    private String _defaultValue = null;
    private static List<String> PROPERTIES = Collections.unmodifiableList(Arrays.asList("transient", "repeated", "type", "defaultValue"));

    public static Field create() {
        return new Field();
    }

    protected Field() {
    }

    @Override
    public WithOptions.TypeKind kind() {
        return WithOptions.TypeKind.FIELD;
    }

    public final boolean isTransient() {
        return this._transient;
    }

    public Field setTransient(boolean value) {
        this.internalSetTransient(value);
        return this;
    }

    protected final void internalSetTransient(boolean value) {
        this._listener.beforeSet(this, TRANSIENT__PROP, value);
        this._transient = value;
    }

    public final boolean isRepeated() {
        return this._repeated;
    }

    public Field setRepeated(boolean value) {
        this.internalSetRepeated(value);
        return this;
    }

    protected final void internalSetRepeated(boolean value) {
        this._listener.beforeSet(this, REPEATED__PROP, value);
        this._repeated = value;
    }

    public final Type getType() {
        return this._type;
    }

    public Field setType(Type value) {
        this.internalSetType(value);
        return this;
    }

    protected final void internalSetType(Type value) {
        this._listener.beforeSet(this, TYPE__PROP, value);
        this._type = value;
    }

    public final boolean hasType() {
        return this._type != null;
    }

    public final String getDefaultValue() {
        return this._defaultValue;
    }

    public Field setDefaultValue(String value) {
        this.internalSetDefaultValue(value);
        return this;
    }

    protected final void internalSetDefaultValue(String value) {
        this._listener.beforeSet(this, DEFAULT_VALUE__PROP, value);
        this._defaultValue = value;
    }

    public final boolean hasDefaultValue() {
        return this._defaultValue != null;
    }

    @Override
    public Field setName(String value) {
        this.internalSetName(value);
        return this;
    }

    @Override
    public Field setIndex(int value) {
        this.internalSetIndex(value);
        return this;
    }

    @Override
    public Field setOwner(Definition value) {
        this.internalSetOwner(value);
        return this;
    }

    @Override
    public Field setComment(String value) {
        this.internalSetComment(value);
        return this;
    }

    @Override
    public Field setOptions(Map<String, Option> value) {
        this.internalSetOptions(value);
        return this;
    }

    @Override
    public Field putOption(String key, Option value) {
        this.internalPutOption(key, value);
        return this;
    }

    @Override
    public String jsonType() {
        return FIELD__TYPE;
    }

    @Override
    public List<String> properties() {
        return PROPERTIES;
    }

    @Override
    public Object get(String field) {
        switch (field) {
            case "transient": {
                return this.isTransient();
            }
            case "repeated": {
                return this.isRepeated();
            }
            case "type": {
                return this.getType();
            }
            case "defaultValue": {
                return this.getDefaultValue();
            }
        }
        return super.get(field);
    }

    @Override
    public void set(String field, Object value) {
        switch (field) {
            case "transient": {
                this.internalSetTransient((Boolean)value);
                break;
            }
            case "repeated": {
                this.internalSetRepeated((Boolean)value);
                break;
            }
            case "type": {
                this.internalSetType((Type)value);
                break;
            }
            case "defaultValue": {
                this.internalSetDefaultValue((String)value);
                break;
            }
            default: {
                super.set(field, value);
            }
        }
    }

    public static Field readField(JsonReader in) throws IOException {
        Field result = new Field();
        result.readContent(in);
        return result;
    }

    @Override
    protected void writeFields(JsonWriter out) throws IOException {
        super.writeFields(out);
        out.name(TRANSIENT__PROP);
        out.value(this.isTransient());
        out.name(REPEATED__PROP);
        out.value(this.isRepeated());
        if (this.hasType()) {
            out.name(TYPE__PROP);
            this.getType().writeTo(out);
        }
        if (this.hasDefaultValue()) {
            out.name(DEFAULT_VALUE__PROP);
            out.value(this.getDefaultValue());
        }
    }

    @Override
    protected void readField(JsonReader in, String field) throws IOException {
        switch (field) {
            case "transient": {
                this.setTransient(in.nextBoolean());
                break;
            }
            case "repeated": {
                this.setRepeated(in.nextBoolean());
                break;
            }
            case "type": {
                this.setType(Type.readType(in));
                break;
            }
            case "defaultValue": {
                this.setDefaultValue(JsonUtil.nextStringOptional(in));
                break;
            }
            default: {
                super.readField(in, field);
            }
        }
    }

    @Override
    public Field self() {
        return this;
    }

    @Override
    public <R, A> R visit(Part.Visitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }
}

