/*
 * Decompiled with CFR 0.152.
 */
package de.haumacher.msgbuf.generator.dart;

import de.haumacher.msgbuf.generator.ast.CustomType;
import de.haumacher.msgbuf.generator.ast.Definition;
import de.haumacher.msgbuf.generator.ast.EnumDef;
import de.haumacher.msgbuf.generator.ast.MapType;
import de.haumacher.msgbuf.generator.ast.MessageDef;
import de.haumacher.msgbuf.generator.ast.PrimitiveType;
import de.haumacher.msgbuf.generator.ast.Type;
import de.haumacher.msgbuf.generator.dart.DartCoding;
import de.haumacher.msgbuf.generator.util.AbstractDartGenerator;

public class WriteOperationBuilder
extends AbstractDartGenerator
implements Type.Visitor<Void, String>,
Definition.Visitor<Void, String> {
    private final boolean _repeated;
    private final Type _type;
    private final String _value;

    public WriteOperationBuilder(boolean repeated, Type type, String value) {
        this._repeated = repeated;
        this._type = type;
        this._value = value;
    }

    @Override
    protected void generate() {
        if (this._repeated) {
            this.line("json.startArray();");
            this.line("for (var _element in " + this._value + ") {");
            this._type.visit(this, "_element");
            this.line("}");
            this.line("json.endArray();");
        } else {
            this._type.visit(this, this._value);
        }
    }

    @Override
    public Void visit(CustomType self, String var) {
        return self.getDefinition().visit(this, var);
    }

    @Override
    public Void visit(PrimitiveType self, String var) {
        switch (self.getKind()) {
            case BOOL: {
                this.line("json.addBool(" + var + ");");
                return null;
            }
            case FLOAT: 
            case DOUBLE: 
            case FIXED_32: 
            case FIXED_64: 
            case INT_32: 
            case INT_64: 
            case SFIXED_32: 
            case SFIXED_64: 
            case SINT_32: 
            case SINT_64: 
            case UINT_32: 
            case UINT_64: {
                this.line("json.addNumber(" + var + ");");
                return null;
            }
            case BYTES: 
            case STRING: {
                this.line("json.addString(" + var + ");");
                return null;
            }
        }
        throw new IllegalArgumentException("No such type: " + String.valueOf(self));
    }

    @Override
    public Void visit(MapType self, String var) {
        this.line("json.startObject();");
        this.line("for (var x in " + var + ".entries) {");
        this.line("json.addKey(x.key);");
        self.getValueType().visit(this, "x.value");
        this.line("}");
        this.line("json.endObject();");
        return null;
    }

    @Override
    public Void visit(EnumDef self, String var) {
        this.line(DartCoding.writeEnumMethod(self) + "(json, " + var + ");");
        return null;
    }

    @Override
    public Void visit(MessageDef self, String var) {
        if (self.isAbstract()) {
            this.line(var + ".writeTo(json);");
        } else {
            this.line(var + ".writeContent(json);");
        }
        return null;
    }
}

