/*
 * Decompiled with CFR 0.152.
 */
package de.haumacher.msgbuf.generator;

import de.haumacher.msgbuf.generator.CodeConvention;
import de.haumacher.msgbuf.generator.ast.Constant;
import de.haumacher.msgbuf.generator.ast.Definition;
import de.haumacher.msgbuf.generator.ast.DefinitionFile;
import de.haumacher.msgbuf.generator.ast.EnumDef;
import de.haumacher.msgbuf.generator.ast.Field;
import de.haumacher.msgbuf.generator.ast.MessageDef;
import de.haumacher.msgbuf.generator.ast.QName;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class NameTable
implements Definition.Visitor<Void, Void> {
    private final Map<String, Package> _packageByName = new HashMap<String, Package>();
    private final Map<String, Definition> _definitionByName = new HashMap<String, Definition>();

    public void enter(DefinitionFile file) {
        Package pkg = this.mkPackage(file.getPackage());
        for (Definition def : file.getDefinitions()) {
            pkg.enter(file, def);
            def.visit(this, null);
        }
    }

    @Override
    public Void visit(EnumDef self, Void arg) {
        this.enterDef(self);
        for (Constant part : self.getConstants()) {
            part.setOwner(self);
        }
        return null;
    }

    @Override
    public Void visit(MessageDef self, Void arg) {
        this.enterDef(self);
        for (Field part : self.getFields()) {
            part.setOwner(self);
        }
        for (Definition inner : self.getDefinitions()) {
            inner.setOuter(self);
            inner.visit(this, arg);
        }
        return null;
    }

    private void enterDef(Definition def) {
        if (def.getOuter() == null) {
            this._definitionByName.put(def.getName(), def);
        }
    }

    private Package mkPackage(QName qName) {
        String name = qName == null ? "" : CodeConvention.packageName(qName);
        Package result = this._packageByName.get(name);
        if (result == null) {
            result = new Package(name);
            this._packageByName.put(name, result);
        }
        return result;
    }

    public void error(String message) {
        System.err.println(message);
    }

    public Definition lookup(MessageDef context, QName name) {
        String baseName = name.getNames().get(0);
        Definition base = this.lookupBase(context, baseName);
        if (base == null) {
            System.out.println("ERROR: Name cannot be resolved" + (String)(context == null ? "" : " in '" + context.getName() + "'") + ": " + baseName);
            return null;
        }
        for (int n = 1; n < name.getNames().size(); ++n) {
            String nextName = name.getNames().get(n);
            Definition inner = this.lookupInner(base, nextName);
            if (inner == null) {
                System.out.println("ERROR: Name cannot be resolved in '" + base.getName() + "': " + nextName);
                return null;
            }
            base = inner;
        }
        return base;
    }

    private Definition lookupInner(Definition base, String nextName) {
        if (base instanceof MessageDef) {
            Optional<Definition> match = ((MessageDef)base).getDefinitions().stream().filter(d -> nextName.equals(d.getName())).findFirst();
            if (match.isPresent()) {
                return match.get();
            }
            return null;
        }
        return null;
    }

    private Definition lookupBase(MessageDef context, String baseName) {
        while (context != null) {
            Definition inner = this.lookupInner(context, baseName);
            if (inner != null) {
                return inner;
            }
            context = context.getOuter();
        }
        return this._definitionByName.get(baseName);
    }

    class Package {
        private final String _name;
        private final Map<String, Definition> _definitionsByName = new HashMap<String, Definition>();

        public Package(String name) {
            this._name = name;
        }

        public String getName() {
            return this._name;
        }

        public void enter(DefinitionFile file, Definition def) {
            def.setFile(file);
            Definition clash = this._definitionsByName.put(def.getName(), def);
            if (clash != null) {
                NameTable.this.error("Duplicate definition '" + def.getName() + "' in package '" + this.getName() + "'.");
            }
        }
    }
}

