/*
 * Decompiled with CFR 0.152.
 */
package de.haumacher.msgbuf.generator;

import de.haumacher.msgbuf.generator.ast.CustomType;
import de.haumacher.msgbuf.generator.ast.Definition;
import de.haumacher.msgbuf.generator.ast.Field;
import de.haumacher.msgbuf.generator.ast.MapType;
import de.haumacher.msgbuf.generator.ast.MessageDef;
import de.haumacher.msgbuf.generator.ast.Option;
import de.haumacher.msgbuf.generator.ast.StringOption;
import de.haumacher.msgbuf.generator.ast.Type;

public interface FieldOperations {
    public Field self();

    default public boolean isDerived() {
        return this.isReverse() || this.isContainer();
    }

    default public boolean isContainer() {
        return this.self().getOptions().get("Container") != null;
    }

    default public boolean isRef() {
        return this.self().getOptions().get("Ref") != null;
    }

    default public boolean isReverse() {
        return this.getReverseAnnotation() != null;
    }

    default public boolean isReverseOf(String name) {
        return name.equals(this.getReverse());
    }

    default public String getReverse() {
        StringOption reverseOption = (StringOption)this.getReverseAnnotation();
        if (reverseOption == null) {
            return null;
        }
        return reverseOption.getValue();
    }

    default public Option getReverseAnnotation() {
        return this.self().getOptions().get("Reverse");
    }

    default public Field container() {
        if (!this.isDerived() && !this.isRef()) {
            Definition contentDef;
            Type contentType = this.self().getType();
            if (contentType instanceof MapType) {
                contentType = ((MapType)contentType).getValueType();
            }
            if (contentType instanceof CustomType && (contentDef = ((CustomType)contentType).getDefinition()) instanceof MessageDef) {
                return ((MessageDef)contentDef).container();
            }
        }
        return null;
    }
}

