/*
 * Decompiled with CFR 0.152.
 */
package de.haumacher.msgbuf.generator.ast;

import de.haumacher.msgbuf.binary.DataReader;
import de.haumacher.msgbuf.binary.DataWriter;
import de.haumacher.msgbuf.data.ProtocolEnum;
import de.haumacher.msgbuf.generator.ast.Type;
import de.haumacher.msgbuf.json.JsonReader;
import de.haumacher.msgbuf.json.JsonWriter;
import de.haumacher.msgbuf.observer.Observable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class PrimitiveType
extends Type {
    public static final String PRIMITIVE_TYPE__TYPE = "PrimitiveType";
    public static final String KIND = "kind";
    private Kind _kind = Kind.INT_32;
    private static List<String> PROPERTIES = Collections.unmodifiableList(Arrays.asList("kind"));

    public static PrimitiveType create() {
        return new PrimitiveType();
    }

    protected PrimitiveType() {
    }

    @Override
    public Type.TypeKind kind() {
        return Type.TypeKind.PRIMITIVE_TYPE;
    }

    public final Kind getKind() {
        return this._kind;
    }

    public PrimitiveType setKind(Kind value) {
        this.internalSetKind(value);
        return this;
    }

    protected final void internalSetKind(Kind value) {
        if (value == null) {
            throw new IllegalArgumentException("Property 'kind' cannot be null.");
        }
        this._listener.beforeSet((Observable)this, KIND, (Object)value);
        this._kind = value;
    }

    public String jsonType() {
        return PRIMITIVE_TYPE__TYPE;
    }

    public List<String> properties() {
        return PROPERTIES;
    }

    public Object get(String field) {
        switch (field) {
            case "kind": {
                return this.getKind();
            }
        }
        return super.get(field);
    }

    public void set(String field, Object value) {
        switch (field) {
            case "kind": {
                this.internalSetKind((Kind)((Object)value));
                break;
            }
            default: {
                super.set(field, value);
            }
        }
    }

    public static PrimitiveType readPrimitiveType(JsonReader in) throws IOException {
        PrimitiveType result = new PrimitiveType();
        result.readContent(in);
        return result;
    }

    protected void writeFields(JsonWriter out) throws IOException {
        super.writeFields(out);
        out.name(KIND);
        this.getKind().writeTo(out);
    }

    protected void readField(JsonReader in, String field) throws IOException {
        switch (field) {
            case "kind": {
                this.setKind(Kind.readKind(in));
                break;
            }
            default: {
                super.readField(in, field);
            }
        }
    }

    @Override
    public <R, A> R visit(Type.Visitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    public static enum Kind implements ProtocolEnum
    {
        INT_32("INT32"),
        UINT_32("UINT32"),
        SINT_32("SINT32"),
        FIXED_32("FIXED32"),
        SFIXED_32("SFIXED32"),
        INT_64("INT64"),
        UINT_64("UINT64"),
        SINT_64("SINT64"),
        FIXED_64("FIXED64"),
        SFIXED_64("SFIXED64"),
        BOOL("BOOL"),
        STRING("STRING"),
        FLOAT("FLOAT"),
        DOUBLE("DOUBLE"),
        BYTES("BYTES");

        private final String _protocolName;

        private Kind(String protocolName) {
            this._protocolName = protocolName;
        }

        public String protocolName() {
            return this._protocolName;
        }

        public static Kind valueOfProtocol(String protocolName) {
            if (protocolName == null) {
                return null;
            }
            switch (protocolName) {
                case "INT32": {
                    return INT_32;
                }
                case "UINT32": {
                    return UINT_32;
                }
                case "SINT32": {
                    return SINT_32;
                }
                case "FIXED32": {
                    return FIXED_32;
                }
                case "SFIXED32": {
                    return SFIXED_32;
                }
                case "INT64": {
                    return INT_64;
                }
                case "UINT64": {
                    return UINT_64;
                }
                case "SINT64": {
                    return SINT_64;
                }
                case "FIXED64": {
                    return FIXED_64;
                }
                case "SFIXED64": {
                    return SFIXED_64;
                }
                case "BOOL": {
                    return BOOL;
                }
                case "STRING": {
                    return STRING;
                }
                case "FLOAT": {
                    return FLOAT;
                }
                case "DOUBLE": {
                    return DOUBLE;
                }
                case "BYTES": {
                    return BYTES;
                }
            }
            return INT_32;
        }

        public final void writeTo(JsonWriter out) throws IOException {
            out.value(this.protocolName());
        }

        public static Kind readKind(JsonReader in) throws IOException {
            return Kind.valueOfProtocol(in.nextString());
        }

        public final void writeTo(DataWriter out) throws IOException {
            switch (this) {
                case INT_32: {
                    out.value(1);
                    break;
                }
                case UINT_32: {
                    out.value(2);
                    break;
                }
                case SINT_32: {
                    out.value(3);
                    break;
                }
                case FIXED_32: {
                    out.value(4);
                    break;
                }
                case SFIXED_32: {
                    out.value(5);
                    break;
                }
                case INT_64: {
                    out.value(6);
                    break;
                }
                case UINT_64: {
                    out.value(7);
                    break;
                }
                case SINT_64: {
                    out.value(8);
                    break;
                }
                case FIXED_64: {
                    out.value(9);
                    break;
                }
                case SFIXED_64: {
                    out.value(10);
                    break;
                }
                case BOOL: {
                    out.value(11);
                    break;
                }
                case STRING: {
                    out.value(12);
                    break;
                }
                case FLOAT: {
                    out.value(13);
                    break;
                }
                case DOUBLE: {
                    out.value(14);
                    break;
                }
                case BYTES: {
                    out.value(15);
                    break;
                }
                default: {
                    out.value(0);
                }
            }
        }

        public static Kind readKind(DataReader in) throws IOException {
            switch (in.nextInt()) {
                case 1: {
                    return INT_32;
                }
                case 2: {
                    return UINT_32;
                }
                case 3: {
                    return SINT_32;
                }
                case 4: {
                    return FIXED_32;
                }
                case 5: {
                    return SFIXED_32;
                }
                case 6: {
                    return INT_64;
                }
                case 7: {
                    return UINT_64;
                }
                case 8: {
                    return SINT_64;
                }
                case 9: {
                    return FIXED_64;
                }
                case 10: {
                    return SFIXED_64;
                }
                case 11: {
                    return BOOL;
                }
                case 12: {
                    return STRING;
                }
                case 13: {
                    return FLOAT;
                }
                case 14: {
                    return DOUBLE;
                }
                case 15: {
                    return BYTES;
                }
            }
            return INT_32;
        }
    }
}

