/*
 * Decompiled with CFR 0.152.
 */
package de.haumacher.msgbuf.generator;

import de.haumacher.msgbuf.generator.CodeConvention;
import de.haumacher.msgbuf.generator.ast.CustomType;
import de.haumacher.msgbuf.generator.ast.Definition;
import de.haumacher.msgbuf.generator.ast.Field;
import de.haumacher.msgbuf.generator.ast.MapType;
import de.haumacher.msgbuf.generator.ast.PrimitiveType;
import de.haumacher.msgbuf.generator.ast.Type;
import de.haumacher.msgbuf.generator.common.Util;
import java.util.function.Function;

public class TypeGenerator
implements Type.Visitor<String, Boolean> {
    public static final TypeGenerator INSTANCE = new TypeGenerator(null, CodeConvention::typeName);
    public static final TypeGenerator IMPL_INSTANCE = new TypeGenerator("impl", CodeConvention::implName);
    private Function<String, String> _typeNameConvention;
    private String _packageSuffix;

    private TypeGenerator(String packageSuffix, Function<String, String> typeNameConvention) {
        this._packageSuffix = packageSuffix;
        this._typeNameConvention = typeNameConvention;
    }

    public static String mkType(Field field) {
        return TypeGenerator.mkType(field, false);
    }

    public static String mkTypeReadOnly(Field field) {
        return TypeGenerator.mkType(field, true);
    }

    private static String mkType(Field field, boolean readOnly) {
        return field.isRepeated() ? "java.util.List<" + (readOnly ? "? extends " : "") + TypeGenerator.mkTypeWrapped(field.getType()) + ">" : TypeGenerator.mkType(field.getType(), Util.isNullable(field));
    }

    public static String mkType(Type type) {
        return TypeGenerator.mkType(type, false);
    }

    public static String mkType(Type type, boolean nullable) {
        return type.visit(INSTANCE, nullable);
    }

    public static String mkTypeWrapped(Type type) {
        return type.visit(INSTANCE, Boolean.TRUE);
    }

    public static String mkTypeWrappedImpl(Type type) {
        return type.visit(IMPL_INSTANCE, Boolean.TRUE);
    }

    @Override
    public String visit(MapType type, Boolean wrapped) {
        return "java.util.Map<" + TypeGenerator.mkTypeWrapped(type.getKeyType()) + ", " + TypeGenerator.mkTypeWrapped(type.getValueType()) + ">";
    }

    @Override
    public String visit(CustomType type, Boolean wrapped) {
        Definition definition = type.getDefinition();
        if (definition == null) {
            return CodeConvention.qName(type.getName());
        }
        return CodeConvention.qName(this._packageSuffix, definition, this._typeNameConvention);
    }

    @Override
    public String visit(PrimitiveType type, Boolean wrapped) {
        switch (type.getKind()) {
            case BOOL: {
                return wrapped != false ? "Boolean" : "boolean";
            }
            case BYTES: {
                return "byte[]";
            }
            case FLOAT: {
                return wrapped != false ? "Float" : "float";
            }
            case DOUBLE: {
                return wrapped != false ? "Double" : "double";
            }
            case INT_32: 
            case UINT_32: 
            case FIXED_32: 
            case SINT_32: 
            case SFIXED_32: {
                return wrapped != false ? "Integer" : "int";
            }
            case INT_64: 
            case UINT_64: 
            case FIXED_64: 
            case SINT_64: 
            case SFIXED_64: {
                return wrapped != false ? "Long" : "long";
            }
            case STRING: {
                return "String";
            }
        }
        throw new RuntimeException("No such type: " + String.valueOf((Object)type.getKind()));
    }
}

