/*
 * Decompiled with CFR 0.152.
 */
package de.haumacher.msgbuf.generator.util;

import java.util.regex.Pattern;

public class CodeUtil {
    private static final String QUOTE = "\"";
    private static final Pattern NAME_PART_PATTERN = Pattern.compile("(?<=\\p{javaLowerCase})(?=\\p{javaUpperCase})|(?<=\\p{javaLetter})(?=\\p{javaDigit})|(?<=\\p{javaDigit})(?=\\p{javaLetter})|_+");

    public static String camelCase(String name) {
        StringBuilder result = new StringBuilder();
        for (String part : name.split("_+")) {
            result.append(CodeUtil.firstUpperCase(part));
        }
        return result.toString();
    }

    public static String underscored(String name) {
        StringBuilder result = new StringBuilder();
        for (String part : name.split("(?<=\\p{javaLowerCase})(?=\\p{javaUpperCase})")) {
            if (result.length() > 0) {
                result.append('_');
            }
            result.append(part.toLowerCase());
        }
        return result.toString();
    }

    public static String firstUpperCase(String name) {
        return Character.toUpperCase(name.charAt(0)) + name.substring(1);
    }

    public static String allUpperCase(String name) {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (String part : NAME_PART_PATTERN.split(name)) {
            if (first) {
                first = false;
            } else {
                result.append('_');
            }
            result.append(part.toUpperCase());
        }
        return result.toString();
    }

    public static String xmlName(String name) {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (String part : NAME_PART_PATTERN.split(name)) {
            if (first) {
                first = false;
            } else {
                result.append('-');
            }
            result.append(part.toLowerCase());
        }
        return result.toString();
    }

    public static String firstLowerCase(String name) {
        return Character.toLowerCase(name.charAt(0)) + name.substring(1);
    }

    public static String stringLiteral(String str) {
        return QUOTE + str.replace("\\", "\\\\").replace(QUOTE, "\\\"") + QUOTE;
    }
}

