/*
 * Decompiled with CFR 0.152.
 */
package de.haumacher.msgbuf.generator.ast;

import de.haumacher.msgbuf.generator.ast.Constant;
import de.haumacher.msgbuf.generator.ast.Definition;
import de.haumacher.msgbuf.generator.ast.DefinitionFile;
import de.haumacher.msgbuf.generator.ast.MessageDef;
import de.haumacher.msgbuf.generator.ast.Option;
import de.haumacher.msgbuf.generator.ast.WithOptions;
import de.haumacher.msgbuf.json.JsonReader;
import de.haumacher.msgbuf.json.JsonWriter;
import de.haumacher.msgbuf.observer.Observable;
import de.haumacher.msgbuf.util.Conversions;
import de.haumacher.msgbuf.util.ReferenceList;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class EnumDef
extends Definition {
    public static final String ENUM_DEF__TYPE = "EnumDef";
    public static final String CONSTANTS__PROP = "constants";
    private final List<Constant> _constants = new ReferenceList<Constant>(){

        protected void beforeAdd(int index, Constant element) {
            EnumDef.this._listener.beforeAdd((Observable)EnumDef.this, EnumDef.CONSTANTS__PROP, index, (Object)element);
        }

        protected void afterRemove(int index, Constant element) {
            EnumDef.this._listener.afterRemove((Observable)EnumDef.this, EnumDef.CONSTANTS__PROP, index, (Object)element);
        }
    };
    private static List<String> PROPERTIES = Collections.unmodifiableList(Arrays.asList("constants"));

    public static EnumDef create() {
        return new EnumDef();
    }

    protected EnumDef() {
    }

    @Override
    public WithOptions.TypeKind kind() {
        return WithOptions.TypeKind.ENUM_DEF;
    }

    public final List<Constant> getConstants() {
        return this._constants;
    }

    public EnumDef setConstants(List<? extends Constant> value) {
        this.internalSetConstants(value);
        return this;
    }

    protected final void internalSetConstants(List<? extends Constant> value) {
        if (value == null) {
            throw new IllegalArgumentException("Property 'constants' cannot be null.");
        }
        this._constants.clear();
        this._constants.addAll(value);
    }

    public EnumDef addConstant(Constant value) {
        this.internalAddConstant(value);
        return this;
    }

    protected final void internalAddConstant(Constant value) {
        this._constants.add(value);
    }

    public final void removeConstant(Constant value) {
        this._constants.remove((Object)value);
    }

    @Override
    public EnumDef setName(String value) {
        this.internalSetName(value);
        return this;
    }

    @Override
    public EnumDef setFile(DefinitionFile value) {
        this.internalSetFile(value);
        return this;
    }

    @Override
    public EnumDef setOuter(MessageDef value) {
        this.internalSetOuter(value);
        return this;
    }

    @Override
    public EnumDef setComment(String value) {
        this.internalSetComment(value);
        return this;
    }

    @Override
    public EnumDef setOptions(Map<String, Option> value) {
        this.internalSetOptions(value);
        return this;
    }

    @Override
    public EnumDef putOption(String key, Option value) {
        this.internalPutOption(key, value);
        return this;
    }

    public String jsonType() {
        return ENUM_DEF__TYPE;
    }

    @Override
    public List<String> properties() {
        return PROPERTIES;
    }

    @Override
    public Object get(String field) {
        switch (field) {
            case "constants": {
                return this.getConstants();
            }
        }
        return super.get(field);
    }

    @Override
    public void set(String field, Object value) {
        switch (field) {
            case "constants": {
                this.internalSetConstants(Conversions.asList(Constant.class, (Object)value));
                break;
            }
            default: {
                super.set(field, value);
            }
        }
    }

    public static EnumDef readEnumDef(JsonReader in) throws IOException {
        EnumDef result = new EnumDef();
        result.readContent(in);
        return result;
    }

    @Override
    protected void writeFields(JsonWriter out) throws IOException {
        super.writeFields(out);
        out.name(CONSTANTS__PROP);
        out.beginArray();
        for (Constant x : this.getConstants()) {
            x.writeContent(out);
        }
        out.endArray();
    }

    @Override
    protected void readField(JsonReader in, String field) throws IOException {
        switch (field) {
            case "constants": {
                in.beginArray();
                while (in.hasNext()) {
                    this.addConstant(Constant.readConstant(in));
                }
                in.endArray();
                break;
            }
            default: {
                super.readField(in, field);
            }
        }
    }

    @Override
    public <R, A> R visit(Definition.Visitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }
}

