/*
 * Decompiled with CFR 0.152.
 */
package de.haumacher.msgbuf.generator;

import de.haumacher.msgbuf.generator.CodeConvention;
import de.haumacher.msgbuf.generator.ast.Flag;
import de.haumacher.msgbuf.generator.ast.MessageDef;
import de.haumacher.msgbuf.generator.ast.Option;
import de.haumacher.msgbuf.generator.util.AbstractJavaGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class AbstractMessageGenerator
extends AbstractJavaGenerator {
    private Map<String, Option> _options;
    protected final boolean _noInterfaces;
    protected final String _packageSuffix;

    public AbstractMessageGenerator(Map<String, Option> options, String packageSuffix) {
        this._options = options;
        this._noInterfaces = AbstractMessageGenerator.isTrue(options.get("NoInterfaces"), false);
        this._packageSuffix = packageSuffix;
    }

    protected AbstractMessageGenerator(Map<String, Option> options) {
        this(options, null);
    }

    public Map<String, Option> getOptions() {
        return this._options;
    }

    public static boolean isTrue(Option option, boolean defaultValue) {
        return option == null ? defaultValue : ((Flag)option).isValue();
    }

    protected final String implName(MessageDef def) {
        if (this._noInterfaces) {
            return CodeConvention.typeName(def);
        }
        return CodeConvention.implName(def);
    }

    protected String qImplName(MessageDef def) {
        if (this._noInterfaces) {
            return CodeConvention.qTypeName(def);
        }
        return CodeConvention.qImplName("impl", def);
    }

    protected static List<MessageDef> concreteSpecializations(MessageDef def) {
        ArrayList<MessageDef> result = new ArrayList<MessageDef>();
        AbstractMessageGenerator.addConcreteSpecializations(result, def);
        return result;
    }

    private static void addConcreteSpecializations(ArrayList<MessageDef> result, MessageDef def) {
        if (!def.isAbstract()) {
            result.add(def);
        }
        for (MessageDef specialization : def.getSpecializations()) {
            AbstractMessageGenerator.addConcreteSpecializations(result, specialization);
        }
    }
}

