/*
 * Decompiled with CFR 0.152.
 */
package de.haumacher.msgbuf.generator;

import de.haumacher.msgbuf.generator.CodeConvention;
import de.haumacher.msgbuf.generator.EnumGenerator;
import de.haumacher.msgbuf.generator.FieldIDSynthesizer;
import de.haumacher.msgbuf.generator.GeneratorPlugin;
import de.haumacher.msgbuf.generator.MessageGenerator;
import de.haumacher.msgbuf.generator.NameTable;
import de.haumacher.msgbuf.generator.TypeIdSynthesizer;
import de.haumacher.msgbuf.generator.ast.CustomType;
import de.haumacher.msgbuf.generator.ast.Definition;
import de.haumacher.msgbuf.generator.ast.DefinitionFile;
import de.haumacher.msgbuf.generator.ast.EnumDef;
import de.haumacher.msgbuf.generator.ast.Field;
import de.haumacher.msgbuf.generator.ast.MapType;
import de.haumacher.msgbuf.generator.ast.MessageDef;
import de.haumacher.msgbuf.generator.ast.Option;
import de.haumacher.msgbuf.generator.ast.PrimitiveType;
import de.haumacher.msgbuf.generator.ast.QName;
import de.haumacher.msgbuf.generator.ast.StringOption;
import de.haumacher.msgbuf.generator.ast.Type;
import de.haumacher.msgbuf.generator.dart.DartLibGenerator;
import de.haumacher.msgbuf.generator.parser.ParseException;
import de.haumacher.msgbuf.generator.parser.ProtobufParser;
import de.haumacher.msgbuf.generator.parser.Token;
import de.haumacher.msgbuf.generator.util.FileGenerator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;

public class Generator {
    public static final String OUTPUT_DIR_ARG = "-out";
    private NameTable _table = new NameTable();
    private File _out = new File(".");
    private List<DefinitionFile> _files = new ArrayList<DefinitionFile>();

    public void setOut(File out) {
        this._out = out;
    }

    public DefinitionFile load(String fileName) throws IOException, ParseException {
        return this.load(new File(fileName));
    }

    public DefinitionFile load(File file) throws ParseException, IOException, FileNotFoundException {
        try (FileInputStream in = new FileInputStream(file);){
            DefinitionFile definitionFile = this.load(in);
            return definitionFile;
        }
    }

    public DefinitionFile load(InputStream in) throws ParseException {
        return this.load(Generator.parse(in));
    }

    public static DefinitionFile parse(InputStream in) throws ParseException {
        ProtobufParser parser = new ProtobufParser(in, "utf-8");
        DefinitionFile definition = parser.file();
        Token nextToken = parser.getNextToken();
        if (nextToken.kind != 0) {
            throw new ParseException("Unexpected token '" + nextToken + "' at line " + nextToken.beginLine + " column " + nextToken.beginColumn + " .");
        }
        return definition;
    }

    public DefinitionFile load(DefinitionFile file) {
        this._files.add(file);
        this._table.enter(file);
        return file;
    }

    public void generate(GeneratorPlugin plugin) {
        for (DefinitionFile definitionFile : this._files) {
            this.buildSpecializations(definitionFile);
        }
        TypeIdSynthesizer typeIdSynthesizer = new TypeIdSynthesizer();
        for (DefinitionFile file : this._files) {
            typeIdSynthesizer.process(file);
        }
        FieldIDSynthesizer fieldIDSynthesizer = new FieldIDSynthesizer();
        for (DefinitionFile file : this._files) {
            fieldIDSynthesizer.process(file);
        }
        for (DefinitionFile file : this._files) {
            plugin.init(file.getOptions());
            File dir = this.mkdir(file.getPackage());
            PackageGenerator packageGenerator = new PackageGenerator(dir, file.getOptions(), plugin);
            for (Definition def : file.getDefinitions()) {
                def.visit(packageGenerator, null);
            }
            Option dartLib = file.getOptions().get("DartLib");
            if (dartLib == null) continue;
            new DartLibGenerator(new File(this._out, ((StringOption)dartLib).getValue()), file).run();
        }
    }

    private void buildSpecializations(DefinitionFile file) {
        final NameTable table = this._table;
        final Type.Visitor<Void, MessageDef> typeResolver = new Type.Visitor<Void, MessageDef>(){

            @Override
            public Void visit(CustomType self, MessageDef context) {
                self.setDefinition(table.lookup(context, self.getName()));
                return null;
            }

            @Override
            public Void visit(PrimitiveType self, MessageDef context) {
                return null;
            }

            @Override
            public Void visit(MapType self, MessageDef context) {
                self.getKeyType().visit(this, context);
                self.getValueType().visit(this, context);
                return null;
            }
        };
        Definition.Visitor<Void, Void> indexer = new Definition.Visitor<Void, Void>(){

            @Override
            public Void visit(MessageDef def, Void arg) {
                QName generalizationName = def.getExtends();
                if (generalizationName != null) {
                    MessageDef ref = (MessageDef)table.lookup(def, generalizationName);
                    if (ref == null) {
                        Generator.this.error("Referenced type '" + CodeConvention.qTypeName(generalizationName) + "' not found.");
                    } else {
                        def.setExtendedDef(ref);
                        ref.addSpecialization(def);
                    }
                }
                for (Definition inner : def.getDefinitions()) {
                    inner.visit(this, arg);
                }
                for (Field field : def.getFields()) {
                    field.getType().visit(typeResolver, def);
                }
                return null;
            }

            @Override
            public Void visit(EnumDef def, Void arg) {
                return null;
            }
        };
        for (Definition def : file.getDefinitions()) {
            def.visit(indexer, null);
        }
    }

    private File mkdir(QName pkgName) {
        File result = this._out;
        if (pkgName != null) {
            for (String name : pkgName.getNames()) {
                result = new File(result, name);
            }
        }
        result.mkdirs();
        return result;
    }

    protected void error(String message) {
        this.error(message, null);
    }

    protected void error(String message, IOException ex) {
        System.out.println(message);
        if (ex != null) {
            ex.printStackTrace();
        }
    }

    public static void main(String ... args) throws ParseException, IOException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        if (args.length == 0) {
            Generator.printHelp();
            return;
        }
        File out = null;
        Generator generator = new Generator();
        int n = 0;
        int cnt = args.length;
        while (n < cnt) {
            String arg;
            if ((arg = args[n++]).equals(OUTPUT_DIR_ARG)) {
                out = new File(args[n++]);
                continue;
            }
            if (arg.equals("-h")) {
                Generator.printHelp();
                return;
            }
            File file = new File(arg);
            DefinitionFile content = generator.load(file);
            if (out != null) continue;
            out = Generator.findBase(file, content);
        }
        if (out != null) {
            generator.setOut(out);
        }
        ServiceLoader<GeneratorPlugin> pluginLoader = ServiceLoader.load(GeneratorPlugin.class);
        GeneratorPlugin plugin = GeneratorPlugin.none();
        for (GeneratorPlugin p : pluginLoader) {
            plugin = plugin.andThen(p);
        }
        generator.generate(plugin);
    }

    private static void printHelp() {
        System.err.println("Usage: java -jar " + Generator.class.getName() + " -out <java-output-dir> <protocol-definition.proto>*");
    }

    private static File findBase(File protoFile, DefinitionFile content) {
        File result = protoFile.getParentFile();
        if (content.getPackage() != null) {
            int cnt = content.getPackage().getNames().size();
            for (int n = 0; n < cnt; ++n) {
                result = result.getParentFile();
            }
        }
        return result;
    }

    class PackageGenerator
    implements Definition.Visitor<Void, Void> {
        private final File _dir;
        private final Map<String, Option> _options;
        private final GeneratorPlugin _plugin;

        public PackageGenerator(File dir, Map<String, Option> options, GeneratorPlugin plugin) {
            this._dir = dir;
            this._options = options;
            this._plugin = plugin;
        }

        @Override
        public Void visit(EnumDef def, Void arg) {
            return this.generateJava(CodeConvention.typeName(def), null, new EnumGenerator(def));
        }

        @Override
        public Void visit(MessageDef def, Void arg) {
            boolean noInterfaces = MessageGenerator.isTrue(this._options.get("NoInterfaces"), false);
            if (!noInterfaces) {
                this.generateJava(CodeConvention.typeName(def), null, new MessageGenerator(Generator.this._table, this._options, true, null, def, this._plugin));
            }
            String packageSuffix = noInterfaces ? null : "impl";
            return this.generateJava(noInterfaces ? CodeConvention.typeName(def) : CodeConvention.implName(def), packageSuffix, new MessageGenerator(Generator.this._table, this._options, false, packageSuffix, def, this._plugin));
        }

        private <D extends Definition> Void generateJava(String name, String packageSuffix, FileGenerator generator) {
            File dir = this._dir;
            if (packageSuffix != null) {
                File old = new File(this._dir, name + ".java");
                old.delete();
                dir = new File(dir, packageSuffix);
            }
            dir.mkdirs();
            File out = new File(dir, name + ".java");
            try (FileOutputStream os = new FileOutputStream(out);
                 PrintWriter w = new PrintWriter(new OutputStreamWriter((OutputStream)os, "utf-8"));){
                System.out.println("Generating '" + out + "'.");
                generator.generate(w, 0);
            }
            catch (IOException ex) {
                Generator.this.error("Error writing file '" + out + "'.", ex);
            }
            return null;
        }
    }
}

