/*
 * Decompiled with CFR 0.152.
 */
package de.haumacher.msgbuf.generator.ast;

import de.haumacher.msgbuf.generator.ast.Definition;
import de.haumacher.msgbuf.generator.ast.Option;
import de.haumacher.msgbuf.generator.ast.QName;
import de.haumacher.msgbuf.generator.ast.WithOptions;
import de.haumacher.msgbuf.json.JsonReader;
import de.haumacher.msgbuf.json.JsonWriter;
import de.haumacher.msgbuf.observer.Observable;
import de.haumacher.msgbuf.util.Conversions;
import de.haumacher.msgbuf.util.ReferenceList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class DefinitionFile
extends WithOptions {
    public static final String DEFINITION_FILE__TYPE = "DefinitionFile";
    public static final String PACKAGE__PROP = "package";
    public static final String DEFINITIONS__PROP = "definitions";
    private QName _package = null;
    private final List<Definition> _definitions = new ReferenceList<Definition>(){

        protected void beforeAdd(int index, Definition element) {
            DefinitionFile.this._listener.beforeAdd((Observable)DefinitionFile.this, DefinitionFile.DEFINITIONS__PROP, index, (Object)element);
        }

        protected void afterRemove(int index, Definition element) {
            DefinitionFile.this._listener.afterRemove((Observable)DefinitionFile.this, DefinitionFile.DEFINITIONS__PROP, index, (Object)element);
        }
    };
    private static List<String> PROPERTIES = Collections.unmodifiableList(Arrays.asList("package", "definitions"));

    public static DefinitionFile create() {
        return new DefinitionFile();
    }

    protected DefinitionFile() {
    }

    @Override
    public WithOptions.TypeKind kind() {
        return WithOptions.TypeKind.DEFINITION_FILE;
    }

    public final QName getPackage() {
        return this._package;
    }

    public DefinitionFile setPackage(QName value) {
        this.internalSetPackage(value);
        return this;
    }

    protected final void internalSetPackage(QName value) {
        this._listener.beforeSet((Observable)this, PACKAGE__PROP, (Object)value);
        this._package = value;
    }

    public final boolean hasPackage() {
        return this._package != null;
    }

    public final List<Definition> getDefinitions() {
        return this._definitions;
    }

    public DefinitionFile setDefinitions(List<? extends Definition> value) {
        this.internalSetDefinitions(value);
        return this;
    }

    protected final void internalSetDefinitions(List<? extends Definition> value) {
        if (value == null) {
            throw new IllegalArgumentException("Property 'definitions' cannot be null.");
        }
        this._definitions.clear();
        this._definitions.addAll(value);
    }

    public DefinitionFile addDefinition(Definition value) {
        this.internalAddDefinition(value);
        return this;
    }

    protected final void internalAddDefinition(Definition value) {
        this._definitions.add(value);
    }

    public final void removeDefinition(Definition value) {
        this._definitions.remove((Object)value);
    }

    @Override
    public DefinitionFile setOptions(Map<String, Option> value) {
        this.internalSetOptions(value);
        return this;
    }

    @Override
    public DefinitionFile putOption(String key, Option value) {
        this.internalPutOption(key, value);
        return this;
    }

    public String jsonType() {
        return DEFINITION_FILE__TYPE;
    }

    @Override
    public List<String> properties() {
        return PROPERTIES;
    }

    @Override
    public Object get(String field) {
        switch (field) {
            case "package": {
                return this.getPackage();
            }
            case "definitions": {
                return this.getDefinitions();
            }
        }
        return super.get(field);
    }

    @Override
    public void set(String field, Object value) {
        switch (field) {
            case "package": {
                this.internalSetPackage((QName)((Object)value));
                break;
            }
            case "definitions": {
                this.internalSetDefinitions(Conversions.asList(Definition.class, (Object)value));
                break;
            }
            default: {
                super.set(field, value);
            }
        }
    }

    public static DefinitionFile readDefinitionFile(JsonReader in) throws IOException {
        DefinitionFile result = new DefinitionFile();
        result.readContent(in);
        return result;
    }

    @Override
    protected void writeFields(JsonWriter out) throws IOException {
        super.writeFields(out);
        if (this.hasPackage()) {
            out.name(PACKAGE__PROP);
            this.getPackage().writeTo(out);
        }
        out.name(DEFINITIONS__PROP);
        out.beginArray();
        for (Definition x : this.getDefinitions()) {
            x.writeTo(out);
        }
        out.endArray();
    }

    @Override
    protected void readField(JsonReader in, String field) throws IOException {
        switch (field) {
            case "package": {
                this.setPackage(QName.readQName(in));
                break;
            }
            case "definitions": {
                ArrayList<Definition> newValue = new ArrayList<Definition>();
                in.beginArray();
                while (in.hasNext()) {
                    newValue.add(Definition.readDefinition(in));
                }
                in.endArray();
                this.setDefinitions(newValue);
                break;
            }
            default: {
                super.readField(in, field);
            }
        }
    }

    @Override
    public <R, A> R visit(WithOptions.Visitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }
}

