/*
 * Decompiled with CFR 0.152.
 */
package de.haumacher.msgbuf.generator.dart;

import de.haumacher.msgbuf.generator.ast.Constant;
import de.haumacher.msgbuf.generator.ast.Definition;
import de.haumacher.msgbuf.generator.ast.EnumDef;
import de.haumacher.msgbuf.generator.ast.Field;
import de.haumacher.msgbuf.generator.ast.MessageDef;
import de.haumacher.msgbuf.generator.common.MsgBufJsonProtocol;
import de.haumacher.msgbuf.generator.common.Util;
import de.haumacher.msgbuf.generator.dart.InitializerGenerator;
import de.haumacher.msgbuf.generator.dart.TypeNameBuilder;
import de.haumacher.msgbuf.generator.util.CodeUtil;

public class DartCoding {
    public static String literalName(Constant constant) {
        return CodeUtil.firstLowerCase(CodeUtil.camelCase(CodeUtil.underscored(constant.getName())));
    }

    public static String typeName(Definition def) {
        return def.getName();
    }

    public static String writeEnumMethod(EnumDef enumDef) {
        return "write" + DartCoding.typeName(enumDef);
    }

    public static String readEnumMethod(EnumDef enumDef) {
        return "read" + DartCoding.typeName(enumDef);
    }

    public static String stringLiteral(String value) {
        return "\"" + value.replace("\"", "\\\"") + "\"";
    }

    public static String visitorName(MessageDef def) {
        return DartCoding.typeName(def) + "Visitor";
    }

    public static String jsonTypeIdLiteral(MessageDef def) {
        return DartCoding.stringLiteral(MsgBufJsonProtocol.typeId(def));
    }

    public static String visitCaseMethod(MessageDef def) {
        return "visit" + DartCoding.typeName(def);
    }

    public static String typeName(Field field) {
        return field.getType().visit(TypeNameBuilder.INSTANCE, field);
    }

    public static String fieldName(Field field) {
        return field.getName();
    }

    public static String initializer(Field field) {
        if (Util.isNullable(field)) {
            return "";
        }
        return field.getType().visit(InitializerGenerator.INSTANCE, field);
    }

    public static String jsonName(Field field) {
        return DartCoding.stringLiteral(MsgBufJsonProtocol.fieldId(field));
    }

    public static String visitMethod(MessageDef def) {
        return "visit" + DartCoding.typeName(def);
    }
}

