/*
 * Decompiled with CFR 0.152.
 */
package de.haumacher.msgbuf.generator.dart;

import de.haumacher.msgbuf.generator.ast.Constant;
import de.haumacher.msgbuf.generator.ast.EnumDef;
import de.haumacher.msgbuf.generator.common.MsgBufJsonProtocol;
import de.haumacher.msgbuf.generator.dart.DartCoding;
import de.haumacher.msgbuf.generator.util.AbstractDartGenerator;

public class DartEnumGenerator
extends AbstractDartGenerator {
    private EnumDef _def;

    public DartEnumGenerator(EnumDef def) {
        this._def = def;
    }

    @Override
    protected void generate() {
        this.docComment(this._def.getComment());
        String typeName = DartCoding.typeName(this._def);
        this.line("enum " + typeName + " {");
        for (Constant constant : this._def.getConstants()) {
            this.docComment(constant.getComment());
            this.line(DartCoding.literalName(constant) + ",");
        }
        this.line("}");
        this.nl();
        this.line("/// Writes a value of " + typeName + " to a JSON stream.");
        this.line("void " + DartCoding.writeEnumMethod(this._def) + "(JsonSink json, " + typeName + " value) {");
        this.line("switch (value) {");
        for (Constant constant : this._def.getConstants()) {
            String protocolValue = DartEnumGenerator.nameLiteral(constant);
            this.line("case " + typeName + "." + DartCoding.literalName(constant) + ": json.addString(" + protocolValue + "); break;");
        }
        this.line("default: throw (\"No such literal: \" + value.name);");
        this.line("}");
        this.line("}");
        this.nl();
        this.line("/// Reads a value of " + typeName + " from a JSON stream.");
        this.line(typeName + " " + DartCoding.readEnumMethod(this._def) + "(JsonReader json) {");
        this.line("switch (json.expectString()) {");
        for (Constant constant : this._def.getConstants()) {
            this.line("case " + DartEnumGenerator.nameLiteral(constant) + ": return " + typeName + "." + DartCoding.literalName(constant) + ";");
        }
        this.line("default: return " + typeName + "." + DartCoding.literalName(this._def.getConstants().get(0)) + ";");
        this.line("}");
        this.line("}");
        this.nl();
    }

    private static String nameLiteral(Constant constant) {
        return DartCoding.stringLiteral(MsgBufJsonProtocol.classifierId(constant));
    }
}

