/*
 * Decompiled with CFR 0.152.
 */
package de.haumacher.msgbuf.generator.dart;

import de.haumacher.msgbuf.generator.ast.Definition;
import de.haumacher.msgbuf.generator.ast.DefinitionFile;
import de.haumacher.msgbuf.generator.ast.EnumDef;
import de.haumacher.msgbuf.generator.ast.MessageDef;
import de.haumacher.msgbuf.generator.dart.DartClassGenerator;
import de.haumacher.msgbuf.generator.dart.DartEnumGenerator;
import de.haumacher.msgbuf.generator.util.AbstractDartGenerator;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOError;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class DartLibGenerator
extends AbstractDartGenerator
implements Definition.Visitor<Void, Void> {
    private File _file;
    private DefinitionFile _proto;

    public DartLibGenerator(File file, DefinitionFile proto) {
        this._file = file;
        this._proto = proto;
    }

    public void run() {
        System.out.println("Generating '" + this._file + "'.");
        try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(this._file), "utf8");){
            this.generate(out, 0);
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    @Override
    protected void generate() {
        this.line("import 'package:jsontool/jsontool.dart';");
        this.nl();
        this.writeBaseClass();
        for (Definition def : this._proto.getDefinitions()) {
            def.visit(this, null);
        }
    }

    private void writeBaseClass() {
        this.line("/// Common functionality for JSON generation and parsing.");
        this.line("abstract class _JsonObject {");
        this.line("@override");
        this.line("String toString() {");
        this.line("var buffer = StringBuffer();");
        this.line("writeTo(jsonStringWriter(buffer));");
        this.line("return buffer.toString();");
        this.line("}");
        this.nl();
        this.line("/// The ID to announce the type of the object.");
        this.line("String _jsonType();");
        this.nl();
        this.line("/// Reads the object contents (after the type information).");
        this.line("void _readContent(JsonReader json) {");
        this.line("json.expectObject();");
        this.line("while (json.hasNextKey()) {");
        this.line("var key = json.nextKey();");
        this.line("_readProperty(key!, json);");
        this.line("}");
        this.line("}");
        this.nl();
        this.line("/// Reads the value of the property with the given name.");
        this.line("void _readProperty(String key, JsonReader json) {");
        this.line("json.skipAnyValue();");
        this.line("}");
        this.nl();
        this.line("/// Writes this object to the given writer (including type information).");
        this.line("void writeTo(JsonSink json) {");
        this.line("json.startArray();");
        this.line("json.addString(_jsonType());");
        this.line("writeContent(json);");
        this.line("json.endArray();");
        this.line("}");
        this.nl();
        this.line("/// Writes the contents of this object to the given writer (excluding type information).");
        this.line("void writeContent(JsonSink json) {");
        this.line("json.startObject();");
        this.line("_writeProperties(json);");
        this.line("json.endObject();");
        this.line("}");
        this.nl();
        this.line("/// Writes all key/value pairs of this object.");
        this.line("void _writeProperties(JsonSink json) {");
        this.line("// No properties.");
        this.line("}");
        this.line("}");
        this.nl();
    }

    @Override
    public Void visit(EnumDef self, Void arg) {
        this.include(new DartEnumGenerator(self));
        return null;
    }

    @Override
    public Void visit(MessageDef self, Void arg) {
        this.include(new DartClassGenerator(self));
        return null;
    }
}

